/*
 * JabberRoster.rexx
 *
 * Saves contacts from roster to textfile and
 * Adds contacts to roster from saved text file
 *
 * Roger Clark (kaedric@sbcglobal.net) 18-Sep-2003
 *
 * Version 1.1
 *
 */

Options Results
Parse Arg Opt

If ~show(L,"rexxsupport.library") then Do
  If ~addlib("rexxsupport.library",0,-30,0) then Do
    Say "Could not access the rexxsupport.library!"
    Exit 20
  End
End


If Upper(Opt) = "SAVE" then Signal SaveRoster
If Upper(Opt) = "ADD" then Signal AddRoster

Say "Command Format: RX JabberRoster [Add/Save]"
Exit


AddRoster:
Call GetAgents
Call Open(In,"T:JabberRoster","R")
 Do Forever
  JabberID = ReadLn(In)
  If JabberID = "" Then Leave
  Parse var JabberID JName"@"JServer
  If (Left(JServer,6) = "yahoo." | Left(JServer,4) = "yim.") & yserv ~= "YSERV" then JabberID = JName||"@"||yserv
  If (Left(JServer,4) = "aim." | Left(JServer,4) = "aol.") & aserv ~= "ASERV" then JabberID = JName||"@"||aserv
  If Left(JServer,4) = "icq." & iserv ~= "ISERV" then JabberID = JName||"@"||iserv
  If Left(JServer,4) = "msn." & mserv ~= "MSERV" then JabberID = JName||"@"||mserv
  Friend = ReadLn(In)
  If Friend = "" Then Friend = JabberID
  Say "Adding and Authorizing "Friend
  Address 'JABBERWOCKY.1' 'ADDCONTACT JID "'JabberID'"'
  Call Delay(50)
  XMLString = "<iq type='set'><query xmlns='jabber:iq:roster'><item jid='"JabberID"' name='"Friend"'/></query></iq>"
  Address 'JABBERWOCKY.1' 'SENDRAW XML "'XMLString'"'
  Call Delay(50)
  XMLString = "<presence type='subscribed' to='"JabberID"'/>"
  Address 'JABBERWOCKY.1' 'SENDRAW XML "'XMLString'"'
 End
 Call Close(Out)
Exit

SaveRoster:
Address 'JABBERWOCKY.1' GETROSTER STEM Roster
Call Open(Out,"T:JabberRoster","W")
 Do Loop = 0 to Roster.count - 1
  If Roster.Loop.User = "ROSTER."||Loop||".USER" Then Iterate
  If (Roster.Loop.Name = "ROSTER."||Loop||".NAME") Then Roster.Loop.Name = Roster.Loop.User
  Call WriteLn(Out,Roster.Loop.User||"@"||Roster.Loop.Server)
  Call WriteLn(Out,Roster.Loop.Name)
 End
 Call Close(Out)
Exit

GetAgents:
Address 'JABBERWOCKY.1' GETROSTER STEM Roster
Do Loop = 0 to Roster.count - 1
 If (Roster.Loop.User = "ROSTER."||Loop||".USER") & (Roster.Loop.Server ~= "ROSTER."||Loop||".SERVER") Then Do
  If Left(Roster.Loop.Server,6) = "yahoo." | Left(Roster.Loop.Server,4) = "yim." then Do
   yserv = Roster.Loop.Server
   XMLString = "<iq type='set'><query xmlns='jabber:iq:roster'><item jid='"Roster.Loop.Server"' name='** Yahoo Transport'/></query></iq>"
   Address 'JABBERWOCKY.1' 'SENDRAW XML "'XMLString'"'
   Call Delay(50)
   XMLString = "<presence type='subscribed' to='"Roster.Loop.Server"'/>"
   Address 'JABBERWOCKY.1' 'SENDRAW XML "'XMLString'"'
  End
  If Left(Roster.Loop.Server,4) = "aim." | Left(Roster.Loop.Server,4) = "aol." then Do
   aserv = Roster.Loop.Server
   XMLString = "<iq type='set'><query xmlns='jabber:iq:roster'><item jid='"Roster.Loop.Server"' name='** AOL Transport'/></query></iq>"
   Address 'JABBERWOCKY.1' 'SENDRAW XML "'XMLString'"'
   Call Delay(50)
   XMLString = "<presence type='subscribed' to='"Roster.Loop.Server"'/>"
   Address 'JABBERWOCKY.1' 'SENDRAW XML "'XMLString'"'
  End
  If Left(Roster.Loop.Server,4) = "icq." then Do
   iserv = Roster.Loop.Server
   XMLString = "<iq type='set'><query xmlns='jabber:iq:roster'><item jid='"Roster.Loop.Server"' name='** ICQ Transport'/></query></iq>"
   Address 'JABBERWOCKY.1' 'SENDRAW XML "'XMLString'"'
   Call Delay(50)
   XMLString = "<presence type='subscribed' to='"Roster.Loop.Server"'/>"
   Address 'JABBERWOCKY.1' 'SENDRAW XML "'XMLString'"'
  End
  If Left(Roster.Loop.Server,4) = "msn." then Do
   mserv = Roster.Loop.Server
   XMLString = "<iq type='set'><query xmlns='jabber:iq:roster'><item jid='"Roster.Loop.Server"' name='** MSN Transport'/></query></iq>"
   Address 'JABBERWOCKY.1' 'SENDRAW XML "'XMLString'"'
   Call Delay(50)
   XMLString = "<presence type='subscribed' to='"Roster.Loop.Server"'/>"
   Address 'JABBERWOCKY.1' 'SENDRAW XML "'XMLString'"'
  End
 End
End
Return
