#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include <fcntl.h>
#include <fctype.h>
#include <sys/stat.h>
#include <exec/types.h>
#include <libraries/dosextens.h>

#include <devices/tpt.h>

#include <dlg/dlg.h>
#include <dlg/msg.h>
#include <dlg/file.h>
#include <dlg/log.h>
#include <dlg/resman.h>
#include <dlg/user.h>
#include <dlg/menu.h>
#include <dlg/misc.h>
#include <dlg/portconfig.h>

#include <link/config.h>
#include <link/file.h>
#include <link/io.h>
#include <link/user.h>

#include <proto/dos.h>
#include <proto/exec.h>
#include <proto/dlg.h>

#include <pragmas/dlg.h>

#include <private/Version.h>
#define  ObjRev "6"
const UBYTE version[]="\0$VER: UserOptions " BUILDVER "." ObjRev " " COPYRIGHT " by Digerati Dreams "__AMIGADATE__;


void  main              (int, char **);
void  Edit_User         (char *);
void  Print_User        (char *);
void  Edit_Search_Areas (char);
void  List_Search_Areas (char);
void  Read_Search_Areas (char);
BOOL  InsureArea        (long, char);
void  Write_Search_Areas(char);
BOOL  SelectSIG         (char);
int   SortSearchArea    (long *, long *);
void  Get_Computer_Type (char, char *);
void  GetAnsi           (void);
BOOL  Area_Clearance    (long, char);
void _CXBRK             (void);
void  CleanUp           (char *);
BOOL  DeleteGlobalAreas (void);

#define INSTACK RStruct.Command_Stack[0]
#define STK     RStruct.Command_Stack
#define HOT     UserDat.Hot_Keys

BPTR                   sout;
struct USER_DATA       UserDat;
struct Ram_File        RStruct;
struct Global_Settings Globals;
struct SIG_Def         Sig;

USHORT pos = 0;
char   Ext[5];
char   zflag;

long   HighSearchArea;
long  *SearchArea;
long   NumberOfSearchAreas = 0;
char   areafile[80];

char   jgt[128];

/// short menu for autosearch areas
struct ShortMenu Menu[7]      = {{'A',"Add Area",1},
                                 {'R',"Remove Area",1},
                                 {'L',"List Areas",1},
                                 {'J',"Add All",1},
                                 {'D',"Delete All",1},
                                 {'Q',"Sort",1},
                                 {'S',"Select SIG",1}
                                };
//-

/// menu for upper (two column) part of options
struct twocoldata data2[11]   = {{"1","Alias",""},
                                 {"2","Address",""},
                                 {"3","Terminal",""},
                                 {"4","City",""},
                                 {"5","Password",""},
                                 {"6","State/Prv",""},
                                 {"--","Joined",""},
                                 {"7","Country",""},
                                 {"--","Lst Login",""},
                                 {"8","Pst/Zip",""},
                                 {"9","Phone No.",""}
                                };
//-

/// menu for lower (three column) part of options
struct threecoldata data3[38] = {{"10","Help Level",""},
                                 {"--","User Level",""},
                                 {"11","Screen Len",""},
                                 {"12","More Prmpt",""},
                                 {"--","Dly Limit",""},
                                 {"13","Scrn Width",""},
                                 {"14","Ansi Flags",""},
                                 {"--","Sesn Limit",""},
                                 {"--","Msgs Read",""},
                                 {"15","Hot Keys",""},
                                 {"--","Used Today",""},
                                 {"--","Files Upld",""},
                                 {"16","Lex Flag",""},
                                 {"--","Num Calls",""},
                                 {"--","'K' Upld",""},
                                 {"--","Pop Screen",""},
                                 {"--","Dir Limit",""},
                                 {"--","Files Dnld",""},
                                 {"--","UUCP Priv",""},
                                 {"--","Msgs Wrttn",""},
                                 {"--","'K' Dnld",""},
                                 {"--","Tm Online",""},
                                 {"17","Lst MArea",""},
                                 {"--","Sysop Pgs",""},
                                 {"--","Bltn Write",""},
                                 {"18","Lst FArea",""},
                                 {"--","U/D Ratio",""},
                                 {"--","Credit",""},
                                 {"19","Protocol",""},
                                 {"20","Capture",""},
                                 {"21","Editor",""},
                                 {"--","NetMail",""},
                                 {"22","Global Msg","..."},
                                 {"23","Global File","..."},
                                 {"24","Global Arc","..."},
                                 {"25","Archiver",""},
                                 {"26","Menu Set",""},
                                 {"27","Char Set",""}
                                };
//-

struct LangStruct *ls;
struct Library    *DLGBase = NULL;
char             **SA;

/// main
void main(int argc, char *argv[])
{ULONG msize = 0;
 ULONG fsize = 0;

 sout = Output();
 if (!(DLGBase=OpenLibrary(DLGNAME,DLGVERSION)))  exit(5);

 if (GetDevName(Ext)==-1)    CleanUp("Unable to determine port");
 if (!(ls = GetLang(Ext)))  _CXBRK();
 SA = ls->strings;

 // New for 1.2.1 / 2.3 -- 8/11/97

 FileSize("MSG:AREA.BBS",&msize);
 FileSize("FILE:AREA.BBS",&fsize);

 if(msize > fsize)
 {
    NumberOfSearchAreas = msize / sizeof(struct Msg_Area);
 }
 else
 {
    NumberOfSearchAreas = fsize / sizeof(struct Msg_Area);
 }


 if(! (SearchArea = calloc(NumberOfSearchAreas,sizeof(long))))
      _CXBRK();

 if (ReadGlobals(Ext,&Globals)==-1)      CleanUp(SA[2386]);
 if (!ReadUser(&RStruct, &UserDat, Ext))  CleanUp(SA[2387]);

 WriteLog(USER_OPTION_MODULE, RStruct.Name, Ext, "");
 BCPend(Ext);
 Edit_User(RStruct.Name);
_CXBRK();
}
//-

/// Edit_User
void Edit_User(char *name)
{char           a;
 char           string[80];
 char           valid[80];
 char           password[12];
 SHORT          tempint;
 struct MenuSet Set;

 while(TRUE)
      {Clr(UserDat.Ansi_Flag);
       if (!INSTACK)  Print_User(RStruct.Name);

       a = iinput(1,28,0, SA[2388]);
       Clr(UserDat.Ansi_Flag);

       switch(a)
             {case 0: if (!INSTACK)
                         {
                          AFPrintf(NULL, sout, SA[2389]);
                          Clr(UserDat.Ansi_Flag);
                         }

                      WriteUser(name,&UserDat);
                      return;
                      break;

              case 1: if (Exists("DLGConfig:misc/NoAlias.hack"))  break;
                      if (DLGInput(NULL,string,UserDat.Alias,35,35,3, SA[2390]))
                          strcpy(UserDat.Alias,string);
                      TwoLines();
                      break;

              case 2:
                      if (DLGInput(NULL,string,UserDat.Address,25,25,1, SA[2391]))
                          strcpy(UserDat.Address,string);
                      TwoLines();
                      break;

              case 3:
                      UserDat.Computer_Type = iinput(1,Display_Computer_Types(),1, SA[2392]);
                      TwoLines();
                      break;

              case 4:
                      if (DLGInput(NULL,string,UserDat.City,23,23,1, SA[2393]))
                          strcpy(UserDat.City,string);
                      TwoLines();
                      break;

              case 5:
                      DLGInput(NULL,string,NULL,11,11,2, SA[2394]);
                      Upper(string);
                      if (Stricmp(string,UserDat.Password))
                         {TwoLines();
                          break;
                         }
                      if (DLGInput(NULL,password,NULL,11,11,2, SA[2395]))
                          if (DLGInput(NULL,valid,NULL,11,11,2, SA[2396]))
                              TwoLines();

                      if (!Stricmp(valid,password))
                         {strcpy(UserDat.Password,password);
                          Upper(UserDat.Password);
                         }
                       else
                         {
                          AFPrintf(NULL, sout, SA[2397]);
                          Pause();
                         }
                      break;

              case 6:
                      if (DLGInput(NULL,string,UserDat.Prov,5,5,1, SA[2398]))
                          strcpy(UserDat.Prov,string);
                      TwoLines();
                      break;

              case 7:
                      if (DLGInput(NULL,string,UserDat.Country,24,24,1, SA[2399]))
                          strcpy(UserDat.Country,string);
                      TwoLines();
                      break;

              case 8:
                      if (DLGInput(NULL,string,UserDat.postal,7,7,1, SA[2400]))
                          strcpy(UserDat.postal,string);
                      TwoLines();
                      break;

              case 9:
                      if (DLGInput(NULL,string,UserDat.Phone,14,14,0, SA[2401]))
                          strcpy(UserDat.Phone,string);
                      TwoLines();
                      break;

             case 10: if (!INSTACK)
                          AFPrintf(&UserDat, sout, SA[2402]);
                      DLGInput(NULL,string,NULL,1,1,1, SA[2403]);
                      TwoLines();

                      if (string[0]=='N')  UserDat.Help_Level=0;
                      if (string[0]=='I')  UserDat.Help_Level=1;
                      if (string[0]=='E')  UserDat.Help_Level=2;
                      break;

             case 11: for(tempint=60; tempint > 2; tempint--)
                          AFPrintf(NULL, sout, "%d\n",tempint);
                      OneLine();
                      UserDat.Screen_Len = iinput(5,128, UserDat.Screen_Len, SA[2404]);
                      TwoLines();
                      break;

             case 12: UserDat.More_Flag=((UserDat.More_Flag+1)&1);
                      break;

             case 13:
                      UserDat.Screen_Width = iinput(20,127,UserDat.Screen_Width, SA[2405]);
                      TwoLines();
                      break;

             case 14: GetAnsi();
                      break;

             case 15: HOT=((HOT+1)&1);
                      break;

             case 16: UserDat.Lex_Flag=((UserDat.Lex_Flag+1)&1);
                      break;

             case 17:
                      UserDat.Last_Area = iinput(1,HighSearchArea,UserDat.Last_Area, SA[2406]);
                      TwoLines();
                      break;

             case 18:
                      UserDat.Last_File_Area = iinput(1,999999,UserDat.Last_File_Area, SA[2407]);
                      TwoLines();
                      break;

             case 19: ListProtocols(UserDat.User_Level,valid,PROTO_SEND,1);
                      DLGInput(NULL,string,NULL,1,1,1, SA[2408]);
                      UserDat.send = '\0';
                      a           =   0;
                      while(valid[a]!='\0')
                            if (valid[a++]==string[0])
                                UserDat.send=string[0];
                      TwoLines();

                      ListProtocols(UserDat.User_Level,valid,PROTO_REC,1);
                      DLGInput(NULL,string,NULL,1,1,1, SA[2409]);

                      a              =   0;
                      UserDat.receive = '\0';
                      while(valid[a]!='\0')
                            if (valid[a++]==string[0])
                                UserDat.receive=string[0];
                      TwoLines();
                      break;

             case 20: UserDat.captureflags=0;
                      zflag=finput(1, SA[2410]);

                      OneLine();
                      if (!zflag)
                         {OneLine();
                          break;
                         }
                      UserDat.captureflags |= 1;
                      zflag=finput(0, SA[2411]);
                      OneLine();
                      if (zflag) UserDat.captureflags |= 2;
                      zflag=finput(0, SA[2412]);
                      TwoLines();
                      if (zflag) UserDat.captureflags|=4;
                      break;

             case 21:
                      tempint=iinput(1,ListEditors(UserDat.User_Level),UserDat.Editor, SA[2413]);
                      TwoLines();
                      if (CheckEditor(tempint,UserDat.User_Level))
                          UserDat.Editor=tempint;
                      break;

             case 22: Edit_Search_Areas(0);
                      break;

             case 23: Edit_Search_Areas(1);
                      break;

             case 24: Edit_Search_Areas(2);
                      break;

             case 25:
                      tempint=iinput(1,ListArchivers(UserDat.User_Level,COMPRESS),0, SA[2414]);
                      TwoLines();
                      if (CheckArchiver(tempint,UserDat.User_Level,COMPRESS) || !tempint)
                          UserDat.archiver=tempint;
                      break;

///         Menu Set
             case 26:
                      tempint=iinput(1,ListMenuSets(UserDat.User_Level),0, SA[2415]);
                      TwoLines();
                      if (tempint==0 || CheckMenuSet(tempint,UserDat.User_Level))
                         {UserDat.menuset = tempint;
                          Set.number     = tempint;
                          if (GetStruct("DLGConfig:Misc/MenuSets.bbs", (char *)&Set, sizeof(Set),1)!=-1)
                              if (Set.language[0]!='\0')
                                  if (LoadLang(Ext,Set.language)!=RMNOERR)
                                      LoadLang(Ext,"English");
                         }

                      if (!UserDat.menuset)
                          if (LoadLang(Ext,Globals.Language)!=RMNOERR)
                              LoadLang(Ext,"English");

                      ls = GetLang(Ext);
                      break;
//-

             case 27: if (!Exists("DLGConfig:CharSets/CharSets.bbs"))
                         {
                          AFPrintf(&UserDat, sout, SA[2416]);
                          Pause();
                          break;
                         }

                       ListSets(UserDat.User_Level);
                       tempint=iinput(1,255,0, SA[2417]);
                       TwoLines();
                       if (tempint==0 || CheckSet(tempint,UserDat.User_Level))
                          {UserDat.charset = tempint;
                           UseCharSet(UserDat.charset,Ext);
                          }
                       break;

             case 28:
                       DLGInput(NULL,UserDat.stack,UserDat.stack,39,39,1, SA[2418]);
                       TwoLines();
                       break;
             }
      }
}
//-

/// Print_User
void Print_User(char *name)
{char string[36];

 ASPrintf(&UserDat, data2[0].data,  SA[2419],  UserDat.Alias);
 ASPrintf(&UserDat, data2[1].data,  SA[2420],  UserDat.Address);
 Get_Computer_Type(UserDat.Computer_Type,data2[2].data);
 ASPrintf(&UserDat, data2[3].data,  SA[2421],  UserDat.City);
 ASPrintf(&UserDat, data2[4].data,  SA[2422], SA[2423]);
 ASPrintf(&UserDat, data2[5].data,  SA[2424],  UserDat.Prov);
 SMDate(UserDat.DateJoined, string);
 ASPrintf(&UserDat, data2[6].data,  SA[2425],  string);
 ASPrintf(&UserDat, data2[7].data,  SA[2426],  UserDat.Country);
 ASPrintf(&UserDat, data2[8].data,  SA[2427],  UserDat.Last_Login);
 ASPrintf(&UserDat, data2[9].data,  SA[2428],  UserDat.postal);
 ASPrintf(&UserDat, data2[10].data, SA[2429],  UserDat.Phone);

 switch(UserDat.Help_Level)
       {case 0:
                ASPrintf(&UserDat, data3[0].data,SA[2430],SA[2431]);
                break;

        case 1:
                ASPrintf(&UserDat, data3[0].data,SA[2430],SA[2432]);
                break;

        case 2:
                ASPrintf(&UserDat, data3[0].data,SA[2430],SA[2433]);
                break;
       }

 ASPrintf(&UserDat, data3[1].data,SA[2434],UserDat.User_Level);
 ASPrintf(&UserDat, data3[2].data,SA[2435],UserDat.Screen_Len);
 ASPrintf(&UserDat, data3[3].data,SA[2436],(UserDat.More_Flag) ? SA[2437]:SA[2438]);
 ASPrintf(&UserDat, data3[4].data,SA[2439],UserDat.Daily_Limit);
 ASPrintf(&UserDat, data3[5].data,SA[2440],UserDat.Screen_Width);
 ASPrintf(&UserDat, data3[6].data,SA[2441],(UserDat.Ansi_Flag&ANSI_COLOR)?'C':'-',
        (UserDat.Ansi_Flag&ANSI_POS)?'P':'-',(UserDat.Ansi_Flag&ANSI_CLR)?'S':'-',
        (UserDat.Ansi_Flag&ANSI_SCROLL)?'T':'-');
 ASPrintf(&UserDat, data3[7].data,SA[2442],UserDat.Session_Limit);
 ASPrintf(&UserDat, data3[8].data,SA[2443],UserDat.Messages_Read);
 ASPrintf(&UserDat, data3[9].data,SA[2444],(HOT)?SA[2445]:SA[2446]);
 ASPrintf(&UserDat, data3[10].data,SA[2447],UserDat.Daily_Used);
 ASPrintf(&UserDat, data3[11].data,SA[2448],UserDat.Files_Uploaded);
 ASPrintf(&UserDat, data3[12].data,SA[2449],(UserDat.Lex_Flag)?SA[2450]:SA[2451]);
 ASPrintf(&UserDat, data3[13].data,SA[2452],UserDat.Total_Calls);
 ASPrintf(&UserDat, data3[14].data,SA[2453],(unsigned long)UserDat.Bytes_Uploaded/1024L);
 ASPrintf(&UserDat, data3[15].data,SA[2454],(UserDat.Pop_Screen)?SA[2455]:SA[2456]);
 ASPrintf(&UserDat, data3[16].data,SA[2457],UserDat.DirLimit);
 ASPrintf(&UserDat, data3[17].data,SA[2458],UserDat.Files_Downloaded);
 if (UserDat.UUCP==2)
     ASPrintf(&UserDat, data3[18].data,SA[2459],SA[2460]);
   else
     ASPrintf(&UserDat, data3[18].data,SA[2459],(UserDat.UUCP)?SA[2461]:SA[2462]);
 ASPrintf(&UserDat, data3[19].data,SA[2463],UserDat.Messages_Entered);
 ASPrintf(&UserDat, data3[20].data,SA[2464],UserDat.Bytes_Downloaded/1024L);
 ASPrintf(&UserDat, data3[21].data,SA[2465],UserDat.Online_Time);
 ASPrintf(&UserDat, data3[22].data,SA[2466],UserDat.Last_Area);
 ASPrintf(&UserDat, data3[23].data,SA[2467],UserDat.Sysop_Pages);
 ASPrintf(&UserDat, data3[24].data,SA[2468],(UserDat.Bulletin_Access)?SA[2469]:SA[2470]);
 ASPrintf(&UserDat, data3[25].data,SA[2471],UserDat.Last_File_Area);

 if (UserDat.Ratio>0)
     ASPrintf(&UserDat, data3[26].data,SA[2472],UserDat.Ratio);
   else
     ASPrintf(&UserDat, data3[26].data,SA[2473]);
 ASPrintf(&UserDat, data3[27].data,SA[2474],UserDat.credit);
 ASPrintf(&UserDat, data3[28].data,SA[2475],(UserDat.send!='\0') ? UserDat.send : '-',(UserDat.receive!='\0') ? UserDat.receive : '-');

 if (!UserDat.captureflags)
      ASPrintf(&UserDat, data3[29].data,SA[2476]);
    else
      ASPrintf(&UserDat, data3[29].data,SA[2477],(UserDat.captureflags&2)?'A':'-',(UserDat.captureflags&4)?'M':'-');
 ASPrintf(&UserDat, data3[30].data,SA[2478],UserDat.Editor);
 ASPrintf(&UserDat, data3[31].data,SA[2479],(UserDat.NetMail&1)?SA[2480]:SA[2481],(UserDat.NetMail&2)?SA[2482]:SA[2483]);
 ASPrintf(&UserDat, data3[35].data,SA[2484],UserDat.archiver);
 ASPrintf(&UserDat, data3[36].data,SA[2485],UserDat.menuset);
 ASPrintf(&UserDat, data3[37].data,SA[2486],UserDat.charset);

 if (!Show_User(name, (struct twocoldata *)&data2, 11, (struct threecoldata *)&data3, 38))
    {
     AFPrintf(&UserDat, sout, SA[2487],UserDat.stack);
     OneLine();
    }
}
//-

/// Edit_Search_Areas
void Edit_Search_Areas(char mode)
{
   USHORT   a;
   USHORT   b;
   char  c[2];
   char  breakflag;

   if (mode == 1)
      strcpy(areafile, "FILE:Area.bbs");
   else
      strcpy(areafile, "MSG:Area.bbs");

   Read_Search_Areas(mode);

   while(TRUE)
   {
      breakflag = 0;
      AFPrintf(&UserDat, sout, SA[2488]);

      if (!INSTACK)
      {
         List_Search_Areas(mode);
         OneLine();
      }

      menu(Menu,7,0);
      DLGInput(NULL,c,NULL,1,1,1, SA[2489]);
      TwoLines();

      switch(c[0])
      {
///      Add area
         case 'A':   while(TRUE)
                     {
                        b = iinput(1,9999,0, SA[2490]);
                        TwoLines();

                        if (!b) break;
                        if (Area_Clearance(b,mode))
                        {
                           AFPrintf(&UserDat, sout, SA[2491]);
                           continue;
                        }

                        for(a = 0; a < HighSearchArea; a++)
                           if (SearchArea[a] == b)
                              breakflag = 1;

                        if (breakflag == 1)
                        {
                           breakflag = 0;
                           AFPrintf(&UserDat, sout, SA[2492]);
                           continue;
                        }

                        SearchArea[HighSearchArea]=b;
                        HighSearchArea++;
                     }

                     break;
//-

         case 'L':   ListAreas(RStruct.Name,&UserDat,(mode==1)?mode:0,Sig.number);
                     OneLine();
                     Pause();
                     break;

///      Remove area
         case 'R':   while(TRUE)
                     {
                        b = iinput(1,9999,0, SA[2493]);

                        if (!b)
                        {
                           TwoLines();
                           break;
                        }

                        for(a = 0; b!=SearchArea[a] && a<HighSearchArea; a++);

                        if (a==HighSearchArea)
                        {
                           AFPrintf(&UserDat, sout, SA[2494]);
                           continue;
                        }

                        AFPrintf(&UserDat, sout, SA[2495]);
 
                        for( ; a < HighSearchArea ; a++)
                           SearchArea[a] = SearchArea[a+1];
                           HighSearchArea--;
                     }

                     break;
//-

         case 'Q':   qsort(SearchArea,HighSearchArea,4,SortSearchArea);
                     break;

         case 'J':   Write_Search_Areas(mode);
                     AddGlobalAreas(RStruct.Name,0,UserDat.User_Level,mode+128,areafile);
                     Read_Search_Areas(mode);
                     break;

         case 'D':   zflag=finput(1, SA[2496]);
                     TwoLines();

                     if (zflag)
                     {
                        if (!Sig.number)
                           HighSearchArea=0;
                        else
                           DeleteGlobalAreas();
                     }

                     break;

         case 'S':   SelectSIG((mode==1)?mode:0);
                     break;

         case 0:     Write_Search_Areas(mode);
                     return;
                     break;
      }
   }
}
//-

/// List_Search_Areas
void List_Search_Areas(char mode)
{
   USHORT   a;
   SHORT    poscounter=0;

   AFPrintf(&UserDat, sout, SA[2497]);

   for(a = 0; a < HighSearchArea; a++)
   {
      if (Sig.number && !InsureArea(SearchArea[a],mode))  continue;

      AFPrintf(NULL, sout, SA[2498], SearchArea[a]);
      poscounter++;

      if (poscounter+1 >= ((UserDat.Screen_Width-20)/5) && a!=(HighSearchArea-1))
      {
         AFPrintf(&UserDat, sout, SA[2499]);
         poscounter = 0;
      }
   }

   if (poscounter     != 0)  OneLine();
   if (HighSearchArea == 0)  OneLine();
}
//-

/// Read_Search_Areas
void Read_Search_Areas(char mode)
{int   fp;
 USHORT  buffer;
 char  filename[80];

 HighSearchArea = 0;
 if (!mode)
      ASPrintf(NULL, filename,"User:%s/GlobalAreas.msg",RStruct.Name);
    else
      if (mode==1)
          ASPrintf(NULL, filename,"User:%s/GlobalAreas.file",RStruct.Name);
        else
          ASPrintf(NULL, filename,"User:%s/GlobalAreas.archive",RStruct.Name);
 
 UnderScore(filename);
 if ((fp = open(filename,O_RDONLY)) == EOF)  return;

 while(((read(fp,&buffer,sizeof(buffer))) == sizeof(buffer)))
      {SearchArea[HighSearchArea] = buffer;
       HighSearchArea++;
      }
 close(fp);

 return;
}
//-

/// Insure_Area
BOOL InsureArea(long area, char mode)
{int             fp;
 struct Msg_Area Area;

 if ((fp = open(areafile,O_RDONLY))==EOF)  return(1);
 while(read(fp,&Area,sizeof(Area))==sizeof(Area))
       if (Area.Number==area)
          {close(fp);
           return(TRUE);
          }

 close(fp);
 return(FALSE);
}
//-

/// Write_Search_Areas
void Write_Search_Areas(char mode)
{int   fp;
 USHORT  a;
 USHORT  buffer;
 char  filename[255];

 if (!mode)
     ASPrintf(NULL, filename,"User:%s/GlobalAreas.msg",RStruct.Name);
   else
     if (mode==1)
         ASPrintf(NULL, filename,"User:%s/GlobalAreas.file",RStruct.Name);
       else
         ASPrintf(NULL, filename,"User:%s/GlobalAreas.archive",RStruct.Name);

 UnderScore(filename);
 DeleteFile(filename);
 if ((fp = open(filename,O_WRONLY | O_CREAT)) == EOF)
    {
     AFPrintf(&UserDat, sout, SA[2500]);
     return;
    }

 for(a = 0 ; a < HighSearchArea ; a++)
    {buffer = SearchArea[a];
     write(fp,&buffer,sizeof(USHORT));
    }

 close(fp);
 return;
}
//-

/// SelectSIG
BOOL SelectSIG(char mode)
{if (!INSTACK)  ListSIGS(&UserDat,mode,1);

 Sig.number=iinput(1,255,0, SA[2501]);
 TwoLines();

 if (!Sig.number)
    {
     AFPrintf(&UserDat, sout, SA[2502]);
     Sig.number = 0;
     ASPrintf(NULL, areafile,"%s:Area.bbs",(mode)?"FILE":"MSG");
     return(TRUE);
    }

 ASPrintf(NULL, areafile,"DLGCONFIG:SIGS/SIGS.%s",(mode)?"file":"msg");

 if (GetStruct(areafile, (char *)&Sig, sizeof(Sig),1)==-1 || Sig.level>UserDat.User_Level)
    {Sig.number = 0;
     AFPrintf(&UserDat, sout, SA[2503]);
     return(FALSE);
    }

 ASPrintf(NULL, areafile,"DLGCONFIG:SIGS/%s.%s",Sig.name,(mode)?"file":"msg");
 return(TRUE);
}
//-

/// SortSearchArea
int SortSearchArea(long *area1, long *area2)

{return(*area1-*area2);
}
//-

/// Get_Computer_Type
void Get_Computer_Type(char type, char *retstr)
{struct Computer_Type Ct;

 *retstr    =  0;
  Ct.Number = type;

 if (!GetStruct("DlgConfig:Port/ComputerTypes.bbs", (char *)&Ct, sizeof(struct Computer_Type), 1))
      ASPrintf(&UserDat, retstr, SA[2504], Ct.Name);

 return;
}
//-

/// GetANSI
void GetAnsi()
{char str[2];

 while(TRUE)
      {if (!INSTACK)
          {
           AFPrintf(&UserDat, sout, SA[2505]);
           AFPrintf(&UserDat, sout, SA[2506], (UserDat.Ansi_Flag & ANSI_COLOR)?SA[2507]:SA[2508]);
           AFPrintf(&UserDat, sout, SA[2509], (UserDat.Ansi_Flag & ANSI_POS)?SA[2507]:SA[2508]);
           AFPrintf(&UserDat, sout, SA[2510], (UserDat.Ansi_Flag & ANSI_CLR)?SA[2507]:SA[2508]);
           AFPrintf(&UserDat, sout, SA[2511], (UserDat.Ansi_Flag & ANSI_SCROLL)?SA[2507]:SA[2508]);
          }
       DLGInput(NULL,str,NULL,1,1,1, SA[2512]);
       TwoLines();

       switch(str[0])
             {case 'S': if (UserDat.Ansi_Flag & ANSI_CLR)
                            UserDat.Ansi_Flag = UserDat.Ansi_Flag & (255-ANSI_CLR);
                          else
                            UserDat.Ansi_Flag = UserDat.Ansi_Flag | ANSI_CLR;
                        break;

              case 'C': if (UserDat.Ansi_Flag & ANSI_COLOR)
                            UserDat.Ansi_Flag = UserDat.Ansi_Flag & (255-ANSI_COLOR);
                          else
                            UserDat.Ansi_Flag = UserDat.Ansi_Flag | ANSI_COLOR;
                        break;

              case 'P': if (UserDat.Ansi_Flag & ANSI_POS)
                           {UserDat.Ansi_Flag = UserDat.Ansi_Flag & (255-ANSI_POS);
                            TUnSetFlags(T_ANSIPOS, Ext);
                           }
                          else
                           {UserDat.Ansi_Flag = UserDat.Ansi_Flag | ANSI_POS;
                            TUnSetFlags(T_ANSIPOS, Ext);
                           }
                        break;

              case 'T': if (UserDat.Ansi_Flag & ANSI_SCROLL)
                            UserDat.Ansi_Flag = UserDat.Ansi_Flag & (255-ANSI_SCROLL);
                          else
                            UserDat.Ansi_Flag = UserDat.Ansi_Flag | ANSI_SCROLL;
                        break;

               case 0:  return;
             }
      }
}
//-

/// Area_Clearance
BOOL Area_Clearance(long area, char mode)
{int             fp;
 char            filename[80];
 char            breakflag = FALSE;
 struct Msg_Log  Log;
 struct Msg_Area Area;

 if (mode==0 || mode==2)
     if ((fp=open("MSG:Area.bbs",O_RDONLY))==EOF)    return(1);

 if (mode==1)
     if ((fp=open("FILE:Area.bbs",O_RDONLY))==EOF)   return(1);

 while(read(fp,&Area,sizeof(Area))==sizeof(Area))
      {if (Area.Number==area)
          {if (Area.Flag&AUTO_ACCESS_AREA && UserDat.User_Level>=Area.llevel && UserDat.User_Level<=Area.ulevel)
              {close(fp);
               return(0);
              }

           breakflag = TRUE;
           break;
          }

       if (breakflag)  break;
      }

 close(fp);
 if (mode==0 || mode==2)
     ASPrintf(NULL, filename,"MSG:%d/User.Msg",area);
   else
     ASPrintf(NULL, filename,"FILE:%d/User.File",area);

 UnderScore(filename);
 strcpy(Log.Name,RStruct.Name);
 Upper(Log.Name);

 if (GetStruct(filename, (char *)&Log, sizeof(Log), 36)==-1)  return(1);
 return(0);
}
//-

/// _CXBRK
void _CXBRK()

{CleanUp(NULL);
}
//-

/// CleanUp
void CleanUp(char *s)
{WriteRam(&RStruct, Ext);

 if(SearchArea)  free(SearchArea);

 if (s)
    {Write(sout, "\n Error: ", 9);
     Write(sout, s, strlen(s));
     Write(sout, "\n\n", 2);
    }

 ChainProgram("DLG:Menu", Ext);
 CloseLibrary(DLGBase);
 exit(0);
}
//-

/// DeleteGlobalAreas
BOOL DeleteGlobalAreas()
{struct Msg_Area area;
 int             fp;
 long            counter;

 if ((fp=open(areafile,O_RDONLY))==EOF)  return(FALSE);

 while(read(fp,&area,sizeof(area))==sizeof(area))
      {for(counter = 0; counter < HighSearchArea; counter++)
          {if (SearchArea[counter]==area.Number)
              {movmem((SearchArea+counter)+1,SearchArea+counter,(HighSearchArea-counter-1)*2);
               HighSearchArea--;
              }
          }
      }

 close(fp);
 return(TRUE);
}
//-
