#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <dos.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <exec/types.h>
#include <fctype.h>
#include <libraries/dosextens.h>
#include <graphics/gfxbase.h>
#include <intuition/intuitionbase.h>

#include <dlg/dlg.h>
#include <dlg/msg.h>
#include <dlg/log.h>
#include <dlg/resman.h>
#include <dlg/user.h>
#include <dlg/menu.h>
#include <dlg/misc.h>
#include <dlg/file.h>
#include <dlg/portconfig.h>

#include <devices/tpt.h>

#include <link/config.h>
#include <link/io.h>
#include <link/util.h>

#include <proto/dos.h>
#include <proto/exec.h>
#include <proto/dlg.h>

#include <pragmas/dlg.h>

#include <private/Version.h>
#define  ObjRev "1"
const UBYTE version[]="\0$VER: Port Config " BUILDVER "." ObjRev " " COPYRIGHT " by Digerati Dreams "__AMIGADATE__;

#pragma msg 209 ignore

void  main                  (int, char **);
int   HandleBuiltIn         (UBYTE);

void  Add_Port              (void);
void  Add_Modem             (void);
void  Add_Globals           (void);
void  Add_Display           (void);
void  DeleteGlobals         (void);
void  Delete_Port           (void);
void  Delete_Display        (void);
void  DeleteModem           (void);
void  Edit_Port             (void);
void  Edit_Display          (void);
void  Add_Directory         (char *name);
void  Print_Globals         (void);
void  Edit_Globals          (void);
void  Define_Computer_Types (void);
SHORT DisplayComputerTypes  (void);
void  Edit_Modem            (void);
void  List_Ports            (void);
void  ListModem             (void);
void  ListDisplay           (void);
void  ListGlobals           (void);
void  ListLangs             (void);
void  GetAnsi               (void);
void _CXBRK                 (void);


#define INSTACK   RStruct.Command_Stack[0]
#define STK       RStruct.Command_Stack
#define HOT       UserDat.Hot_Keys

unsigned short colortable[8]={0x000,0xdb6,0x373,0xf70,0x00d,0xb07,0x0bd,0xccc};

SHORT  elementnum;
struct NewShortMenu Menu[20] = {{"Abort",1},
                                {"PORT_AddCompTypes",1},
                                {"PORT_AddDisplay",1},
                                {"PORT_AddGblSet",1},
                                {"PORT_AddModem",1},
                                {"PORT_AddPort",1},
                                {"PORT_DelDisplay",1},
                                {"PORT_DelGlbSet",1},
                                {"PORT_DelModem",1},
                                {"PORT_DelPort",1},
                                {"PORT_EditDisplay",1},
                                {"PORT_EditGlbSet",1},
                                {"PORT_EditModem",1},
                                {"PORT_EditPort",1},
                                {"PORT_Exit",1},
                                {"PORT_ListDisplays",1},
                                {"PORT_ListGblSets",1},
                                {"PORT_ListModems",1},
                                {"PORT_ListPorts",1},
                                {"PORT_ViewCompTypes",1}
                               };

BPTR                   sout;
struct USER_DATA       UserDat;
struct Ram_File        RStruct;

struct Port            CPort;
struct Modem           CModem;
struct Displays        CDisplay;
struct Global_Settings CGlobals;

char   Ext[4];
char  *temparray    =  NULL;
char   Overlay      =  FALSE;
char   exitflag     =  FALSE;
char   MenuName[13] = "PORT_Main";

struct IntuitionBase *IntuitionBase = NULL;
struct GfxBase       *GfxBase       = NULL;
struct Library       *DLGBase       = NULL;
struct LangStruct    *ls;
char                **SA;

void main(int argc, char *argv[])

{char *s;
 char *stack = NULL;

 sout = Output();
 if (!(DLGBase = OpenLibrary(DLGNAME, DLGVERSION)))  exit(5);

 while(--argc>0)
      {s = *++argv;
       if (*s++=='-')
          {while(*s)
                {switch(toupper(*s++))
                       {case 'O': Overlay=TRUE;
                                  break;

                        case 'S': if (!--argc)  break;
                                  stack = *++argv;
                                  break;

                        case 'M': if (!--argc)  break;
                                  strncpy(MenuName,*++argv,12);
                                  MenuName[12] = '\0';
                                  break;
                       }
                }
          }
      }


 if (!(IntuitionBase=(struct IntuitionBase *)OpenLibrary("intuition.library",33L)))  _CXBRK();
 if (!(GfxBase=(struct GfxBase *)OpenLibrary("graphics.library",33L)))               _CXBRK();

 if (GetDevName(Ext) == -1)  _CXBRK();
 if (!(ls = GetLang(Ext)))   _CXBRK();
 SA = ls->strings;

 WriteLog(SYSOP_CONFIG,RStruct.Name,Ext,SA[1472]);

 if (!ReadUser(&RStruct, &UserDat, Ext)) _CXBRK();
 if (stack)                              InsertStack(STK, stack);

 if (!CD("DlgConfig:Port"))
    {AFPrintf(&UserDat, sout, SA[1473]);
    _CXBRK();
    }

 while(!exitflag)
      {Chk_Abort();

       if (MenuInput(MenuName,Ext,"PORT",Menu,20,HandleBuiltIn,&UserDat,&RStruct,UserDat.Help_Level,NULL)==MENUNOTFOUND)
          _CXBRK();
      }

 _CXBRK();
}


int HandleBuiltIn(UBYTE cmd)

{switch(cmd)
       {case 0:                                     /* Abort */
                WriteRam(&RStruct,Ext);
                exitflag=TRUE;
                break;

        case 1:                                     /* PORT_AddCompTypes */
                Define_Computer_Types();
                break;

        case 2:                                     /* PORT_AddDipslay */
                Add_Display();
                break;

        case 3:                                     /* PORT_AddGblSet */
                Add_Globals();
                break;

        case 4:                                     /* PORT_AddModem */
                Add_Modem();
                break;

        case 5:                                     /* PORT_AddPort */
                Add_Port();
                break;

        case 6:                                     /* PORT_DelDisplay */
                Delete_Display();
                break;

        case 7:                                     /* PORT_DelGlbSet */
                DeleteGlobals();
                break;

        case 8:                                     /* PORT_DelModem */
                DeleteModem();
                break;

        case 9:                                     /* PORT_DelPort */
                Delete_Port();
                break;

       case 10:                                    /* PORT_EditDisplay */
                Edit_Display();
                break;

       case 11:                                    /* PORT_EditGlbSet */
                Edit_Globals();
                break;

       case 12:                                    /* PORT_EditModem */
                Edit_Modem();
                break;

       case 13:                                    /* PORT_EditPort */
                Edit_Port();
                break;

       case 14:                                    /* PORT_Exit */
                if (!INSTACK)   Clr(UserDat.Ansi_Flag);
               _CXBRK();
                break;

       case 15:                                    /* PORT_ListDisplay */
                AFPrintf(&UserDat, sout, SA[1474]);
                ListDisplay();
                free(temparray);
                break;

       case 16:                                      /* PORT_ListGblSets */
                AFPrintf(&UserDat, sout, SA[1475]);
                ListGlobals();
                free(temparray);
                break;

       case 17:                                      /* PORT_ListModems */
                AFPrintf(&UserDat, sout, SA[1476]);
                ListModem();
                free(temparray);
                break;

      case 18:                                      /* PORT_ListPorts */
                AFPrintf(&UserDat, sout, SA[1477]);
                List_Ports();
                break;

       case 19:                                      /* PORT_ViewCompTypes */
                DisplayComputerTypes();
                break;
       }

 return(0);
}


void Add_Port()

{int   zflag;
 char  filename[80];
 char  CurPort[6];
 ULONG tlong;

 zflag=DLGInput(NULL,CurPort,NULL,3,3,1, SA[1478]);
 AFPrintf(NULL, sout, "\n\n");
 if (!zflag)
    {AFPrintf(&UserDat, sout, SA[1479]);
     return;
    }

 if (zflag!=3)
    {AFPrintf(&UserDat, sout, SA[1480]);
     return;
    }

 ASPrintf(NULL, filename,"%s.port", CurPort);
 if (!FileSize(filename,&tlong))
    {AFPrintf(&UserDat, sout, SA[1481]);
     return;
    }

 DLGInput(NULL,CPort.Device,NULL,35,35,0, SA[1482]);
 AFPrintf(NULL, sout, "\n");
 CPort.Unit = iinput(0,127,0, SA[1483]);
 AFPrintf(NULL, sout, "\n\n");

 while(TRUE)
      {ListModem();
       zflag=DLGInput(temparray,CPort.ModemFile,(char *)-1,36,elementnum,6, SA[1484]);
       free(temparray);
       AFPrintf(NULL, sout, "\n\n");

       if (zflag==-1)
          {AFPrintf(&UserDat, sout, SA[1479]);
           return;
          }

       strcat(CPort.ModemFile,SA[1485]);
       if (FileSize(CPort.ModemFile,&tlong))
          {AFPrintf(&UserDat, sout, SA[1486]);
           continue;
          }

       break;
      }

 while(TRUE)
      {ListGlobals();
       zflag=DLGInput(temparray,CPort.GlobalFile,(char *)-1,36,elementnum,6, SA[1487]);
       free(temparray);
       AFPrintf(NULL, sout, "\n\n");

       if (zflag==-1)
          {AFPrintf(&UserDat, sout, SA[1479]);
           return;
          }

       strcat(CPort.GlobalFile,SA[1488]);
       if (FileSize(CPort.GlobalFile,&tlong))
          {AFPrintf(&UserDat, sout, SA[1489]);
           continue;
          }

       break;
      }

 while(TRUE)
      {ListDisplay();
       zflag=DLGInput(temparray,CPort.DisplayFile,(char *)-1,36,elementnum,6, SA[1490]);
       free(temparray);
       AFPrintf(NULL, sout, "\n\n");

       if (zflag==-1)
          {AFPrintf(&UserDat, sout, SA[1479]);
           return;
          }

       strcat(CPort.DisplayFile,SA[1491]);
       if (FileSize(CPort.DisplayFile,&tlong))
          {AFPrintf(&UserDat, sout, SA[1492]);
           continue;
          }

       break;
      }

 zflag=finput(1, SA[1493]);
 AFPrintf(NULL, sout, "\n\n");
 if (!zflag)
    {AFPrintf(&UserDat, sout, SA[1494]);
     return;
    }

 if (!AddStruct(filename, (char *)&CPort, sizeof(CPort), 2))
    {AFPrintf(&UserDat, sout, SA[1495],CurPort);
     return;
    }

 AFPrintf(&UserDat, sout, SA[1496],CurPort);
 return;
}


void Add_Modem()

{int   zflag;
 char  string[255];
 char  filename[80];
 char  lstr[10];
 ULONG tlong;

 zflag=DLGInput(NULL,string,NULL,20,20,1, SA[1497]);
 AFPrintf(NULL, sout, "\n\n");
 if (!zflag)
    {AFPrintf(&UserDat, sout, SA[1479]);
     return;
    }

 ASPrintf(NULL, filename, "%s.modem",string);
 if (!FileSize(filename,&tlong))
    {AFPrintf(&UserDat, sout, SA[1498]);
     return;
    }

 DLGInput(NULL,CModem.Init,NULL,79,79,0, SA[1499]);
 AFPrintf(NULL, sout, "\n");

 DLGInput(NULL,CModem.Hangup,NULL,9,9,0, SA[1500]);
 AFPrintf(NULL, sout, "\n");

 DLGInput(NULL,CModem.CommandMode,NULL,9,9,0, SA[1501]);
 AFPrintf(NULL, sout, "\n");

 DLGInput(NULL,CModem.Reset,NULL,9,9,0, SA[1502]);
 AFPrintf(NULL, sout, "\n");

 DLGInput(NULL,CModem.Answer,NULL,9,9,0, SA[1503]);
 AFPrintf(NULL, sout, "\n");

 DLGInput(NULL,CModem.Ring,NULL,9,9,0, SA[1504]);
 AFPrintf(NULL, sout, "\n");

 CModem.Lock=finput(0, SA[1505]);
 AFPrintf(NULL, sout, "\n");

 CModem.HangupMethod=finput(0, SA[1506]);
 AFPrintf(NULL, sout, "\n");

 CModem.AnswerMethod=finput(1, SA[1507]);
 AFPrintf(NULL, sout, "\n");

 DLGInput(NULL,lstr,NULL,6,6,0, SA[1508]);
 tlong = atol(lstr);
 if (tlong) CModem.MaxBaud = tlong;
 AFPrintf(NULL, sout, "\n\n");

 zflag=finput(1, SA[1509]);
 AFPrintf(NULL, sout, "\n\n");
 if (!zflag)
    {AFPrintf(&UserDat, sout, SA[1510]);
     return;
    }

 if (!AddStruct(filename, (char *)&CModem, sizeof(CModem),2))
    {AFPrintf(&UserDat, sout, SA[1511],string);
     return;
    }

 AFPrintf(&UserDat, sout, SA[1512],string);
 return;
}


void Add_Globals()

{int    zflag;
 char   string[255];
 char   filename[80];
 ULONG  tlong;

 zflag=DLGInput(NULL,string,NULL,20,20,1, SA[1513]);
 AFPrintf(NULL, sout, "\n\n");
 if (!zflag)
    {AFPrintf(&UserDat, sout, SA[1479]);
     return;
    }

 ASPrintf(NULL, filename, "%s.globals",string);
 if (!FileSize(filename,&tlong))
    {AFPrintf(&UserDat, sout, SA[1514]);
     return;
    }

 DLGInput(NULL,CGlobals.BBSName,NULL,35,35,0, SA[1515]);
 AFPrintf(NULL, sout, "\n");
 CGlobals.GlobalScreen=finput(1, SA[1516]);
 AFPrintf(NULL, sout, "\n");
 if (CGlobals.GlobalScreen)
    {CGlobals.DefaultScreen=finput(1, SA[1517]);
     AFPrintf(NULL, sout, "\n");
    }

 CGlobals.TimeOut=iinput(2,60,10, SA[1518]);
 AFPrintf(NULL, sout, "\n");

 CGlobals.VerbPause=finput(1, SA[1519]);
 AFPrintf(NULL, sout, "\n");

 CGlobals.AutoAccess=finput(1, SA[1520]);
 AFPrintf(NULL, sout, "\n");
 if (!CGlobals.AutoAccess)
    {DLGInput(NULL,CGlobals.NameList,NULL,19,19,3, SA[1521]);
     AFPrintf(NULL, sout, "\n");
    }

 CGlobals.ConnectDelay=iinput(0,20,1, SA[1522]);
 AFPrintf(NULL, sout, "\n");

 CGlobals.MinBaud=(long)iinput(300,19200,300, SA[1523]);
 AFPrintf(NULL, sout, "\n");

 DLGInput(NULL,CGlobals.DefMenu,NULL,12,12,1, SA[1524]);
 AFPrintf(NULL, sout, "\n");
 ListSets(255);

 CGlobals.CharSet=iinput(1,255,0, SA[1525]);
 AFPrintf(NULL, sout, "\n");

 DLGInput(NULL,CGlobals.CmdStack,NULL,9,9,7, SA[1526]);
 AFPrintf(NULL, sout, "\n\n");

 DLGInput(NULL,CGlobals.ForcedStack,NULL,9,9,7, SA[1527]);
 AFPrintf(NULL, sout, "\n");

 CGlobals.PrivateArea=iinput(1,9999,0, SA[1528]);
 AFPrintf(NULL, sout, "\n\n");
 ListLangs();

 DLGInput(NULL,CGlobals.Language,NULL,21,21,0, SA[1529]);
 AFPrintf(NULL, sout, "\n\n");

 zflag=finput(1, SA[1530]);
 AFPrintf(NULL, sout, "\n\n");
 if (!zflag)
    {AFPrintf(&UserDat, sout, SA[1531]);
     return;
    }

if (!AddStruct(filename, (char *)&CGlobals, sizeof(CGlobals),2))
   {AFPrintf(&UserDat, sout, SA[1532],string);
    return;
   }

 AFPrintf(&UserDat, sout, SA[1533],string);
 return;
}


void Add_Display()

{int    zflag;
 char   string[255];
 char   filename[80];
 ULONG  tlong;
 SHORT  a;

 zflag=DLGInput(NULL,string,NULL,20,20,1, SA[1534]);
 AFPrintf(NULL, sout, "\n\n");

 if (!zflag)
    {
     AFPrintf(&UserDat, sout, SA[1479]);
     return;
    }

 ASPrintf(NULL, filename,"%s.display",string);
 if (!FileSize(filename,&tlong))
    {AFPrintf(&UserDat, sout, SA[1535]);
     return;
    }

 CDisplay.Window.x=iinput(0,10000,0, SA[1536]);
 AFPrintf(NULL, sout, "\n");

 CDisplay.Window.y=iinput(0,10000,0, SA[1537]);
 AFPrintf(NULL, sout, "\n");

 CDisplay.Window.width=iinput(0,10000,640, SA[1538]);
 AFPrintf(NULL, sout, "\n");

 CDisplay.Window.height=iinput(0,10000,200, SA[1539]);
 AFPrintf(NULL, sout, "\n");

 CDisplay.Window.flags  = finput(1, SA[1540]);
 CDisplay.Window.flags ^= 1;
 AFPrintf(NULL, sout, "\n");

 DLGInput(NULL,CDisplay.Window.fontname,NULL,40,40,0, SA[1541]);
 AFPrintf(NULL, sout, "\n");

 CDisplay.Window.fontsize=iinput(1,100,8, SA[1542]);
 AFPrintf(NULL, sout, "\n\n");

 CDisplay.Screen.width=iinput(0,10000,640, SA[1543]);
 AFPrintf(NULL, sout, "\n");

 CDisplay.Screen.height=iinput(0,10000,200, SA[1544]);
 AFPrintf(NULL, sout, "\n");

 CDisplay.Screen.depth=iinput(1,6,3, SA[1545]);
 AFPrintf(NULL, sout, "\n");

 CDisplay.Screen.hires=finput(1, SA[1546]);
 AFPrintf(NULL, sout, "\n");

 CDisplay.Screen.interlace=finput(0, SA[1547]);
 AFPrintf(NULL, sout, "\n");

 CDisplay.Screen.flags=finput(1, SA[1548]);
 AFPrintf(NULL, sout, "\n");

 DLGInput(NULL,CDisplay.Screen.fontname,NULL,40,40,0, SA[1549]);
 AFPrintf(NULL, sout, "\n");

 CDisplay.Screen.fontsize=iinput(1,100,8, SA[1550]);
 AFPrintf(NULL, sout, "\n\n");
 for(a = 0; a < 8; a++)
     CDisplay.Screen.colortable[a]=colortable[a];

 zflag=finput(1, SA[1551]);
 AFPrintf(NULL, sout, "\n\n");
 if (!zflag)
    {
     AFPrintf(&UserDat, sout, SA[1552]);
     return;
    }

if (!AddStruct(filename, (char *)&CDisplay, sizeof(CDisplay),2))
   {
    AFPrintf(&UserDat, sout, SA[1553],string);
    return;
   }

 AFPrintf(&UserDat, sout, SA[1554],string);
 return;
}


void DeleteGlobals()

{int  zflag;
 char filename[80];

 ListGlobals();

 DLGInput(temparray,filename,(char *)-1,36,elementnum,6, SA[1559]);
 free(temparray);
 AFPrintf(NULL, sout, "\n\n");

 zflag=finput(0, SA[1560]);
 AFPrintf(NULL, sout, "\n\n");

 if (!zflag)
    {AFPrintf(&UserDat, sout, SA[1561]);
     return;
    }

 strcat(filename,SA[1488]);
 if (!DeleteFile(filename))
    {AFPrintf(&UserDat, sout, SA[1562]);
     return;
    }

 AFPrintf(&UserDat, sout, SA[1563]);
 return;
}


void Delete_Port()

{int  zflag;
 char filename[80];

 if (!INSTACK)  List_Ports();

 DLGInput(NULL,filename,NULL,35,35,0, SA[1564]);
 AFPrintf(NULL, sout, "\n\n");

 zflag=finput(0, SA[1560]);
 AFPrintf(NULL, sout, "\n\n");

 if (!zflag)
    {AFPrintf(&UserDat, sout, SA[1561]);
     return;
    }

 strcat(filename,SA[1565]);
 if (!DeleteFile(filename))
    {AFPrintf(&UserDat, sout, SA[1566]);
     return;
    }

 AFPrintf(&UserDat, sout, SA[1567]);
 return;
}


void Delete_Display()

{int  zflag;
 char filename[80];

 ListDisplay();

 DLGInput(temparray,filename,(char *)-1,36,elementnum,6, SA[1568]);
 free(temparray);
 AFPrintf(NULL, sout, "\n\n");

 zflag=finput(0, SA[1560]);
 AFPrintf(NULL, sout, "\n\n");

 if (!zflag)
    {AFPrintf(&UserDat, sout, SA[1561]);
     return;
    }

 strcat(filename,SA[1491]);
 if (!DeleteFile(filename))
    {AFPrintf(&UserDat, sout, SA[1569]);
     return;
    }

 AFPrintf(&UserDat, sout, SA[1570]);
 return;
}


void DeleteModem()

{int  zflag;
 char filename[80];

 ListModem();

 DLGInput(temparray,filename,(char *)-1,36,elementnum,6, SA[1571]);
 free(temparray);
 AFPrintf(NULL, sout, "\n\n");

 zflag=finput(0, SA[1560]);
 AFPrintf(NULL, sout, "\n\n");

 if (!zflag)
    {
     AFPrintf(&UserDat, sout, SA[1561]);
     return;
    }

 strcat(filename,SA[1485]);
 if (!DeleteFile(filename))
    {AFPrintf(&UserDat, sout, SA[1572]);
     return;
    }

 AFPrintf(&UserDat, sout, SA[1573]);
 return;
}
  

void Edit_Port()

{int   zflag;
 char  filename[80];
 char  inp;
 char  string[255];
 char  tempmodem[36];
 char  tempglobal[36];
 char  tempdisp[36];
 char  changed = 0;
 ULONG tlong;

 if (!INSTACK)  List_Ports();

 DLGInput(NULL,filename,NULL,3,3,1, SA[1574]);
 AFPrintf(NULL, sout, "\n\n");

 strcat(filename,SA[1565]);
 if (GetFirstStruct(filename, (char *)&CPort,sizeof(CPort)))
    {AFPrintf(&UserDat, sout, SA[1575]);
     return;
    }

 while(TRUE)
      {
       AFPrintf(&UserDat, sout, SA[1576]);
       AFPrintf(&UserDat, sout, SA[1577],CPort.Device);
       AFPrintf(&UserDat, sout, SA[1578],CPort.Unit);

       strcpy(tempmodem,CPort.ModemFile);
       tempmodem[strlen(CPort.ModemFile)-6] = '\0';

       AFPrintf(&UserDat, sout, SA[1579],tempmodem);
       strcpy(tempglobal,CPort.GlobalFile);
       tempglobal[strlen(CPort.GlobalFile)-8] = '\0';

       AFPrintf(&UserDat, sout, SA[1580],tempglobal);
       strcpy(tempdisp,CPort.DisplayFile);
       tempdisp[strlen(CPort.DisplayFile)-8] = '\0';

       AFPrintf(&UserDat, sout, SA[1581],tempdisp);

       inp=iinput(1,5,0, SA[1582]);
       AFPrintf(NULL, sout, "\n\n");

       switch(inp)
             {case 1:
                      zflag=DLGInput(NULL,string,CPort.Device,35,35,0, SA[1583]);
                      AFPrintf(NULL, sout, "\n\n");
                      if (zflag)
                         {strcpy(CPort.Device,string);
                          changed = 1;
                         }
                      break;

              case 2:
                      CPort.Unit=iinput(0,127,CPort.Unit, SA[1584]);
                      AFPrintf(NULL, sout, "\n\n");
                      changed = 1;
                      break;

              case 3: while(TRUE)
                           {ListModem();
                            zflag=DLGInput(temparray,string,(char *)-1,36,elementnum,6, SA[1585]);
                            free(temparray);
                            AFPrintf(NULL, sout, "\n\n");
                            if (zflag==-1)   break;

                            ASPrintf(NULL, CPort.ModemFile,"%s.modem",string);
                            if (FileSize(CPort.ModemFile,&tlong))
                               {AFPrintf(&UserDat, sout, SA[1586]);
                                continue;
                               }

                            changed = 1;
                            break;
                           }
                      break;

              case 4: while(TRUE)
                           {ListGlobals();
                            zflag=DLGInput(temparray,string,(char *)-1,36,elementnum,6, SA[1587]);
                            free(temparray);
                            AFPrintf(NULL, sout, "\n\n");
                            if (zflag==-1)  break;

                            ASPrintf(NULL, CPort.GlobalFile,"%s.globals",string);
                            if (FileSize(CPort.GlobalFile,&tlong))
                               {AFPrintf(&UserDat, sout, SA[1586]);
                                continue;
                               }

                            changed = 1;
                            break;
                           }
                      break;

              case 5: while(TRUE)
                           {ListDisplay();
                            zflag=DLGInput(temparray,string,(char *)-1,36,elementnum,6, SA[1588]);
                            free(temparray);
                            AFPrintf(NULL, sout, "\n\n");
                            if (zflag==-1)   break;

                            ASPrintf(NULL, CPort.DisplayFile,"%s.display",string);
                            if (FileSize(CPort.DisplayFile,&tlong))
                               {AFPrintf(&UserDat, sout, SA[1586]);
                                continue;
                               }

                            changed = 1;
                            break;
                           }
                      break;

              case 0: if (!changed) return;
                      zflag = finput(1, SA[1589]);
                      AFPrintf(NULL, sout, "\n\n");
                      if (!zflag)
                         {AFPrintf(&UserDat, sout, SA[1590]);
                          return;
                         }

                      DeleteFile(filename);
                      AddStruct(filename, (char *)&CPort, sizeof(CPort),2);
                      AFPrintf(&UserDat, sout, SA[1591]);
                      return;
                      break;
             }
      }
}


void Edit_Display()

{int   zflag;
 char  filename[80];
 char  string[255];
 char  changed = 0;
 char  inp;

 ListDisplay();

 DLGInput(temparray,filename,(char *)-1,36,elementnum,6, SA[1592]);
 free(temparray);
 AFPrintf(NULL, sout, "\n\n");

 strcat(filename,SA[1491]);
 if (GetFirstStruct(filename, (char *)&CDisplay, sizeof(CDisplay)))
    {AFPrintf(&UserDat, sout, SA[1593]);
     return;
    }

 while(TRUE)
      {
       AFPrintf(&UserDat, sout, SA[1594]);
       AFPrintf(&UserDat, sout, SA[1595]);
       AFPrintf(&UserDat, sout, SA[1596],CDisplay.Window.x);
       AFPrintf(&UserDat, sout, SA[1597],CDisplay.Window.y);
       AFPrintf(&UserDat, sout, SA[1598],CDisplay.Window.width);
       AFPrintf(&UserDat, sout, SA[1599],CDisplay.Window.height);
       AFPrintf(&UserDat, sout, SA[1600],(CDisplay.Window.flags)?SA[1601]:SA[1602]);
       AFPrintf(&UserDat, sout, SA[1603],CDisplay.Window.fontname);
       AFPrintf(&UserDat, sout, SA[1604],CDisplay.Window.fontsize);
       AFPrintf(&UserDat, sout, SA[1605]);
       AFPrintf(&UserDat, sout, SA[1606],CDisplay.Screen.width);
       AFPrintf(&UserDat, sout, SA[1607],CDisplay.Screen.height);
       AFPrintf(&UserDat, sout, SA[1608],CDisplay.Screen.depth);
       AFPrintf(&UserDat, sout, SA[1609],(CDisplay.Screen.hires)?SA[1602]:SA[1601]);
       AFPrintf(&UserDat, sout, SA[1610],(CDisplay.Screen.interlace)?SA[1602]:SA[1601]);
       AFPrintf(&UserDat, sout, SA[1611],(CDisplay.Screen.flags)?SA[1602]:SA[1601]);
       AFPrintf(&UserDat, sout, SA[1612],CDisplay.Screen.fontname);
       AFPrintf(&UserDat, sout, SA[1613],CDisplay.Screen.fontsize);
       AFPrintf(&UserDat, sout, SA[1614]);

       inp=iinput(1,16,0, SA[1582]);
       AFPrintf(NULL, sout, "\n\n");

       switch(inp)
             {case 1:
                      CDisplay.Window.x=iinput(0,10000,CDisplay.Window.x, SA[1536]);
                      AFPrintf(NULL, sout, "\n\n");
                      changed = 1;
                      break;

              case 2:
                      CDisplay.Window.y=iinput(0,10000,CDisplay.Window.y, SA[1537]);
                      AFPrintf(NULL, sout, "\n\n");
                      changed = 1;
                      break;

              case 3:
                      CDisplay.Window.width=iinput(0,10000,CDisplay.Window.width, SA[1538]);
                      AFPrintf(NULL, sout, "\n\n");
                      changed = 1;
                      break;

              case 4:
                      CDisplay.Window.height=iinput(0,10000,CDisplay.Window.height, SA[1539]);
                      AFPrintf(NULL, sout, "\n\n");
                      changed = 1;
                      break;

              case 5: CDisplay.Window.flags^=1;
                      changed = 1;
                      break;      

              case 6:
                      zflag=DLGInput(NULL,string,CDisplay.Window.fontname,40,40,0, SA[1541]);
                      AFPrintf(NULL, sout, "\n\n");
                      if (!zflag)  break;

                      strcpy(CDisplay.Window.fontname,string);
                      changed = 1;
                      break;

              case 7:
                      CDisplay.Window.fontsize=iinput(0,10000,CDisplay.Window.fontsize, SA[1542]);
                      AFPrintf(NULL, sout, "\n\n");
                      changed = 1;
                      break;

              case 8:
                      CDisplay.Screen.width=iinput(0,10000,CDisplay.Screen.width, SA[1543]);
                      AFPrintf(NULL, sout, "\n\n");
                      changed = 1;
                      break;

              case 9:
                      CDisplay.Screen.height=iinput(0,10000,CDisplay.Screen.width, SA[1544]);
                      AFPrintf(NULL, sout, "\n\n");
                      changed = 1;
                      break;

             case 10:
                      CDisplay.Screen.depth=iinput(1,5,CDisplay.Screen.depth, SA[1615]);
                      AFPrintf(NULL, sout, "\n\n");
                      changed = 1;
                      break;

             case 11: CDisplay.Screen.hires=(CDisplay.Screen.hires+1)&1;
                      changed = 1;
                      break;

             case 12: CDisplay.Screen.interlace=(CDisplay.Screen.interlace+1)&1;
                      changed = 1;
                      break;

             case 13: CDisplay.Screen.flags^=1;
                      changed = 1;
                      break;

             case 14:
                      zflag=DLGInput(NULL,string,CDisplay.Screen.fontname,40,40,0, SA[1549]);
                      AFPrintf(NULL, sout, "\n\n");
                      if (!zflag)  break;
                      strcpy(CDisplay.Screen.fontname,string);
                      changed = 1;
                      break;

             case 15:
                      CDisplay.Screen.fontsize=iinput(0,10000,CDisplay.Screen.fontsize, SA[1550]);
                      AFPrintf(NULL, sout, "\n\n");
                      changed = 1;
                      break;

             case 16: if (Strnicmp(Ext,"TL",2))
                         {
                          AFPrintf(&UserDat, sout, SA[1616]);
                          break;
                         }

                      ColorReq(CDisplay.Screen.colortable,CDisplay.Screen.width,CDisplay.Screen.height,CDisplay.Screen.interlace,CDisplay.Screen.hires);
                      changed = 1;
                      break;

              case 0: if (!changed)  return;
                      zflag=finput(1, SA[1589]);
                      AFPrintf(NULL, sout, "\n\n");
                      if (!zflag)
                         {
                          AFPrintf(&UserDat, sout, SA[1590]);
                          return;
                         }

                      DeleteFile(filename);
                      AddStruct(filename, (char *)&CDisplay, sizeof(CDisplay),2);
                      AFPrintf(&UserDat, sout, SA[1591]);
                      return;
                      break;
             }
      }
}


void Add_Directory(char *name)

{struct FileLock *lock;

 if ((lock=(struct FileLock *)CreateDir(name)) != 0)
      UnLock((BPTR)lock);
}


void Print_Globals()

{AFPrintf(&UserDat, sout, SA[1617],  CGlobals.BBSName);
 AFPrintf(&UserDat, sout, SA[1618], (CGlobals.GlobalScreen)?SA[1602]:SA[1601]);
 AFPrintf(&UserDat, sout, SA[1619], (CGlobals.DefaultScreen)?SA[1620]:SA[1621]);
 AFPrintf(&UserDat, sout, SA[1622], (CGlobals.VerbPause)?SA[1623]:SA[1624]);
 AFPrintf(&UserDat, sout, SA[1625], (CGlobals.AutoAccess)?SA[1626]:SA[1627]);

 if (!CGlobals.AutoAccess)
      AFPrintf(&UserDat, sout, SA[1628], CGlobals.NameList);

 AFPrintf(&UserDat, sout, SA[1629],  CGlobals.TimeOut);
 AFPrintf(&UserDat, sout, SA[1630],  CGlobals.ConnectDelay);
 AFPrintf(&UserDat, sout, SA[1631],  CGlobals.MinBaud);
 AFPrintf(&UserDat, sout, SA[1632],  CGlobals.DefMenu);
 AFPrintf(&UserDat, sout, SA[1633],  CGlobals.CmdStack);
 AFPrintf(&UserDat, sout, SA[1634],  CGlobals.ForcedStack);
 AFPrintf(&UserDat, sout, SA[1635],  CGlobals.PrivateArea);
 AFPrintf(&UserDat, sout, SA[1636],  CGlobals.CharSet);
 AFPrintf(&UserDat, sout, SA[1637],  CGlobals.Language);
 AFPrintf(&UserDat, sout, SA[1638], (CGlobals.Flags&AUTO_ANSI)?SA[1602]:SA[1601]);
}


void Edit_Globals()

{int   zflag;
 char  filename[80];
 char  inp;
 char  changed = 0;

 ListGlobals();

 DLGInput(temparray,filename,(char *)-1,36,elementnum,6, SA[1639]);
 free(temparray);
 AFPrintf(NULL, sout, "\n\n");

 strcat(filename,".globals");
 if (GetFirstStruct(filename, (char *)&CGlobals, sizeof(CGlobals)))
    {AFPrintf(&UserDat, sout, SA[1640]);
     return;
    }

 while(TRUE)
      {
       AFPrintf(&UserDat, sout, SA[1641],filename);
       Print_Globals();
       inp=iinput(1,16,0, SA[1582]);
       AFPrintf(NULL, sout, "\n\n");
       if (inp)  changed = 1;
       switch(inp)
             {case 1:
                      DLGInput(NULL,CGlobals.BBSName,CGlobals.BBSName,35,35,0, SA[1515]);
                      AFPrintf(NULL, sout, "\n\n");
                      break;

              case 2: CGlobals.GlobalScreen=(CGlobals.GlobalScreen+1)&1;
                      break;

              case 3: CGlobals.DefaultScreen=(CGlobals.DefaultScreen+1)&1;
                      break;

              case 4: CGlobals.VerbPause=(CGlobals.VerbPause+1)&1;
                      break;

              case 5: CGlobals.AutoAccess=(CGlobals.AutoAccess+1)&1;
                      break;

              case 6:
                      DLGInput(NULL,CGlobals.NameList,NULL,19,19,3, SA[1521]);
                      AFPrintf(NULL, sout, "\n\n");
                      break;

              case 7:
                      CGlobals.TimeOut=iinput(2,60,CGlobals.TimeOut, SA[1518]);
                      AFPrintf(NULL, sout, "\n\n");
                      break;

              case 8:
                      CGlobals.ConnectDelay=iinput(0,20,CGlobals.ConnectDelay, SA[1642]);
                      AFPrintf(NULL, sout, "\n\n");
                      break;

              case 9:
                      CGlobals.MinBaud=(long)iinput(300,19200,CGlobals.MinBaud, SA[1523]);
                      AFPrintf(NULL, sout, "\n\n");
                      break;

             case 10:
                      DLGInput(NULL,CGlobals.DefMenu,CGlobals.DefMenu,12,12,1, SA[1524]);
                      AFPrintf(NULL, sout, "\n\n");
                      break;

             case 11:
                      DLGInput(NULL,CGlobals.CmdStack,CGlobals.CmdStack,9,9,7, SA[1526]);
                      AFPrintf(NULL, sout, "\n\n");
                      break;

             case 12:
                      DLGInput(NULL,CGlobals.ForcedStack,CGlobals.ForcedStack,9,9,7, SA[1527]);
                      AFPrintf(NULL, sout, "\n\n");
                      break;

             case 13:
                      CGlobals.PrivateArea=iinput(1,9999,0, SA[1643]);
                      AFPrintf(NULL, sout, "\n\n");
                      break;

             case 14: ListSets(255);
                      CGlobals.CharSet=iinput(1,255,0, SA[1644]);
                      AFPrintf(NULL, sout, "\n\n");
                      break;

             case 15: ListLangs();
                      DLGInput(NULL,CGlobals.Language,CGlobals.Language,21,21,0, SA[1529]);
                      AFPrintf(NULL, sout, "\n\n");
                      break;

             case 16: if (!(CGlobals.Flags & AUTO_ANSI))
                         {CGlobals.Flags |=   AUTO_ANSI;
                          CGlobals.Flags &= ~(ANSI_COLOR + ANSI_CLR + ANSI_POS + ANSI_SCROLL + ANSI_NOFREEZE);
                          CGlobals.Flags |=   ANSI_COLOR + ANSI_CLR + ANSI_POS;
                          GetAnsi();
                         }
                        else
                          CGlobals.Flags &= ~AUTO_ANSI;
                      break;

              case 0: if (!changed) return;
                      zflag=finput(1, SA[1589]);
                      AFPrintf(NULL, sout, "\n\n");
                      if (!zflag)
                         {AFPrintf(&UserDat, sout, SA[1590]);
                          return;
                         }

                      DeleteFile(filename);
                      AddStruct(filename, (char *)&CGlobals, sizeof(CGlobals),2);
                      AFPrintf(&UserDat, sout, SA[1591]);
                      return;
                      break;
             }
      }
}


void Define_Computer_Types()

{int                  zflag;
 int                  fp;
 SHORT                count;
 struct Computer_Type Ct;
 char                 inp[3];

 while(TRUE)
      {count = DisplayComputerTypes();

       DLGInput(NULL,inp,NULL,1,255,1, SA[1645]);
       AFPrintf(NULL, sout, "\n\n");

       switch(inp[0])
             {case 0:   return;
                        break;

              case 'A': Ct.Number = count+1;
                        DLGInput(NULL,Ct.Name,NULL,36,36,0, SA[1646]);
                        AFPrintf(NULL, sout, "\n\n");
                        zflag=finput(0, SA[1647]);
                        AFPrintf(NULL, sout, "\n\n");
                        if (!zflag)  break;

                        if ((fp = open("DlgConfig:Port/ComputerTypes.bbs",O_RDWR | O_CREAT)) == EOF)
                           {
                            AFPrintf(&UserDat, sout, SA[1648]);
                            return;
                           }

                        lseek(fp,0L,2);
                        write(fp,&Ct,sizeof(Ct));
                        close(fp);
                        break;
             }
      }
}


SHORT DisplayComputerTypes()

{struct Computer_Type Ct;
 int                  fp;
 SHORT                count;

 count = 0;
 if ((fp = open("DlgConfig:Port/ComputerTypes.bbs",O_RDONLY)) == EOF)  return(0);

 while(read(fp,&Ct,sizeof(Ct)) == sizeof(Ct))
      {count++;
       AFPrintf(&UserDat, sout, SA[1649],Ct.Number,Ct.Name);
      }

 AFPrintf(NULL, sout, "\n");

 close(fp);
 return(count);
}


void Edit_Modem()

{int   zflag;
 char  filename[80];
 char  string[255];
 char  changed = 0;
 char  inp;
 long  tlong;

 ListModem();

 DLGInput(temparray,filename,(char *)-1,36,elementnum,6, SA[1650]);
 free(temparray);
 AFPrintf(NULL, sout, "\n\n");

 strcat(filename,SA[1485]);
 if (GetFirstStruct(filename, (char *)&CModem, sizeof(CModem)))
    {AFPrintf(&UserDat, sout, SA[1651]);
     return;
    }

 while(TRUE)
      {
       AFPrintf(&UserDat, sout, SA[1652]);
       AFPrintf(&UserDat, sout, SA[1653],CModem.Init);
       AFPrintf(&UserDat, sout, SA[1654],CModem.Hangup);
       AFPrintf(&UserDat, sout, SA[1655],CModem.CommandMode);
       AFPrintf(&UserDat, sout, SA[1656],CModem.Reset);
       AFPrintf(&UserDat, sout, SA[1657],CModem.Answer);
       AFPrintf(&UserDat, sout, SA[1658],CModem.Ring);
       AFPrintf(&UserDat, sout, SA[1659], (CModem.Lock)?SA[1602]:SA[1601]);
       AFPrintf(&UserDat, sout, SA[1660], (CModem.HangupMethod)?SA[1602]:SA[1601]);
       AFPrintf(&UserDat, sout, SA[1661], (CModem.AnswerMethod)?SA[1602]:SA[1601]);
       AFPrintf(&UserDat, sout, SA[1662],CModem.MaxBaud);

       inp=iinput(1,10,0, SA[1502]);
       AFPrintf(NULL, sout, "\n\n");
       switch(inp)
             {case 1:
                      DLGInput(NULL,CModem.Init,CModem.Init,79,79,0, SA[1499]);
                      AFPrintf(NULL, sout, "\n\n");
                      changed = 1;
                      break;

              case 2:
                      DLGInput(NULL,CModem.Hangup,CModem.Hangup,9,9,0, SA[1500]);
                      AFPrintf(NULL, sout, "\n\n");
                      changed = 1;
                      break;

              case 3:
                      DLGInput(NULL,CModem.CommandMode,CModem.CommandMode,9,9,0, SA[1501]);
                      AFPrintf(NULL, sout, "\n\n");
                      changed = 1;
                      break;

              case 4:
                      DLGInput(NULL,CModem.Reset,CModem.Reset,9,9,0, SA[1502]);
                      AFPrintf(NULL, sout, "\n\n");
                      changed = 1;
                      break;

              case 5:
                      DLGInput(NULL,CModem.Answer,CModem.Answer,9,9,0, SA[1503]);
                      AFPrintf(NULL, sout, "\n\n");
                      changed = 1;
                      break;

              case 6:
                      DLGInput(NULL,CModem.Ring,CModem.Ring,9,9,0, SA[1504]);
                      AFPrintf(NULL, sout, "\n\n");
                      changed = 1;
                      break;

              case 7: CModem.Lock=(CModem.Lock+1)&1;
                      changed = 1;
                      break;

              case 8: CModem.HangupMethod=(CModem.HangupMethod+1)&1;
                      changed = 1;
                      break;

              case 9: CModem.AnswerMethod=(CModem.AnswerMethod+1)&1;
                      changed = 1;
                      break;

             case 10:
                      if (DLGInput(NULL,string,NULL,6,6,0, SA[1508]))
                         {tlong = atol(string);
                          if (tlong) CModem.MaxBaud = tlong;
                          AFPrintf(NULL, sout, "\n\n");
                          changed = 1;
                         }
                      break;

              case 0: if (!changed)  return;
                      zflag=finput(1, SA[1589]);
                      AFPrintf(NULL, sout, "\n\n");
                      if (!zflag)
                         {AFPrintf(&UserDat, sout, SA[1590]);
                          return;
                         }

                      DeleteFile(filename);
                      AddStruct(filename, (char *)&CModem, sizeof(CModem),2);
                      AFPrintf(&UserDat, sout, SA[1591]);
                      return;
                      break;
             }
      }
}


void List_Ports()

{char                *filename;
 struct SearchCookie *sc;

 AFPrintf(&UserDat, sout, SA[1555]);
 sc = (struct SearchCookie *)SearchStart(SA[1556], SA[1557]);

 while(filename = SearchNext(sc))
       AFPrintf(NULL, sout, "%3.3s\n",filename);

 AFPrintf(&UserDat, sout, SA[1558]);
 SearchEnd(sc);
 return;
}


void ListModem()

{char                *filename;
 struct SearchCookie *sc;

 elementnum =  0;
 temparray  = NULL;

 AFPrintf(&UserDat, sout, SA[1555]);

 sc = (struct SearchCookie *)SearchStart("DlgConfig:Port", "*.modem");
 while(filename=SearchNext(sc))
      {filename[strlen(filename) - 6] = 0;
       AFPrintf(NULL, sout, "%s\n", filename);
       elementnum = BuildArray(&temparray, filename, 36, elementnum, 10);
      }

 SearchEnd(sc);
 elementnum = BuildArray(&temparray,NULL,36,elementnum,10);

 AFPrintf(&UserDat, sout, SA[1558]);

 return;
}


void ListDisplay()

{char                *filename;
 struct SearchCookie *sc;

 elementnum =  0;
 temparray  = NULL;

 AFPrintf(&UserDat, sout, SA[1555]);

 sc = SearchStart("DlgConfig:Port","*.display");
 while(filename=SearchNext(sc))
      {filename[strlen(filename) - 8] = 0;
       AFPrintf(NULL, sout, "%s\n",filename);
       elementnum = BuildArray(&temparray, filename, 36, elementnum, 10);
      }

 elementnum = BuildArray(&temparray,NULL,36,elementnum,10);
 SearchEnd(sc);

 AFPrintf(&UserDat, sout, SA[1558]);

 return;
}


void ListGlobals()

{char                *filename;
 struct SearchCookie *sc;

 elementnum =  0;
 temparray  = NULL;

 AFPrintf(&UserDat, sout, SA[1555]);

 sc = SearchStart("DlgConfig:Port","*.globals");
 while(filename=SearchNext(sc))
      {filename[strlen(filename) - 8] = 0;
       AFPrintf(NULL, sout, "%s\n", filename);
       elementnum = BuildArray(&temparray, filename, 36, elementnum, 10);
      }

 elementnum = BuildArray(&temparray,NULL,36,elementnum,10);
 SearchEnd(sc);

 AFPrintf(&UserDat, sout, SA[1558]);

 return;
}


void ListLangs()

{struct SearchCookie *sc;
 char                *filename;

 sc = SearchStart("DLGConfig:Languages", "*.lang");
 AFPrintf(&UserDat, sout, SA[1663]);
 while(filename = SearchNext(sc))
      {filename[strlen(filename) - 5] = 0;
       AFPrintf(NULL, sout, "%s\n", filename);
      }

 SearchEnd(sc);
 AFPrintf(&UserDat, sout, SA[1664]);

 return;
}


void GetAnsi()

{char str[2];

 while(TRUE)
      {if (!INSTACK)
          {AFPrintf(&UserDat, sout, SA[1665]);
           AFPrintf(&UserDat, sout, SA[1666], (CGlobals.Flags & ANSI_COLOR)?SA[1602]:SA[1601]);
           AFPrintf(&UserDat, sout, SA[1667], (CGlobals.Flags & ANSI_POS)?SA[1602]:SA[1601]);
           AFPrintf(&UserDat, sout, SA[1668], (CGlobals.Flags & ANSI_CLR)?SA[1602]:SA[1601]);
           AFPrintf(&UserDat, sout, SA[1669], (CGlobals.Flags & ANSI_SCROLL)?SA[1602]:SA[1601]);
          }
       DLGInput(NULL,str,NULL,1,1,1, SA[1670]);
       TwoLines();

       switch(str[0])
             {case 'S': if (CGlobals.Flags & ANSI_CLR)
                            CGlobals.Flags &= ~ANSI_CLR;
                          else
                            CGlobals.Flags |=  ANSI_CLR;
                        break;

              case 'C': if (CGlobals.Flags & ANSI_COLOR)
                            CGlobals.Flags &= ~ANSI_COLOR;
                          else
                            CGlobals.Flags |=  ANSI_COLOR;
                        break;

              case 'P': if (CGlobals.Flags & ANSI_POS)
                            CGlobals.Flags &= ~ANSI_POS;
                          else
                            CGlobals.Flags |=  ANSI_POS;
                        break;

              case 'T': if (CGlobals.Flags & ANSI_SCROLL)
                            CGlobals.Flags &= ~ANSI_SCROLL;
                          else
                            CGlobals.Flags |=  ANSI_SCROLL;
                        break;

               case 0:  return;
             }
      }
}


void _CXBRK()

{if (GfxBase)        CloseLibrary((struct Library *)GfxBase);
 if (IntuitionBase)  CloseLibrary((struct Library *)IntuitionBase);

 WriteRam(&RStruct, Ext);

 if (!Overlay)  ChainProgram("DLG:Menu", Ext);

 CloseLibrary(DLGBase);
 exit(0);
}
