#define   ANSICOL

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <dos.h>
#include <fcntl.h>
#include <stat.h>
#include <exec/types.h>
#include <libraries/dosextens.h>
#include <devices/tpt.h>

#include <dlg/dlg.h>
#include <dlg/user.h>
#include <dlg/msg.h>
#include <dlg/input.h>
#include <dlg/menu.h>
#include <dlg/resman.h>
#include <dlg/log.h>
#include <dlg/file.h>
#include <dlg/misc.h>

#include <Link/Config.h>
#include <Link/File.h>
#include <Link/io.h>
#include <Link/util.h>

#include <proto/dos.h>
#include <proto/exec.h>
#include <proto/dlg.h>

#include <pragmas/dlg.h>

#include <private/Version.h>
#define  ObjRev "1"
const UBYTE version[]="\0$VER: GenConfig " BUILDVER "." ObjRev " " COPYRIGHT " by Digerati Dreams "__AMIGADATE__;

void  main(void);

void  LogConfig(void);
void  EditorConfig(void);
void  FilePathConfig(void);
void  ListPaths(void);
void  AddPath(void);
void  DelPath(void);
void  ProtocolConfig(void);
void  ArchiveConfig(void);
void  CharSetConfig(void);
void  Define_Log_Levels(void);
void  ListLogs(void);
BYTE  AddLog(void);
BYTE  DeleteLog(void);
BYTE  EditLog(void);
BYTE  AddEditor(void);
BYTE  DelEditor(void);
BYTE  EditEditor(void);
BYTE  AddProtocol(void);
BYTE  ProtoFlags(SHORT *);
BYTE  DelProtocol(void);
BYTE  EditProtocol(void);
void  SpecialFileSwitches(void);
BYTE  DelArchiver(void);
BYTE  AddArchiver(void);
BYTE  EditArchiver(void);
BYTE  DelSet(void);
BYTE  AddSet(void);
BOOL  EditSet(void);
void  DisplaySet(UBYTE *, short);

BYTE  aborted(char *);
void _CXBRK(void);


#define INSTACK  RStruct.Command_Stack[0]
#define STK      RStruct.Command_Stack
#define HOT      UserDat.Hot_Keys


struct USER_DATA UserDat;
struct Ram_File  RStruct;

char             Ext[5];
BOOL             Overlay = FALSE;


struct ShortMenu MainMenu[8]     = {{'L',"Logs",1},
                                    {'E',"Editors",1},
                                    {'P',"Protocols",1},
                                    {'A',"Archivers",1},
                                    {'C',"Char Sets",1},
                                    {'F',"File Paths",1},
                                    {'M',"Prev Menu",1},
                                    {'?',"List Commands",1}
                                   };

struct ShortMenu CharSetMenu[6]  = {{'L',"List Sets",1},
                                    {'A',"Add Set",1},
                                    {'D',"Del Set",1},
                                    {'E',"Edit Set",1},
                                    {'M',"Prev Menu",1},
                                    {'?',"List Commands",1}
                                   };

struct ShortMenu LogMenu[7]      = {{'S',"Set Levels",1},
                                    {'L',"List Custom",1},
                                    {'A',"Add Custom",1},
                                    {'D',"Del Custom",1},
                                    {'E',"Edit Custom",1},
                                    {'M',"Prev Menu",1},
                                    {'?',"List Commands",1}
                                   };

struct ShortMenu EditorMenu[6]   = {{'L',"List Editors",1},
                                    {'A',"Add Editor",1},
                                    {'D',"Del Editor",1},
                                    {'E',"Edit Editor",1},
                                    {'M',"Prev Menu",1},
                                    {'?',"List Commands",1}
                                   };

struct ShortMenu ArchiverMenu[6] = {{'L',"List Arc",1},
                                    {'A',"Add Arc",1},
                                    {'D',"Del Arc",1},
                                    {'E',"Edit Arc",1},
                                    {'M',"Prev Menu",1},
                                    {'?',"List Commands",1}
                                   };

struct ShortMenu FilePaths[5]    = {{'L',"List Paths",1},
                                    {'A',"Add Path",1},
                                    {'D',"Del Path",1},
                                    {'M',"Prev Menu",1},
                                    {'?',"List Commands",1}
                                   };

struct ShortMenu ProtoMenu[6]    = {{'L',"List Proto",1},
                                    {'A',"Add Proto",1},
                                    {'D',"Del Proto",1},
                                    {'E',"Edit Proto",1},
                                    {'M',"Prev Menu",1},
                                    {'?',"List Commands",1}
                                   };

BPTR               sout;
struct Library    *DLGBase =  NULL;
struct LangStruct *ls;
char             **SA;

void main(void) 

{char inp[2];

 sout = Output();
 if (!(DLGBase = OpenLibrary(DLGNAME, DLGVERSION)))  exit(5);

 if (GetDevName(Ext) == -1)            _CXBRK();
 if (!ReadUser(&RStruct,&UserDat,Ext))  _CXBRK();
 if (!(ls = GetLang(Ext)))             _CXBRK();
 SA = ls->strings;


 WriteLog(SYSOP_CONFIG, RStruct.Name,Ext, "");

 while(1)
      {switch(UserDat.Help_Level)
             {case 0:  printf(SA[680]);
                       Draw_Line(UserDat.Screen_Width);
                       menu(MainMenu,8,0);
                       printf(SA[681]);
                       Draw_Line(UserDat.Screen_Width);
                       printf("\n");
                       break;

              case 1:  menu(MainMenu,8,1);
                       printf("\n\n");
                       break;

              case 2:  break;
             }

       DLGInput(NULL,inp,NULL,1,127,1, SA[682]);
       Clr(UserDat.Ansi_Flag);

       switch(inp[0])
             {case 'L':  LogConfig();
                         break;
  
              case 'E':  EditorConfig();
                         break;

              case 'P':  ProtocolConfig();
                         break;
    
              case 'A':  ArchiveConfig();
                         break;

              case 'C':  CharSetConfig();
                         break;

              case 'F':  FilePathConfig();
                         break;

              case '?':  if (UserDat.Help_Level==0)  break;
                         printf(SA[680]);
                         Draw_Line(UserDat.Screen_Width);
                         menu(MainMenu,8,0);
                         printf(SA[681]);
                         Draw_Line(UserDat.Screen_Width);
                         printf("\n");
                         break;

              case 'M':  if (!INSTACK)  Clr(UserDat.Ansi_Flag);
                        _CXBRK();
                         break;
             }
      }
}


void LogConfig(void)

{char inp[2];

 while(1)
      {switch(UserDat.Help_Level)
             {case 0:  printf(SA[683]);
                       Draw_Line(UserDat.Screen_Width);
                       menu(LogMenu,7,0);
                       printf(SA[681]);
                       Draw_Line(UserDat.Screen_Width);
                       printf("\n");
                       break;

              case 1:  menu(LogMenu,7,1);
                       printf("\n\n");
                       break;

              case 2:  break;
             }

       DLGInput(NULL,inp,NULL,1,127,1, SA[684]);
       Clr(UserDat.Ansi_Flag);

       switch(inp[0])
             {case 'E':  EditLog();
                         break;

              case 'L':  ListLogs();
                         break;

              case 'A':  AddLog();
                         break;

              case 'M':  return;
                         break;

              case 'S':  Define_Log_Levels();
                         break;

              case 'D':  DeleteLog();
                         break;

              case '?':  if (UserDat.Help_Level==0)  break;
                         printf(SA[683]);
                         Draw_Line(UserDat.Screen_Width);
                         menu(LogMenu,6,0);
                         printf(SA[681]);
                         Draw_Line(UserDat.Screen_Width);
                         printf("\n");
                         break;
             }
      }
}


void EditorConfig(void)

{char inp[2];

 while(1)
      {switch(UserDat.Help_Level)
             {case 0:  printf(SA[685]);
                       Draw_Line(UserDat.Screen_Width);
                       menu(EditorMenu,6,0);
                       printf(SA[681]);
                       Draw_Line(UserDat.Screen_Width);
                       printf("\n");
                       break;

              case 1:  menu(EditorMenu,6,1);
                       printf("\n\n");
                       break;

              case 2:  break;
             }

       DLGInput(NULL,inp,NULL,1,127,1, SA[686]);
       Clr(UserDat.Ansi_Flag);

       switch(inp[0])
             {case 'D':  DelEditor();
                         break;

              case 'E':  EditEditor();
                         break;

              case 'L':  ListEditors(255);
                         break;

              case 'A':  AddEditor();
                         break;

              case 'M':  return;
                         break;

              case '?':  if (UserDat.Help_Level==0)  break;
                         printf(SA[685]);
                         Draw_Line(UserDat.Screen_Width);
                         menu(EditorMenu,6,0);
                         printf(SA[681]);
                         Draw_Line(UserDat.Screen_Width);
                         printf("\n");
                         break;
             }
      }
}


void FilePathConfig(void)

{char inp[2];

 while(1)
      {switch(UserDat.Help_Level)
             {case 0:  printf(SA[687]);
                       Draw_Line(UserDat.Screen_Width);
                       menu(FilePaths,5,0);
                       printf(SA[681]);
                       Draw_Line(UserDat.Screen_Width);
                       printf("\n");
                       break;

              case 1:  menu(FilePaths,5,1);
                       printf("\n\n");
                       break;

              case 2:  break;
             }

       DLGInput(NULL,inp,NULL,1,127,1, SA[688]);
       Clr(UserDat.Ansi_Flag);

       switch(inp[0])
             {case 'D':  DelPath();
                         break;

              case 'L':  ListPaths();
                         break;

              case 'A':  AddPath();
                         break;

              case 'M':  return;
                         break;

              case '?':  if (UserDat.Help_Level==0)  break;
                         printf(SA[687]);
                         Draw_Line(UserDat.Screen_Width);
                         menu(FilePaths,5,0);
                         printf(SA[681]);
                         Draw_Line(UserDat.Screen_Width);
                         printf("\n");
                         break;
             }
      }
}


void ListPaths(void)

{int         fp;
 struct path Path;

 if ((fp=open("DLGConfig:Misc/FilePaths.bbs",O_RDONLY))!=EOF)
    {Draw_Line(60);
     while((read(fp, &Path, sizeof(Path))))
            printf("%s\n", Path.path);
     close(fp);
     Draw_Line(60);
     printf("\n");
    }

 return;
}


void AddPath(void)

{struct path Path;
 int         a;

 DLGInput(NULL,Path.path,NULL,58,58,0, SA[689]);
 printf("\n\n");

 a = strlen(Path.path);
 if (Path.path[a-1]!='/' && Path.path[a-1]!=':')
    {Path.path[a++] = '/';
     Path.path[a]   =  0;
    }

 AddStruct("DLGConfig:Misc/FilePaths.bbs",(char *)&Path,60,58);
 return;
}


void DelPath(void)

{struct path Path;
 int         a;

 ListPaths();
 DLGInput(NULL,Path.path,NULL,58,58,0, SA[690]);
 printf("\n\n");

 a = strlen(Path.path);
 if (Path.path[a-1]!='/' && Path.path[a-1]!=':')
    {Path.path[a++] = '/';
     Path.path[a]   =  0;
    }

 DeleteStruct("DLGConfig:Misc/FilePaths.bbs",(char*)&Path,60,58);
 return;
}


void ProtocolConfig(void)

{char inp[2];
 char valid[256];

 while(1)
      {switch(UserDat.Help_Level)
             {case 0:  printf(SA[691]);
                       Draw_Line(UserDat.Screen_Width);
                       menu(ProtoMenu,6,0);
                       printf(SA[681]);
                       Draw_Line(UserDat.Screen_Width);
                       printf("\n");
                       break;

              case 1:  menu(ProtoMenu,6,1);
                       printf("\n\n");
                       break;

              case 2:  break;
             }

       DLGInput(NULL,inp,NULL,1,127,1, SA[692]);
       Clr(UserDat.Ansi_Flag);

       switch(inp[0])
             {case 'L':  ListProtocols(255,valid,0,1);
                         break;

              case 'A':  AddProtocol();
                         break;

              case 'D':  DelProtocol();
                         break;

              case 'E':  EditProtocol();
                         break;

              case 'M':  return;
                         break;

              case '?':  if (UserDat.Help_Level==0)  break;
                         printf(SA[691]);
                         Draw_Line(UserDat.Screen_Width);
                         menu(ProtoMenu,6,0);
                         printf(SA[681]);
                         Draw_Line(UserDat.Screen_Width);
                         printf("\n");
                         break;
             }
      }
}


void ArchiveConfig(void)

{char inp[2];

 while(1)
      {switch(UserDat.Help_Level)
             {case 0:  printf(SA[693]);
                       Draw_Line(UserDat.Screen_Width);
                       menu(ArchiverMenu,6,0);
                       printf(SA[681]);
                       Draw_Line(UserDat.Screen_Width);
                       printf("\n");
                       break;

              case 1:  menu(ArchiverMenu,6,1);
                       printf("\n\n");
                       break;

              case 2:  break;
             }

       DLGInput(NULL,inp,NULL,1,127,1, SA[694]);
       Clr(UserDat.Ansi_Flag);

       switch(inp[0])
             {case 'D':  DelArchiver();
                         break;

              case 'E':  EditArchiver();
                         break;

              case 'L':  ListArchivers(255,0);
                         break;

              case 'A':  AddArchiver();
                         break;

              case 'M':  return;
                         break;

              case '?':  if (UserDat.Help_Level==0)  break;
                         printf(SA[693]);
                         Draw_Line(UserDat.Screen_Width);
                         menu(ArchiverMenu,6,0);
                         printf(SA[681]);
                         Draw_Line(UserDat.Screen_Width);
                         printf("\n");
                         break;
             }
      }
}


void CharSetConfig(void)

{char inp[2];

 while(1)
      {switch(UserDat.Help_Level)
             {case 0:  printf(SA[695]);
                       Draw_Line(UserDat.Screen_Width);
                       menu(CharSetMenu,6,0);
                       printf(SA[681]);
                       Draw_Line(UserDat.Screen_Width);
                       printf("\n");
                       break;

              case 1:  menu(CharSetMenu,6,1);
                       printf("\n\n");
                       break;

              case 2:  break;
             }

       DLGInput(NULL,inp,NULL,1,127,1, SA[696]);
       Clr(UserDat.Ansi_Flag);

       switch(inp[0])
             {case 'D':  DelSet();
                         break;

              case 'E':  EditSet();
                         break;

              case 'L':  ListSets(255);
                         break;

              case 'A':  AddSet();
                         break;

              case 'M':  return;
                         break;

              case '?':  if (UserDat.Help_Level==0)  break;
                         printf(SA[695]);
                         Draw_Line(UserDat.Screen_Width);
                         menu(CharSetMenu,6,0);
                         printf(SA[681]);
                         Draw_Line(UserDat.Screen_Width);
                         printf("\n");
                         break;
             }
      }
}


void Define_Log_Levels(void)

{long   zflag;
 int    a;
 char   changed=0;
 struct LogLevels Log;

 GetFirstStruct("DlgConfig:Port/LogLevels.bbs",(char *)&Log,sizeof(Log));
 while(1)
      {printf(SA[697], Log.Log_Access[1],  Log.Log_Access[2]);
       printf(SA[698], Log.Log_Access[3],  Log.Log_Access[4]);
       printf(SA[699], Log.Log_Access[5],  Log.Log_Access[6]);
       printf(SA[700], Log.Log_Access[7],  Log.Log_Access[8]);
       printf(SA[701], Log.Log_Access[9],  Log.Log_Access[10]);
       printf(SA[702], Log.Log_Access[11], Log.Log_Access[12]);
       printf(SA[703], Log.Log_Access[13], Log.Log_Access[14]);
       printf(SA[704], Log.Log_Access[15], Log.Log_Access[16]);
       printf(SA[705], Log.Log_Access[17], Log.Log_Access[18]);
       printf(SA[706], Log.Log_Access[19], Log.Log_Access[20]);
       printf(SA[707], Log.Log_Access[21], Log.Log_Access[22]);
       printf(SA[708], Log.Log_Access[23], Log.Log_Access[24]);
       printf(SA[709], Log.Log_Access[25], Log.Log_Access[26]);
       printf(SA[710], Log.Log_Access[27], Log.Log_Access[28]);

       if (!(a = iinput(1,28,0, SA[711])))
          {printf("\n\n");
           if (!changed)  break;

           zflag = finput(1, SA[712]);
           printf("\n\n");
           if (zflag)
              {DeleteFile("DlgConfig:Port/LogLevels.bbs");
          AddStruct("DlgConfig:Port/LogLevels.bbs",(char *)&Log,sizeof(Log),1);
              }

           break;
          }

       Log.Log_Access[a] = iinput(1,255,255, SA[713]);
       printf("\n\n");
       changed = 1;
      }
}


void ListLogs(void)

{SHORT  retval;
 USHORT pos = 2;
 int    fp;
 char   flippybindle = 0;
 char   moreon       = 1;
 char   line    [256];
 char   templine[80];
 struct Log log;

 if ((fp=open("Dlgconfig:Port/CustomLog.bbs",O_RDONLY))==EOF)  return;

 printf(SA[714]);
 Draw_Line(UserDat.Screen_Width-2);

 while(read(fp, &log, sizeof(log)))
      {if (!flippybindle)
          {sprintf(line,SA[715],log.number,log.desc,log.level);
           flippybindle = 1;
          }
        else
          {sprintf(templine,SA[716], log.number,log.desc,log.level);
           strcat(line, templine);
           flippybindle = 0;
           retval = DisplayBuffer(Output(),line,UserDat.Screen_Width,UserDat.Screen_Len,(UserDat.More_Flag && moreon),UserDat.Ansi_Flag,&pos,0,NULL,1,"\x03");
           if (retval==-2)
               moreon=0;
             else
               if (retval)
                   break;
          }
     }

 if (flippybindle)
    {DisplayBuffer(Output(),line,UserDat.Screen_Width,UserDat.Screen_Len,(UserDat.More_Flag && moreon),UserDat.Ansi_Flag,&pos,0,NULL,1,"\x03");
     printf("\n");
    }

 printf(SA[681]);
 Draw_Line(UserDat.Screen_Width-2);
 close(fp);
}


BYTE AddLog(void)

{struct Log LogEntry;
 long       zflag;

 LogEntry.number = iinput(128,255,0, SA[717]);
 printf("\n\n");
 if (!LogEntry.number)  return(aborted(""));

 zflag = DLGInput(NULL,LogEntry.desc,NULL,21,21,0, SA[718]);
 printf("\n\n");
 if (!zflag)  return(aborted(""));

 LogEntry.level = iinput(1,255,0, SA[719]);
 printf("\n\n");
 if (!LogEntry.level)  return(aborted(""));

 printf(SA[720]);
 if (AddStruct("Dlgconfig:Port/CustomLog.bbs",(char *)&LogEntry,sizeof(LogEntry),1)==-1)
     printf(SA[721]);
   else
     printf(SA[722]);

 return(0);
}


BYTE DeleteLog(void)

{struct Log LogEntry;

 LogEntry.number = iinput(128,255,0, SA[724]);
 printf("\n\n");
 if (!LogEntry.number)  return(aborted(""));

 if (finput(1, SA[725]))
    {printf(SA[726]);
     if (DeleteStruct("Dlgconfig:Port/CustomLog.bbs",(char *)&LogEntry,sizeof(LogEntry),1))
         printf(SA[727]);
       else
         printf(SA[728]);
    }

 printf("\n\n");
 return(0);
}


BYTE EditLog(void)

{struct Log LogEntry;

 LogEntry.number = iinput(128,255,0, SA[729]);
 printf("\n\n");
 if (!LogEntry.number)  return(aborted(""));

 if (GetStruct("Dlgconfig:Port/CustomLog.bbs",(char *)&LogEntry,sizeof(LogEntry),1))
     return(aborted(SA[730]));

 while(1)
      {printf(SA[731],LogEntry.number);
       printf(SA[732],LogEntry.desc);
       printf(SA[733],LogEntry.level);

       switch(iinput(1,2,0, SA[734]))
             {case 1:  DLGInput(NULL,LogEntry.desc,LogEntry.desc,21,21,0, SA[735]);
                       printf("\n\n");
                       break;

              case 2:  LogEntry.level=iinput(1,255,0, SA[736]);
                       printf("\n\n");
                       break;

              case 0:  printf("\n\n");
                       AddStruct("Dlgconfig:Port/CustomLog.bbs",(char *)&LogEntry,sizeof(LogEntry),1);
                       return(0);
                       break;
             }
      }
}


BYTE AddEditor(void)

{long          zflag;
 struct Editor editor;

 editor.number = iinput(1,127,0, SA[737]);
 printf("\n\n");
 if (!editor.number)  return(aborted(""));

 zflag = DLGInput(NULL,editor.name,NULL,59,59,0, SA[738]);
 printf("\n\n");
 if (!zflag)  return(aborted(""));

 printf(SA[739]);
 printf(SA[740]);
 zflag = DLGInput(NULL,editor.callstring,NULL,126,126,7, SA[741]);
 printf("\n\n");
 if (!zflag)  return(aborted(""));

 editor.flags = GetHandFlags(T_RAW | T_KILL_ENABLE | T_CRLF | T_PAUSE | T_VERB_PAUSE | T_DO_PEND | T_DO_TIMEOUT | T_LINEFREEZE, HOT);
 editor.level = iinput(0,255,0, SA[742]);
 printf("\n\n");

 if (!finput(1, SA[743]))
    {printf("\n\n");
     return(aborted(""));
    }

 printf(SA[744]);
 if (AddStruct("Dlgconfig:Misc/Editors.bbs",(char *)&editor,sizeof(editor),1)==-1)
     printf(SA[721]);
   else
     printf(SA[722]);

 return(0);
}


BYTE DelEditor(void)

{struct Editor editor;

 editor.number = iinput(1,127,0, SA[724]);
 printf("\n\n");
 if (!editor.number)  return(aborted(""));

 if (finput(1, SA[725]))
    {printf(SA[726]);
     if (DeleteStruct("Dlgconfig:Misc/Editors.bbs",(char *)&editor,sizeof(editor),1))
         printf(SA[727]);
       else
         printf(SA[728]);
    }

 printf("\n\n");
 return(0);
}


BYTE EditEditor(void)

{struct Editor editor;
 char          tempstring[255];

 ListEditors(255);
 editor.number = iinput(1,127,0, SA[729]);
 printf("\n\n");
 if (!editor.number)  return(aborted(""));

 if (GetStruct("Dlgconfig:Misc/Editors.bbs",(char *)&editor,sizeof(editor),1))
     return(aborted(SA[730]));

 while(1)
      {printf(SA[745], editor.number);
       printf(SA[746], editor.name);
       printf(SA[747], editor.callstring);
       printf(SA[748]);
       printf(SA[749], editor.level);

       switch(iinput(1,4,0, SA[734]))
             {case 1:  DLGInput(NULL,editor.name,editor.name,59,59,0, SA[750]);
                       printf("\n\n");
                       break;

              case 2:  printf(SA[751]);
                       printf(SA[740]);
                       DLGInput(NULL,tempstring,editor.callstring,126,126,0, SA[752]);
                       printf("\n\n");
                       if (strlen(tempstring))
                           strcpy(editor.callstring,tempstring);
                       break;

              case 3:  printf("\n\n");
                       editor.flags = (long)GetHandFlags(editor.flags,HOT);
                       break;

              case 4:  editor.level=iinput(1,255,0, SA[753]);
                       printf("\n\n");
                       break;

              case 0:  printf("\n\n");
                       AddStruct("Dlgconfig:Misc/Editors.bbs",(char *)&editor,sizeof(editor),1);
                       return(0);
                       break;
             }
      }
}


BYTE AddProtocol(void)

{long            zflag;
 struct Protocol protocol;
 char            tempstring[2];

 zflag = DLGInput(NULL,tempstring,NULL,1,1,1, SA[754]);
 protocol.letter = tempstring[0];
 if (!zflag)  return(aborted(""));

 if (!GetStruct("Dlgconfig:Misc/Protocols.bbs",(char *)&protocol,sizeof(protocol),1))
     return(aborted(SA[755]));

 zflag = DLGInput(NULL,protocol.name,NULL,40,40,0, SA[756]);
 if (!zflag)
    {printf("\n");
     return(aborted(""));
    }

 protocol.flags = PROTO_SEND|PROTO_REC;
 if (ProtoFlags(&protocol.flags)==-1)  return(-1);

 printf("\n\n");
 SpecialFileSwitches();

 if (protocol.flags & PROTO_SEND)
     DLGInput(NULL,protocol.sendstring,NULL,80,80,7, SA[757]);
 if (protocol.flags & PROTO_REC)
     DLGInput(NULL,protocol.recstring,NULL,80,80,7, SA[758]);
 if (protocol.flags & PROTO_BATCH)
     DLGInput(NULL,protocol.sendbatch,NULL,80,80,7, SA[759]);
 if (protocol.flags & PROTO_SEND)
     protocol.sendrate=iinput(10,255,100, SA[760]);
   else
     protocol.sendrate=0;
 if (protocol.flags & PROTO_REC)
     protocol.recrate=iinput(10,255,100, SA[761]);
   else
     protocol.recrate=0;

 protocol.sendsuccess = iinput(0,255,0, SA[762]);
 protocol.recsuccess  = iinput(0,255,0, SA[763]);
 protocol.level       = iinput(0,255,0, SA[764]);

 if (!finput(1, SA[765]))
    {printf("\n\n");
     return(aborted(""));
    }

 printf(SA[744]);
 if (AddStruct("Dlgconfig:Misc/Protocols.bbs",(char *)&protocol,sizeof(protocol),1)==-1)
     printf(SA[721]);
   else
     printf(SA[722]);

 return(0);
}


BYTE ProtoFlags(SHORT *flags)

{SHORT newflags = 0;


 if (finput(*flags&PROTO_SEND, SA[766]))   newflags |= PROTO_SEND;
 if (finput(*flags&PROTO_REC, SA[767]))    newflags |= PROTO_REC;
 if (finput(*flags&PROTO_BATCH, SA[768]))  newflags |= PROTO_BATCH;

 if (!newflags)
    {printf("\n\n");
     return(aborted(SA[769]));
    }

 if (finput(*flags&PROTO_RESUME, SA[770]))     newflags |= PROTO_RESUME;
 if (newflags & PROTO_REC)
     if (finput(*flags&PROTO_FNAME, SA[771]))  newflags |= PROTO_FNAME;

 *flags = newflags;

 return(1);
}


BYTE DelProtocol(void)

{struct Protocol protocol;
 char            valid[256];
 char            tempstring[2];

 Clr(UserDat.Ansi_Flag);
 ListProtocols(255,valid,0,1);

 DLGInput(NULL,tempstring,NULL,1,127,1, SA[772]);
 printf("\n\n");
 protocol.letter = tempstring[0];
 if (!protocol.letter)                return(aborted(""));
 if (!index(valid, protocol.letter))  return(aborted(SA[773]));

 if (finput(1,SA[725]))
    {printf(SA[726]);
     if (DeleteStruct("Dlgconfig:Misc/Protocols.bbs",(char *)&protocol,sizeof(protocol),1))
         printf(SA[727]);
       else
         printf(SA[728]);
    }

 printf("\n\n");
 return(1);
}


BYTE EditProtocol(void)

{struct Protocol protocol;
 char            valid[256];
 char            tempstring[2];
 char            option;

 Clr(UserDat.Ansi_Flag);
 ListProtocols(255,valid,0,1);
 DLGInput(NULL,tempstring,NULL,1,127,1, SA[774]);
 protocol.letter = tempstring[0];
 printf("\n\n");
 if (protocol.letter=='\0')          return(aborted(""));
 if (!index(valid,protocol.letter))  return(aborted(SA[773]));

 if (GetStruct("Dlgconfig:Misc/Protocols.bbs",(char *)&protocol,sizeof(protocol),1))
     return(aborted(SA[730]));

 for(;;)
    {Clr(UserDat.Ansi_Flag);
     printf(SA[775], protocol.letter);
     printf(SA[776], protocol.name);
     printf(SA[777], (protocol.flags & PROTO_SEND)?'D':'-',
                     (protocol.flags & PROTO_REC)?'U':'-',
                     (protocol.flags & PROTO_BATCH)?'B':'-',
                     (protocol.flags & PROTO_RESUME)?'R':'-',
                     (protocol.flags & PROTO_FNAME)?'F':'-');

     if (protocol.flags & PROTO_SEND)  printf(SA[778],protocol.sendstring);
     if (protocol.flags & PROTO_REC)   printf(SA[779],protocol.recstring);
     if ((protocol.flags & PROTO_BATCH) && (protocol.flags & PROTO_SEND))
          printf(SA[780],protocol.sendbatch);
     if (protocol.flags & PROTO_SEND)  printf(SA[781],protocol.sendrate);
     if (protocol.flags & PROTO_REC)   printf(SA[782],protocol.recrate);
     if (protocol.flags & PROTO_SEND)  printf(SA[783],protocol.sendsuccess);
     if (protocol.flags & PROTO_REC)   printf(SA[784],protocol.recsuccess);

     printf(SA[785],protocol.level);
     printf("\n\n");

     option = iinput(1,11,0, SA[734]);
     Clr(UserDat.Ansi_Flag);
     switch(option)
           {case 1:  DLGInput(NULL,protocol.name,protocol.name,40,40,0, SA[786]);
                     break;

            case 2:  ProtoFlags(&protocol.flags);
                     break;

            case 3:  if (!(protocol.flags & PROTO_SEND))  break;
                     SpecialFileSwitches();
                     DLGInput(NULL,protocol.sendstring,protocol.sendstring,80,80,7, SA[787]);
                     break;
  
            case 4:  if (!(protocol.flags & PROTO_REC))  break;
                     SpecialFileSwitches();
                     DLGInput(NULL,protocol.recstring,protocol.recstring,80,80,7, SA[788]);
                     break;

            case 5:  if (!(protocol.flags & PROTO_BATCH))  break;
                     SpecialFileSwitches();
                     DLGInput(NULL,protocol.sendbatch,protocol.sendbatch,80,80,7, SA[789]);
                     break;

            case 6:  if (!(protocol.flags & PROTO_SEND))  break;
                     protocol.sendrate=iinput(10,255,protocol.sendrate, SA[790]);
                     break;

            case 7:  if (!(protocol.flags & PROTO_REC))  break;
                     protocol.recrate=iinput(10,255,protocol.recrate, SA[791]);
                     break;

            case 8:  if (!(protocol.flags & PROTO_SEND))  break;
                     protocol.sendsuccess=iinput(0,255,protocol.sendsuccess, SA[792]);
                     break;

            case 9:  if (!(protocol.flags & PROTO_REC))  break;
                     protocol.recsuccess=iinput(0,255,protocol.recsuccess, SA[793]);
                     break;

           case 10:  protocol.level=iinput(0,255,protocol.level, SA[794]);
                     break;

            case 0:  AddStruct("Dlgconfig:Misc/Protocols.bbs",(char *)&protocol,sizeof(protocol),1);
                     return(0);
                     break;
           }

       printf("\n\n");
      }
}


void SpecialFileSwitches(void)

{printf(SA[795]);
 printf(SA[740]);
}


BYTE DelArchiver(void)

{struct Archiver archiver;

 archiver.number = iinput(1,127,0, SA[724]);
 printf("\n\n");
 if (!archiver.number)  return(aborted(""));

 if (finput(1, SA[725]))
    {printf(SA[726]);
     if (DeleteStruct("Dlgconfig:Misc/Archivers.bbs",(char *)&archiver,sizeof(archiver),1))
         printf(SA[727]);
       else  
         printf(SA[728]);
    }

 printf("\n\n");
 return(0);
}


BYTE AddArchiver(void)

{long            zflag;
 struct Archiver archiver;

 archiver.number=iinput(1,127,0, SA[796]);
 printf("\n\n");
 if (!archiver.number)  return(aborted(""));

 zflag = DLGInput(NULL,archiver.name,NULL,59,59,0, SA[797]);
 printf("\n\n");
 if (!zflag)  return(aborted(""));

 zflag = DLGInput(NULL,archiver.extension,NULL,11,59,0, SA[798]);
 printf("\n\n");
 if (!zflag)  return(aborted(""));

 printf(SA[799]);
 printf(SA[740]);
 DLGInput(NULL,archiver.compress,NULL,126,126,7, SA[800]);
 printf("\n");

 archiver.compresssuccess=iinput(0,255,0, SA[801]);
 printf("\n\n");

 DLGInput(NULL,archiver.decompress,NULL,126,126,7, SA[802]);
 printf("\n");

 archiver.decompresssuccess=iinput(0,255,0, SA[803]);
 printf("\n\n");

 DLGInput(NULL,archiver.view,NULL,126,126,7, SA[804]);
 printf("\n");

 archiver.viewsuccess=iinput(0,255,0, SA[805]);
 printf("\n\n");

 DLGInput(NULL,archiver.integrity,NULL,126,126,7, SA[806]);
 printf("\n");

 archiver.integritysuccess=iinput(0,255,0, SA[807]);
 printf("\n\n");

 archiver.compression=iinput(0,100,0, SA[808]);
 printf("\n\n");

 archiver.level=iinput(0,255,0, SA[809]);
 printf("\n\n");

 if (!finput(1, SA[810]))
    {printf("\n\n");
     return(aborted(""));
    }

 printf(SA[744]);
 if (AddStruct("Dlgconfig:Misc/Archivers.bbs",(char *)&archiver,sizeof(archiver),1)==-1)
     printf(SA[721]);
   else  
     printf(SA[722]);

 return(0);
}


BYTE EditArchiver(void)

{long            zflag;
 struct Archiver archiver;
 char            tempstring[255];

 if (!INSTACK)  ListArchivers(255,0);
 archiver.number = iinput(1,127,0, SA[811]);
 printf("\n\n");
 if (!archiver.number)  return(aborted(""));

 if (GetStruct("Dlgconfig:Misc/Archivers.bbs",(char *)&archiver,sizeof(archiver),1))
     return(aborted(SA[730]));

 while(1)
      {printf(SA[812],archiver.number);
       printf(SA[813],archiver.name);
       printf(SA[814],archiver.compress,archiver.compresssuccess);
       printf(SA[815],archiver.decompress,archiver.decompresssuccess);
       printf(SA[816],archiver.view,archiver.viewsuccess);
       printf(SA[817],archiver.integrity,archiver.integritysuccess);
       printf(SA[818],archiver.extension);
       printf(SA[819],archiver.compression);
       printf(SA[820],archiver.level);

       switch(iinput(1,8,0, SA[734]))
             {case 1:  zflag = DLGInput(NULL,tempstring,archiver.name,60,60,0, SA[821]);
                       printf("\n\n");
                       if (!zflag)  break;
                       strcpy(archiver.name,tempstring);
                       break;

              case 2:  printf(SA[822]);
                       printf(SA[740]);
                       DLGInput(NULL,archiver.compress,archiver.compress,126,255,0, SA[800]);
                       printf("\n");
                       archiver.compresssuccess = iinput(0,255,archiver.compresssuccess, SA[801]);
                       printf("\n\n");
                       break;

              case 3:  printf(SA[822]);
                       printf(SA[740]);
                       DLGInput(NULL,archiver.decompress,archiver.decompress,126,255,0, SA[802]);
                       printf("\n");
                       archiver.decompresssuccess = iinput(0,255,archiver.decompresssuccess, SA[803]);
                       printf("\n\n");
                       break;

              case 4:  printf(SA[822]);
                       printf(SA[740]);
                       DLGInput(NULL,archiver.view,archiver.view,126,255,0, SA[804]);
                       printf("\n");
                       archiver.viewsuccess = iinput(0,255,archiver.viewsuccess, SA[805]);
                       printf("\n\n");
                       break;

              case 5:  printf(SA[822]);
                       printf(SA[740]);
                       DLGInput(NULL,archiver.integrity,archiver.integrity,126,255,0, SA[823]);
                       printf("\n");
                       archiver.integritysuccess = iinput(0,255,archiver.integritysuccess, SA[824]);
                       printf("\n\n");
                       break;

              case 6:  zflag = DLGInput(NULL,tempstring,NULL,12,12,0, SA[825]);
                       printf("\n\n");
                       if (!zflag)  break;
                       strcpy(archiver.extension,tempstring);
                       break;

              case 7:  archiver.compression = iinput(0,100,archiver.compression, SA[826]);
                       printf("\n\n");
                       break;

              case 8:  archiver.level = iinput(0,255,archiver.level, SA[827]);
                       printf("\n\n");
                       break;

              case 0:  printf("\n\n");
                       AddStruct("Dlgconfig:Misc/Archivers.bbs",(char *)&archiver,sizeof(archiver),1);
                       return(0);
                       break;
             }
      }
}


BYTE DelSet(void)

{struct CharSet Set;
 char           filename[80];

 if (!INSTACK)  ListSets(255);

 Set.number = iinput(1,127,0, SA[724]);
 printf("\n\n");
 if (!Set.number)  return(aborted(""));

 if (finput(1, SA[725]))
    {printf(SA[726]);
     if (!GetStruct("DLGConfig:CharSets/CharSets.bbs",(char *)&Set,sizeof(Set),1))
        {sprintf(filename,"DLGConfig:CharSets/%s.set",Set.name);
         if (DeleteStruct("DLGConfig:CharSets/CharSets.bbs",(char *)&Set,sizeof(Set),1))
             printf(SA[828], filename);

         DeleteFile(filename);    
         printf(SA[829]);
        }
      else
         printf(SA[721]);
    }

 printf("\n\n");
 return(0);
}


BYTE AddSet(void)

{long           zflag;
 struct CharSet Set;
 char           filename[54];
 char           sevenbit;
 int            fp;
 int            a;
 unsigned char  counter;

 Set.number = iinput(1,127,0, SA[830]);
 printf("\n\n");
 if (!Set.number)  return(aborted(""));

 zflag = DLGInput(NULL,Set.name,NULL,11,11,0, SA[831]);
 printf("\n\n");
 if (!zflag)  return(aborted(""));

 Set.level = iinput(1,255,1, SA[832]);
 printf("\n\n");

 sevenbit = finput(1, SA[833]);
 printf("\n\n");

 printf(SA[834]);

 Set.netname[0] = 0;
 Set.font   [0] = 0;
 Set.keymap [0] = 0;
 for(a=0;a<36;a++)
     Set.filler[a]='\0';

 sprintf(filename,"DLGConfig:CharSets/%s.set",Set.name);
 if (Exists(filename))
    {printf(SA[835], Set.name);
     zflag = finput(0,"");
     printf("\n\n");
     if (!zflag)  return(FALSE);
    }

 if (AddStruct("Dlgconfig:CharSets/CharSets.bbs",(char *)&Set,sizeof(Set),1)==-1)
    {printf(SA[721]);
     return(FALSE);
    }
  else
    {if ((fp=open(filename,O_RDWR+O_CREAT))==EOF)
        {printf(SA[836],filename);
         DeleteStruct("Dlgconfig:CharSets/CharSets.bbs",(char *)&Set,sizeof(Set),1);
         return(FALSE);
        }

     counter = 0;
     for(a=0;a<128;a++)
        {write(fp,&counter,1);
         counter++;
        }

     counter = (sevenbit)?0:128;
     for(a=128;a<256;a++)
        {write(fp,&counter,1);
         counter++;
        }

     counter = 0;
     for(a=0;a<128;a++)
        {write(fp,&counter,1);
         counter++;
        }

     counter = (sevenbit)?0:128;
     for(a=128;a<256;a++)
        {write(fp,&counter,1);
         counter++;
        }

     close(fp);
     printf(SA[722]);
    }

 return(0);
}


BOOL EditSet(void)

{long           zflag;
 struct CharSet Set;
 UBYTE          inarray[256];
 UBYTE          outarray[256];
 char           tempstring[15];
 char           filename[56];
 char           filetwo[56];
 int            fp;
 int            counter;

 if (!INSTACK)  ListSets(255);

 Set.number = iinput(1,127,0, SA[837]);
 printf("\n\n");
 if (!Set.number)  return((BOOL)aborted(""));

 if (GetStruct("Dlgconfig:CharSets/CharSets.bbs",(char *)&Set,sizeof(Set),1))
     return((BOOL)aborted(SA[730]));

 sprintf(filename,"DLGConfig:CharSets/%s.set",Set.name);
 if ((fp=open(filename,O_RDONLY))==EOF)
    {printf(SA[838],filename);
     return(FALSE);
    }

 read(fp, inarray,  256);
 read(fp, outarray, 256);
 close(fp);

 while(1)
      {printf(SA[839],Set.name);
       printf(SA[840],Set.level);
       printf(SA[841]);
       printf(SA[842]);
       printf(SA[843]);
       printf(SA[844]);

       switch(iinput(1,6,0, SA[734]))
             {case 1:  zflag = DLGInput(NULL,tempstring,Set.name,11,11,0, SA[845]);
                       printf("\n\n");
                       if (!zflag)  break;

                       sprintf(filename, "DLGConfig:CharSets/%s.set", Set.name);
                       sprintf(filetwo,  "DLGConfig:CharSets/%s.set", tempstring);
                       Rename(filename, filetwo);
                       strcpy(Set.name, tempstring);
                       break;

              case 2:  Set.level = iinput(1,255, Set.level, SA[846]);
                       printf("\n\n");
                       break;

              case 3:  while(1)
                            {DisplaySet(inarray, 0);

                             counter = iinput(1,127,0, SA[848]);
                             printf("\n"); 
                             if (!counter)  break;

                             inarray[counter] = (char)iinput(0,255,inarray[counter], SA[849]);
                            }

                       Clr(UserDat.Ansi_Flag);
                       break;

              case 4:  while(1)
                            {DisplaySet(inarray, 128);

                             counter = iinput(128,256,0, SA[848]);
                             printf("\n");
                             if (!counter)  break;

                             inarray[counter] = (char)iinput(0,255,inarray[counter],SA[849]);
                            }

                       Clr(UserDat.Ansi_Flag);
                       break;

              case 5:  while(1)
                            {DisplaySet(outarray, 0);

                             counter = iinput(1,127,0, SA[848]);
                             printf("\n");
                             if (!counter)  break;

                             outarray[counter] = (char)iinput(0,255,outarray[counter], SA[849]);
                            }

                       Clr(UserDat.Ansi_Flag);
                       break;

              case 6:  while(1)
                            {DisplaySet(outarray, 128);

                             counter = iinput(128,256,0, SA[848]);
                             printf("\n");
                             if (!counter)  break;
                             outarray[counter] = (char)iinput(0,255,outarray[counter], SA[849]);
                            }

                       Clr(UserDat.Ansi_Flag);
                       break;

              case 0:  Clr(UserDat.Ansi_Flag);
                       AddStruct("DLGConfig:CharSets/CharSets.bbs",(char *)&Set,sizeof(Set),1);

                       if ((fp=open(filename,O_RDWR+O_CREAT))!=EOF)
                          {write(fp, inarray,  256);
                           write(fp, outarray, 256);
                           close(fp);
                          }

                       return(TRUE);
                       break;
             }
      }
}


void DisplaySet(UBYTE *array, short start)

{short linecounter;
 short counter;

 Clr(UserDat.Ansi_Flag);

 linecounter =   0;
 counter     = start;
 start       = start + 128;
 for(; counter < start; counter++)
    {printf(SA[847], counter, array[counter], ((array[counter] > 31 && array[counter] < 128)  ||  array[counter] > 159)?array[counter]:32);
     linecounter++;

     if (linecounter==7)
        {printf("\n");
         linecounter = 0;
        }
    }

 printf("\n\n");
}


BYTE aborted(char *string)

{printf(SA[723],string);
 return(-1);
}


void _CXBRK(void)

{WriteRam(&RStruct,Ext);

 if (!Overlay) ChainProgram("DLG:Menu", Ext);
 CloseLibrary(DLGBase);

 exit(0);
}
