#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <dos.h>
#include <fcntl.h>
#include <stat.h>
#include <exec/types.h>
#include <libraries/dosextens.h>

#include <devices/tpt.h>

#include <dlg/dlg.h>
#include <dlg/user.h>
#include <dlg/msg.h>
#include <dlg/input.h>
#include <dlg/menu.h>
#include <dlg/resman.h>
#include <dlg/log.h>
#include <dlg/file.h>
#include <dlg/misc.h>

#include <link/io.h>

#include <proto/dos.h>
#include <proto/exec.h>
#include <proto/dlg.h>


#define IGNORE_CM 1024
#define INSTACK   RStruct.Command_Stack[0]
#define STK       RStruct.Command_Stack
#define HOT       UserDat.Hot_Keys
#define FIDO     "DLGConfig:Port/FidoNet.Settings"

#include <pragmas/dlg.h>

#include <private/Version.h>
#define  ObjRev "1"
const UBYTE version[]="\0$VER: FidoConfig " BUILDVER "." ObjRev " " COPYRIGHT " by Digerati Dreams "__AMIGADATE__;

void  main(int , char **);
int   HandleBuiltIn(UBYTE );
void  EditConfig(void);
void _CXBRK(void);

struct USER_DATA  UserDat;
struct Ram_File   RStruct;
struct UserInfo   ui      = {&UserDat, &RStruct};
struct Query      q       = {NULL, NULL, NULL, NULL, NULL, 0, 0, 0};
char              Ext[4];

struct NewShortMenu Menu[3]={{"Abort",1},
                             {"FIDOC_Edit",1},
                             {"FIDOC_Exit",1},
                            };


char  Overlay      =  FALSE;
char  exitflag     =  FALSE;
char  MenuName[13] = "FIDOC_Main";

BPTR               sout;
struct Library    *DLGBase = NULL;
struct LangStruct *ls;
char             **SA;


void main(int argc, char *argv[])

{char *s;
 char *stack = NULL;

 sout = Output();
 if (!(DLGBase = OpenLibrary(DLGNAME, DLGVERSION)))  exit(5);

 while(--argc>0)
      {s=*++argv;
       if (*s++=='-')
          {while(*s)
                {switch(*s++)
                       {case  'O':
                        case  'o':  Overlay = TRUE;
                                    break;

                        case 'S':
                        case 's':  if (!--argc)  break;
                                   stack = *++argv;
                                   break;

                        case 'M':
                        case 'm':  if (!--argc)  break;
                                   strncpy(MenuName, *++argv, 12);
                                   MenuName[12]='\0';
                                   break;
                       }
                }
          }
      }

 if (GetDevName(Ext) == -1)  _CXBRK();
 if (!(ls = GetLang(Ext)))   _CXBRK();
 SA = ls->strings;

 if (!ReadUser(&RStruct,&UserDat,Ext)) _CXBRK();
 if (stack)                            InsertStack(STK, stack);

 WriteLog(SYSOP_CONFIG, RStruct.Name,Ext, SA[97]);

 while(!exitflag)
      {Chk_Abort();

       if (MenuInput(MenuName,Ext,"FIDOC",Menu,3,HandleBuiltIn,&UserDat,&RStruct,UserDat.Help_Level,NULL)==MENUNOTFOUND)
           _CXBRK();
      }

 _CXBRK();
}


int HandleBuiltIn(UBYTE cmd)

{switch(cmd)
       {case 0:             /* Abort */
                exitflag = TRUE;
                break;

        case 1:             /* FIDOC_Edit */
                EditConfig();
                break;

        case 2:             /* FIDOC_Exit */
               _CXBRK();
                break;

       default: return(FALSE);
       }

 return(TRUE);
}  


void EditConfig(VOID)

{struct fido FidoNet;
 long   zflag;
 long   inp;
 char   changed = 0;

 GetFirstStruct(FIDO, (char *)&FidoNet, sizeof(FidoNet));

 for(;;)
    {AFPrintf(&UserDat, sout, SA[98]);
     AFPrintf(&UserDat, sout, SA[99],  FidoNet.zone);
     AFPrintf(&UserDat, sout, SA[100], FidoNet.net);
     AFPrintf(&UserDat, sout, SA[101], FidoNet.node);
     AFPrintf(&UserDat, sout, SA[102], FidoNet.point);
     AFPrintf(&UserDat, sout, SA[103], FidoNet.origin);
     AFPrintf(&UserDat, sout, SA[104], FidoNet.nodelistpath);
     AFPrintf(&UserDat, sout, SA[105]);
     AFPrintf(&UserDat, sout, SA[106], (FidoNet.flags&Crash)    ?SA[107]:SA[108]);
     AFPrintf(&UserDat, sout, SA[109], (FidoNet.flags&KillSent) ?SA[107]:SA[108]);
     AFPrintf(&UserDat, sout, SA[110], (FidoNet.flags&IGNORE_CM)?SA[111]:SA[112]);

     FidoNet.flags &= (Crash | KillSent | IGNORE_CM);
     inp = IntQuery(SA[113], 1, 9, 0, &ui);
     AFPrintf(&UserDat, sout, "\n\n");

     switch(inp)
           {case 1:
                    FidoNet.zone  = IntQuery(SA[114], 0, 9999, FidoNet.zone, &ui);
                    AFPrintf(&UserDat, sout, "\n\n");
                    changed = 1;
                    break;

            case 2:
                    FidoNet.net   = IntQuery(SA[115], 0, 32000, FidoNet.net, &ui);
                    AFPrintf(&UserDat, sout, "\n\n");
                    changed = 1;
                    break;

            case 3:
                    FidoNet.node  = IntQuery(SA[116], 0, 32000, FidoNet.node, &ui);
                    AFPrintf(&UserDat, sout, "\n\n");
                    changed = 1;
                    break;

            case 4:
                    FidoNet.point = IntQuery(SA[117], 0, 32000, FidoNet.node, &ui);
                    AFPrintf(&UserDat, sout, "\n\n");
                    changed = 1;
                    break;

            case 5:
                    q.prompt     = SA[118];
                    q.string     = FidoNet.origin;
                    q.defstring  = FidoNet.origin;
                    q.length     = 67;
                    q.typelength = 67;
                    DLGQuery(&q, &ui);
                    AFPrintf(&UserDat, sout, "\n\n");
                    changed = 1;
                    break;

            case 6:
                    q.prompt     = SA[119];
                    q.string     = FidoNet.nodelistpath;
                    q.defstring  = FidoNet.nodelistpath;
                    q.length     = 78;
                    q.typelength = 78;
                    zflag = DLGQuery(&q, &ui);
                    AFPrintf(&UserDat, sout, "\n\n");
                    if (zflag)
                       {if (FidoNet.nodelistpath[zflag-1]!=':' && FidoNet.nodelistpath[zflag-1]!='/')
                           {FidoNet.nodelistpath[zflag]   = '/';
                            FidoNet.nodelistpath[zflag+1] =  0;
                           }

                        changed = 1;
                       }
                    break;

            case 7: if (FidoNet.flags & Crash)
                        FidoNet.flags -= Crash;
                      else
                        FidoNet.flags += Crash;
                    changed = 1;
                    break;

            case 8: if (FidoNet.flags & KillSent)
                        FidoNet.flags -= KillSent;
                      else
                        FidoNet.flags += KillSent;
                    changed = 1;
                    break;

            case 9: if (FidoNet.flags & IGNORE_CM)
                        FidoNet.flags -= IGNORE_CM;
                      else
                        FidoNet.flags += IGNORE_CM;
                    changed = 1;
                    break;

            case 0: if (changed)
                       {zflag = BoolQuery(SA[120], 1, &ui);
                        AFPrintf(&UserDat, sout, "\n\n");
                        if (!zflag)
                           {AFPrintf(&UserDat, sout, SA[121]);
                            return;
                           }

                        DeleteFile(FIDO);
                        AddStruct(FIDO, (char *)&FidoNet, sizeof(FidoNet), 1);
                        AFPrintf(&UserDat, sout, SA[122]);
                       }
                    return;
                    break;
           }
    }
}


void _CXBRK(void)

{WriteRam(&RStruct, Ext);

 if (!Overlay)  ChainProgram("DLG:Menu", Ext);

 CloseLibrary(DLGBase);
 exit(0);
}
