#include "SysUser.h"

#include <link/io.h>

struct Global_Settings Globals;
struct Group_Def       Group;
struct USER_DATA       UserDat;
struct USER_DATA       User;
struct Ram_File        RStruct;
struct NameStruct     *users = NULL;
long                   NumUsers;

struct  SIG_Def         Sig;
USHORT  HighSearchArea;
USHORT *SearchArea;
char    areafile[80];

char   Ext[5];
char   Overlay      =  FALSE;
char   exitflag     =  FALSE;
char   MenuName[13] = "SYSU_Main";

char *deleted       =  NULL;
int   numdeleted    =   0;

/// AreaMenu Jump table
struct ShortMenu AreaMenu[7]   =
{
   {'A',"Add Area",1},
   {'R',"Remove Area",1},
   {'L',"List Areas",1},
   {'J',"Add All",1},
   {'D',"Delete All",1},
   {'Q',"Sort",1},
   {'S',"Select SIG",1}
};
//-
/// Global edit menu
struct ShortMenu GlobalMenu[5] =
{
   {'A',"All Users",1},
   {'E',"Enter Names",1},
   {'F',"From File",1},
   {'G',"From Group",1},
   {'L',"User Level",1}
};
//-
/// Main Menu
struct NewShortMenu Menu[12]   =
{
   {"Abort",1},
   {"SYSU_Add",1},
   {"SYSU_AddTmplt",1},
   {"SYSU_Delete",1},
   {"SYSU_DelTmplt",1},
   {"SYSU_Edit",1},
   {"SYSU_EditTmplt",1},
   {"SYSU_Exit",1},
   {"SYSU_GlobalTmplt",1},
   {"SYSU_List",1},
   {"SYSU_Purge",1},
   {"SYSU_Validate",1}
};
//-
/// struct data2
struct twocoldata data2[12]    = {{" 1","Alias",""},
                                  {" 2","Address",""},
                                  {" 3","Terminal",""},
                                  {" 4","City",""},
                                  {" 5","Password",""},
                                  {" 6","State/Prv",""},
                                  {"--","Joined",""},
                                  {" 7","Country",""},
                                  {"--","Lst Login",""},
                                  {" 8","Pst Cd",""},
                                  {" 9","BirthDay",""},
                                  {"10","Phone No.",""}
                                 };
//-
/// struct threecoldata
struct threecoldata data3[38]  = {{"11","Help Level",""},
                                  {"12","User Level",""},
                                  {"13","Screen Len",""},
                                  {"14","More Prmpt",""},
                                  {"15","Dly Limit",""},
                                  {"16","Scrn Width",""},
                                  {"17","Ansi Flags",""},
                                  {"18","Sesn Limit",""},
                                  {"19","Msgs Read",""},
                                  {"20","Hot Keys",""},
                                  {"21","Used Today",""},
                                  {"22","Files Upld",""},
                                  {"23","Lex Flag",""},
                                  {"24","Num Calls",""},
                                  {"25","'K' Upld",""},
                                  {"26","Pop Screen",""},
                                  {"27","Dir Limit",""},
                                  {"28","Files Dnld",""},
                                  {"29","UUCP Priv",""},
                                  {"30","Msgs Wrttn",""},
                                  {"31","'K' Dnld",""},
                                  {"32","Tm Online",""},
                                  {"33","Lst MArea",""},
                                  {"34","Sysop Pgs",""},
                                  {"35","Bltn Write",""},
                                  {"36","Lst FArea",""},
                                  {"37","U/D Ratio",""},
                                  {"38","Credit",""},
                                  {"39","Protocol",""},
                                  {"40","Capture",""},
                                  {"41","Editor",""},
                                  {"42","NetMail",""},
                                  {"43","Global Msg","..."},
                                  {"44","Global File","..."},
                                  {"45","Global Arc","..."},
                                  {"46","Archiver",""},
                                  {"47","Menu Set",""},
                                  {"48","Char Set",""}
                                 };
//-

BPTR               sout;
struct Library    *DLGBase = NULL;
struct LangStruct *ls;
char             **SA;

#include <private/Version.h>
#define  ObjRev "3"
const UBYTE version[]="\0$VER: SysUser " BUILDVER "." ObjRev " " COPYRIGHT " by Digerati Dreams "__AMIGADATE__;

/// Main
void main(int argc,char **argv)
{
   char *s;
   char *stack = NULL;

   sout = Output();
 
   if (!(DLGBase = OpenLibrary(DLGNAME, 4L)))  exit(5);

/// parse args
   while(--argc>0)
   {
      s = *++argv;
      
      if (*s++=='-')
      {
         while(*s)
         {
            switch(*s++)
            {
               case 'o':
               case 'O': Overlay=TRUE;
                         break;

               case 's':
               case 'S': if (!--argc)  break;
                         stack = *++argv;
                         break;

               case 'm':
               case 'M': if (!--argc)  break;
                         strncpy(MenuName,*++argv,12);
                         MenuName[12]='\0';
                         break;
            }
         }
      }
   }
//-

   if (GetDevName(Ext)==-1)   _CXBRK();
   if (!(ls = GetLang(Ext)))  _CXBRK();
   SA = ls->strings;

   if(! (SearchArea = calloc(100000,sizeof(long))))
      _CXBRK();

   if (!ReadUser(&RStruct,&UserDat,Ext))  _CXBRK();
   if (stack)   InsertStack(STK,stack);

   WriteLog(SYSOP_CONFIG,RStruct.Name,Ext,SA[2074]);

   if (!(NumUsers=Read_Users()))
   {
      AFPrintf(NULL,sout,SA[2075]);
      _CXBRK();
   }

/// main loop
   while(!exitflag)
   {
      Chk_Abort();

      if (MenuInput(MenuName,Ext,"SYSU",Menu,12,HandleBuiltIn,&UserDat,&RStruct,UserDat.Help_Level,NULL)==MENUNOTFOUND)
         _CXBRK();
   }
//-

   _CXBRK();
}
//-
/// _CXBRK
void _CXBRK(void)
{
   WriteRam(&RStruct, Ext);

   if(SearchArea) free(SearchArea);
   if (!Overlay)  ChainProgram("DLG:Menu", Ext);
   CloseLibrary(DLGBase);

   exit(0);
}
//-
/// GetANSI
void GetAnsi(void)
{
   char str[2];

   while(1)
   {
      if(!INSTACK)
      {
         AFPrintf(&UserDat,sout,SA[2246]);
         AFPrintf(&UserDat,sout,SA[2247], (User.Ansi_Flag & ANSI_COLOR)?SA[2248]:SA[2249]);
         AFPrintf(&UserDat,sout,SA[2250], (User.Ansi_Flag & ANSI_POS)?SA[2248]:SA[2249]);
         AFPrintf(&UserDat,sout,SA[2251], (User.Ansi_Flag & ANSI_CLR)?SA[2248]:SA[2249]);
         AFPrintf(&UserDat,sout,SA[2252], (User.Ansi_Flag & ANSI_SCROLL)?SA[2248]:SA[2249]);
      }
    
      DLGInput(NULL,str,NULL,1,1,1, SA[2253]);
      AFPrintf(NULL,sout,"\n\n");
    
      switch(str[0])
      {
         case 'S':
                  if(User.Ansi_Flag & ANSI_CLR)
                  {
                     User.Ansi_Flag = User.Ansi_Flag & (255-ANSI_CLR);
                  }
                  else
                  {
                     User.Ansi_Flag = User.Ansi_Flag | ANSI_CLR;
                  }
      
                  break;
    
         case 'C':
                  if(User.Ansi_Flag & ANSI_COLOR)
                  {
                     User.Ansi_Flag = User.Ansi_Flag & (255-ANSI_COLOR);
                  }
                  else
                  {
                     User.Ansi_Flag = User.Ansi_Flag | ANSI_COLOR;
                  }
      
                  break;
      
         case 'P':
                  if(User.Ansi_Flag & ANSI_POS)
                  {
                     User.Ansi_Flag = User.Ansi_Flag & (255-ANSI_POS);
                  }
                  else
                  {
                     User.Ansi_Flag = User.Ansi_Flag | ANSI_POS;
                  }
      
                  break;

         case 'T':
                  if(User.Ansi_Flag & ANSI_SCROLL)
                  {
                     User.Ansi_Flag = User.Ansi_Flag & (255-ANSI_SCROLL);
                  }
                  else
                  {
                     User.Ansi_Flag = User.Ansi_Flag | ANSI_SCROLL;
                  }
      
                  break;

         case 0:
                  return;
      }
   }
}
//-
