#include <exec/types.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>

#include <dlg/dlg.h>
#include <dlg/user.h>
#include <dlg/menu.h>
#include <dlg/resman.h>
#include <dlg/log.h>

#include <link/io.h>

#include <proto/dos.h>
#include <proto/exec.h>
#include <proto/dlg.h>


#define  FILE_AREA_TYPE 1

#include <pragmas/dlg.h>

#include <private/Version.h>
#define  ObjRev "1"
const UBYTE version[]="\0$VER: AreaTemplate " BUILDVER "." ObjRev " " COPYRIGHT " by Digerati Dreams "__AMIGADATE__;

void  main(int , char **);
int   HandleBuiltIn(UBYTE );
void _CXBRK(void);

extern   BYTE  Add_Template(void);
extern   void  List_Templates(void);
extern   void  Delete_Template(void);
extern   void  Copy_Template( BOOL );
extern   void  Edit_Template(void);

BOOL              Overlay  =  FALSE;
char              Ext[4];
int               AreaType =  0;
struct USER_DATA  UserDat;
struct Ram_File   RStruct;

/// Menu definition
struct NewShortMenu Menu[8]={{"Abort",1},
                             {"ATemp_Copy",1},
                             {"ATemp_Delete",1},
                             {"ATemp_Edit",1},
                             {"ATemp_Exit",1},
                             {"ATemp_List",1},
                             {"ATemp_New",1},
                             {"ATemp_Rename",1},
                            };
//-

char  exitflag     =  FALSE;
char  MenuName[13] = "ATemp_Main";

BPTR               sout;
struct Library    *DLGBase = NULL;
struct LangStruct *ls;
char             **SA;

///   Startup, initialize, loop until exit
void main(int argc, char *argv[])
{
   char *s;
   char *stack = NULL;

   sout = Output();

   if (!(DLGBase = OpenLibrary(DLGNAME, DLGVERSION)))  exit(5);

///   parse args
 while(--argc>0)
      {s=*++argv;
       if (*s++=='-')
          {while(*s)
                {switch(*s++)
                       {
                        case 'S':
                        case 's':  if (!--argc)  break;
                                   stack = *++argv;
                                   break;

                        case 'M':
                        case 'm':  if (!--argc)  break;
                                   strncpy(MenuName, *++argv, 12);
                                   MenuName[12]='\0';
                                   break;

                        case 'F':
                        case 'f':  AreaType = FILE_AREA_TYPE; break;

                        case  'O':
                        case  'o':  Overlay = TRUE;
                                    break;


                       }
                }
          }
      }
//-

   if (GetDevName(Ext) == -1)  _CXBRK();
   if (!(ls = GetLang(Ext)))   _CXBRK();
   SA = ls->strings;

   if (!ReadUser(&RStruct,&UserDat,Ext)) _CXBRK();
//   if (stack)                            InsertStack(STK, stack);

   WriteLog(SYSOP_CONFIG, RStruct.Name,Ext, "Area Templates");

   while(!exitflag)
   {
      Chk_Abort();

      if ( MenuInput(MenuName,Ext,"ATemp",Menu,8,HandleBuiltIn,&UserDat,&RStruct,UserDat.Help_Level,NULL) == MENUNOTFOUND)
          _CXBRK();
   }

 _CXBRK();
}
//-
///   HandleBuiltIn -- Event handler
int HandleBuiltIn(UBYTE cmd)
{
   switch(cmd)
   {
      case 0:  exitflag = TRUE;     break;   // Abort
      case 1:  Copy_Template(1);    break;   // Copy
      case 2:  Delete_Template();   break;   // Delete
      case 3:  Edit_Template();     break;   // Edit
      case 4: _CXBRK();             break;   // Exit
      case 5:  List_Templates();    break;   // List
      case 6:  Add_Template();      break;   // New
      case 7:  Copy_Template(0);    break;   // Rename

      default: return(FALSE);
   }

   return(TRUE);
}  
//-

///   _CXBRK
void _CXBRK(void)
{
   WriteRam(&RStruct, Ext);

   if (!Overlay)  ChainProgram("DLG:Menu", Ext);

   CloseLibrary(DLGBase);
   exit(0);
}
//-
