#include <exec/types.h>
#include <stdlib.h>
#include <string.h>

#include <dlg/msg.h>
#include <dlg/User.h>
#include <dlg/misc.h>
#include <dlg/file.h>

#include <link/io.h>
#include <link/config.h>
#include <link/user.h>

#include <proto/dlg.h>
#include <proto/dos.h>

#include <pragmas/dlg.h>

extern   BPTR                 sout;

extern   int                  AreaType;

extern   struct   Library    *DLGBase;
extern   struct   USER_DATA   UserDat;
extern   struct   Ram_File    RStruct;
extern   char                 Ext[];

extern   int   Create_Array(char **);
extern   void  List_Templates(void);
extern   void  Set_Auto_Access(struct Msg_Area *);
extern   void  Set_Write_Access(struct Msg_Area *);
extern   void  Set_Kill_Access(struct Msg_Area *);
extern   void  Set_Forward_Access(struct Msg_Area *);
extern   void  Set_Copy_Access(struct Msg_Area *);
extern   void  Set_Edit_Access(struct Msg_Area *);
extern   void  Set_Sysop_Access(struct Msg_Area *);
extern   BOOL  Save_Area(struct Msg_Area *, LONG);
extern   BOOL  IsAreaValid( SHORT );
extern   void  New_Area(struct Msg_Area *ma);

void Show_Area(struct Msg_Area *ma);
void Get_Charset_Name(char Set, char *Name);

void Change_Auto_Access(struct Msg_Area *);
BOOL Change_Echo_Area_Flag(struct Msg_Area *);
void Change_SeenBy_Flag(struct Msg_Area *);
BOOL Change_Origin(struct Msg_Area *);
BOOL Change_Netmail_Area_Flag(struct Msg_Area *);
BOOL Change_Newsgroup_Flag(struct Msg_Area *);
void Change_Alias_Flag(struct Msg_Area *);
void Change_Signature_Flag(struct Msg_Area *);
BOOL Change_Translator(struct Msg_Area *);
BOOL Change_Capacity(struct Msg_Area *);
BOOL Change_Renumber(struct Msg_Area *);
BOOL Change_Charset(struct Msg_Area *);
void Change_Freq_Area_Flag(struct Msg_Area *);
void Change_Temp_Download_Flag(struct Msg_Area *);
void Change_Validation_Flag(struct Msg_Area *);
BOOL Change_Path(struct Msg_Area *, BOOL );

void Edit_TextFile(struct Msg_Area *, char *);
void Delete_TextFile(struct Msg_Area *ma, char *FileName);
void Apply_Template(struct Msg_Area *ma);

void Replace_Area(struct Msg_Area *ma);
void _Replace_Area(char *filename, struct Msg_Area *ma);

/// Edit_Area
void  Edit_Area(struct Msg_Area *ma)
{
   BOOL              Changed  =  FALSE;
   BOOL              From_Add =  TRUE;
   LONG              AreaNum  =  0;
   LONG              action;

   if(!ma)
   {
      From_Add =  FALSE;

      ma = calloc(1,sizeof(struct Msg_Area));

      if(!ma) return;
   }


   if(!From_Add)
   {
/// Get area to edit
      AreaNum = iinput(1,9999,0, "Edit which area? %a7-> ");
      TwoLines();

      if(0 == AreaNum)
      {
         ListAreas(NULL,&UserDat,AreaType,0);
         AreaNum = iinput(1,9999,0, "Edit which area? %a7-> ");
         TwoLines();
      }

      if(0 == AreaNum)
      {
         AFPrintf(&UserDat,sout,"Aborted ...\n\n");

         if(ma && !From_Add)
         {
            free(ma);
            ma = NULL;
         }

         return;
      }
//-
/// Check if area exists
      if(!ReadArea(AreaNum,ma,AreaType))
      {
         AFPrintf(&UserDat,sout, "%a3Area not found!\n\n%a7Aborted ...\n\n");

         if(ma && !From_Add)
         {
            free(ma);
            ma = NULL;
         }

         return;
      }
//-
   }

   Show_Area(ma);

   while(action = iinput(1,33,0, "Select an item to edit (RETURN to exit and save) %a7-> "))
   {
      OneLine();

      switch(action)
      {
         case  1:  Changed = FALSE; AFPrintf(NULL,sout,"Change name\n"); Pause();      break;
         case  2:  Changed = TRUE; Change_Auto_Access(ma);                   break;
         case  3:  Changed = TRUE; OneLine(); Set_Auto_Access(ma);           break;
//         case  3:  Changed = TRUE; OneLine(); Set_Write_Access(ma);          break;
//         case  4:  Changed = TRUE; OneLine(); Set_Kill_Access(ma);           break;
//         case  5:  Changed = TRUE; OneLine(); Set_Forward_Access(ma);        break;
//         case  6:  Changed = TRUE; OneLine(); Set_Copy_Access(ma);           break;
//         case  7:  Changed = TRUE; OneLine(); Set_Edit_Access(ma);           break;
//         case  8:  Changed = TRUE; OneLine(); Set_Sysop_Access(ma);          break;
         case  9:  OneLine(); Changed |= Change_Echo_Area_Flag(ma);          break;
         case 10:  Changed = TRUE; OneLine(); Change_SeenBy_Flag(ma);        break;
         case 11:  OneLine(); Changed |= Change_Origin(ma);                  break;
         case 12:  OneLine(); Changed |= Change_Netmail_Area_Flag(ma);       break;
         case 13:  OneLine(); Changed |= Change_Newsgroup_Flag(ma);          break;
         case 15:  Changed = TRUE; OneLine(); Change_Alias_Flag(ma);         break;
         case 16:  Changed = TRUE; OneLine(); Change_Signature_Flag(ma);     break;
         case 17:  OneLine(); Changed |= Change_Translator(ma);              break;
         case 18:  OneLine(); Changed = TRUE; Change_Freq_Area_Flag(ma);     break;
         case 19:  OneLine(); Changed = TRUE; Change_Temp_Download_Flag(ma); break;
         case 20:  OneLine(); Changed = TRUE; Change_Validation_Flag(ma);    break;
         case 21:  OneLine(); Changed |= Change_Capacity(ma);                break;
         case 22:  OneLine(); Changed |= Change_Renumber(ma);                break;
         case 23:  OneLine(); Changed |= Change_Charset(ma);                 break;
         case 24:  OneLine(); Changed |= Change_Path(ma, FALSE );            break;
         case 25:  OneLine(); Edit_TextFile(ma, "EnterArea.txt");            break;
         case 26:  OneLine(); Delete_TextFile(ma, "EnterArea.txt");          break;
         case 27:  OneLine(); Edit_TextFile(ma, "Echo.txt");                 break;
         case 28:  OneLine(); Delete_TextFile(ma, "Echo.txt");               break;
         case 29:  OneLine(); Edit_TextFile(ma, "UploadFile.txt");           break;
         case 30:  OneLine(); Delete_TextFile(ma, "UploadFile.txt");         break;
         case 31:  OneLine(); Edit_TextFile(ma, "Screen.dat");               break;
         case 32:  OneLine(); Delete_TextFile(ma, "Screen.dat");             break;
         case 33:  OneLine(); Changed = TRUE; Apply_Template(ma);            break;
      }

      Show_Area(ma);
   }

   TwoLines();

   if(Changed || From_Add)
   {
      if (1 == finput(1, "%a6Save changes? "))
      {
         if(AreaType == 0)
         {
            if(ma->Flag & NEWSGROUP_AREA)
            {
               while(!strlen(ma->origin))
               {
                  TwoLines();
                  action = DLGInput(NULL,ma->origin,NULL,74,74,0,"%a1You MUST enter a newsgroup name! %a3->");
                  OneLine();

                  if(!action)
                  {
                     AFPrintf(&UserDat, sout, "%a7Aborted...\n\n");
                     return;
                  }
               }
            }
         }

         TwoLines();
         AFPrintf(&UserDat,sout,"Saving ...\n");

         if(From_Add)
            New_Area(ma);
         else
            Replace_Area(ma);

         OneLine();
      }
      else
         TwoLines();
   }
   else
   {
      AFPrintf(&UserDat,sout,"No changes to area file.\n\n");
   }


   if(ma && !From_Add)
   {
      free(ma);
      ma = NULL;
   }

   return;
}
//-

/// Show_Area
void Show_Area(struct Msg_Area *ma)
{
   char charset[13];

   Clr(UserDat.Ansi_Flag);

   AFPrintf(&UserDat,sout, "%a6%s Area %a5[%a7%ld%a5] %a3%s%a7\n",(AreaType ? "File" : "Message"),ma->Number, ma->Name);
   Draw_Line(UserDat.Screen_Width);

   AFPrintf(&UserDat,sout, "%a5[ %a61%a5]            %a7Area Name: %a3%s\n", ma->Name);
   AFPrintf(&UserDat,sout, "%a5[ %a62%a5]          %a7Auto Access: %a3%s\n", ((ma->Flag & AUTO_ACCESS_AREA) ? "Yes" : "No"));

   if(ma->Flag & AUTO_ACCESS_AREA)
   AFPrintf(&UserDat,sout, "%a5[ %a63%a5]   %a7Auto Access Levels: %a6Lower: %a3%ld  %a6Upper: %a3%ld\n",ma->llevel, ma->ulevel);

   AFPrintf(&UserDat,sout, "%a5[ %a64%a5]  %a7Other Access Levels ...\n");

/*
   AFPrintf(&UserDat,sout, "%a5[ %a63%a5]%a7%14.14s Access: %a6Lower: %a3%3ld  %a6Upper: %a3%3ld\n",(AreaType ? "Upload" : "Write"),ma->lwrite, ma->uwrite);

   AFPrintf(&UserDat,sout, "%a5[ %a64%a5]          %a7Kill Access: %a6Lower: %a3%3ld  %a6Upper: %a3%3ld\n",ma->lkill, ma->ukill);
   AFPrintf(&UserDat,sout, "%a5[ %a65%a5]%a7%14.14s Access: %a6Lower: %a3%3ld  %a6Upper: %a3%3ld\n",(AreaType ? "Download" : "Forward"), ma->lforward, ma->uforward);
   AFPrintf(&UserDat,sout, "%a5[ %a66%a5]%a7%14.14s Access: %a6Lower: %a3%3ld  %a6Upper: %a3%3ld\n",(AreaType ? "Transfer" : "Copy/Move"),ma->lcopy, ma->ucopy);

   if(AreaType == 0)
      AFPrintf(&UserDat,sout, "%a5[ %a67%a5]          %a7Edit Access: %a6Lower: %a3%3ld  %a6Upper: %a3%3ld\n",ma->ledit, ma->uedit);

   AFPrintf(&UserDat,sout, "%a5[ %a68%a5]         %a7Sysop Access: %a6Lower: %a3%3ld  %a6Upper: %a3%3ld\n",ma->lsysop, ma->usysop);
*/
   OneLine();

/// msg only -- echo area, newsgroup, netmail.
   if(AreaType == 0)
   {
      AFPrintf(&UserDat,sout, "%a5[ %a69%a5]            %a7Echo Area: %a3%s\n", ((ma->Flag & ECHO_AREA) ? "Yes" : "No"));

      if(ma->Flag & ECHO_AREA)
      {
         AFPrintf(&UserDat,sout, "%a5[%a610%a5]       %a7Hide Seen-By's: %a3%s\n", ((ma->Flag & HIDE_SEENBY) ? "Yes" : "No"));
         AFPrintf(&UserDat,sout, "%a5[%a611%a5]          %a7Origin Line: %a3%s\n", ((strlen(ma->origin) > 0) ? ma->origin : "DEFAULT"));
      }

      AFPrintf(&UserDat,sout, "%a5[%a612%a5]         %a7Netmail Area: %a3%s\n", ((ma->Flag & NETMAIL_AREA) ? "Yes" : "No"));

      AFPrintf(&UserDat,sout, "%a5[%a613%a5]            %a7Newsgroup: %a3%s\n", ((ma->Flag & NEWSGROUP_AREA) ? "Yes" : "No"));

      if(ma->Flag & NEWSGROUP_AREA)
         if(strlen(ma->origin))
            AFPrintf(&UserDat,sout, "%a5[%a614%a5]       %a7Newsgroup Name: %a3%s\n", ma->origin);
         else
            AFPrintf(&UserDat,sout, "%a5[%a614%a5]       %a7Newsgroup Name: %a1NONE SELECTED\n");

      OneLine();
   }
//-

   AFPrintf(&UserDat,sout, "%a5[%a615%a5]          %a7Use handles: %a3%s\n", ((ma->Flag & HANDLES_AREA) ? "Yes" : "No"));
   AFPrintf(&UserDat,sout, "%a5[%a616%a5]       %a7Use signatures: %a3%s\n", ((ma->Flag & SIGNATURE_AREA) ? "Yes" : "No"));

   if(AreaType == 0)
      AFPrintf(&UserDat,sout, "%a5[%a617%a5]           %a7Translator: %a3%s%s\n", ((strlen(ma->processor) > 0) ? "DLGConfig:Batch/" : ""),
                                                                                  ((strlen(ma->processor) > 0) ? ma->processor : "NONE") );
/// File only -- validation, freq, and temp-download
   if(AreaType)
   {
      OneLine();
      AFPrintf(&UserDat,sout, "%a5[%a618%a5]     %a7File Requestable: %a3%s\n", ((ma->Flag & FREQ_AREA) ? "Yes" : "No"));
      AFPrintf(&UserDat,sout, "%a5[%a619%a5] %a7Copy before Download: %a3%s\n", ((ma->Flag & TEMP_DOWNLOAD) ? "Yes" : "No"));
      AFPrintf(&UserDat,sout, "%a5[%a620%a5]     %a7Validate Uploads: %a3%s\n", ((ma->Flag & VALIDATION_AREA) ? "Yes" : "No"));
   }
//-

   if((AreaType == 0) || (ma->Flag & VALIDATION_AREA))
      if(ma->Capacity)
         AFPrintf(&UserDat,sout, "%a5[%a621%a5]%a7%21.21s: %a3%ld\n", (AreaType ? "Validation Area" : "Message Capacity"),ma->Capacity);
      else
         AFPrintf(&UserDat,sout, "%a5[%a621%a5]%a7%21.21s: %a3NONE\n", "Validation Area");

   if(AreaType == 0)
   {
      AFPrintf(&UserDat,sout, "%a5[%a622%a5]     %a7Renumber Trigger: %a3%ld\n", ma->UpperLimit);

      Get_Charset_Name(ma->savecharset,charset);
      AFPrintf(&UserDat,sout, "%a5[%a623%a5]%a7        Character Set: %a5(%a6%ld%a5) %a3%s\n", ma->savecharset,charset);
   }

   if(AreaType == 1)
   {
      if(strlen(ma->path))
         AFPrintf(&UserDat,sout, "%a5[%a624%a5]%a7        Alt File Path: %a3%s\n", ma->path);
      else
         AFPrintf(&UserDat,sout, "%a5[%a624%a5]%a7        Alt File Path: %a3NONE SELECTED\n");
   }

//   AFPrintf(&UserDat,sout, "%a7\n");
//   Draw_Line(UserDat.Screen_Width);
/*
   AFPrintf(&UserDat,sout, "%a5[%a625%a5]%a3  Edit %a7EnterArea.txt  ");
   AFPrintf(&UserDat,sout, "%a5[%a626%a5]%a3  Delete %a7EnterArea.txt\n");

   if(AreaType == 0)
   {
      if(ma->Flag & ECHO_AREA)
      {
         AFPrintf(&UserDat,sout, "%a5[%a627%a5]%a3  Edit %a7Echo.txt       ");
         AFPrintf(&UserDat,sout, "%a5[%a628%a5]%a3  Delete %a7Echo.txt\n");
      }
   }
   else
   {
      AFPrintf(&UserDat,sout, "%a5[%a620%a5]%a3  Edit %a7UploadFile.txt ");
      AFPrintf(&UserDat,sout, "%a5[%a630%a5]%a3  Delete %a7UploadFile.txt\n");
   }

   if(AreaType == 0)
   {
      AFPrintf(&UserDat,sout, "%a5[%a631"  "%a5]%a3  Edit %a7Screen.dat     ");
      AFPrintf(&UserDat,sout, "%a5[%a632"  "%a5]%a3  Delete %a7Screen.dat\n");
   }
*/
   AFPrintf(&UserDat,sout,"\n%a5[%a633%a5]%a3  Apply Template ...");
   AFPrintf(&UserDat,sout,"   %a5[%a634"  "%a5]%a3  Edit Text Files ...\n");
//   Draw_Line(UserDat.Screen_Width);
   OneLine();
}
//-
/// Get_Charset_Name
void Get_Charset_Name(char Set, char *Name)
{
   struct CharSet cs;

   if(AreaType) return;

   if(Set == 0)
   {
      strcpy(Name,"Default");
      return;
   }

   cs.number = Set;

   if(0 == GetStruct("DLGConfig:Charsets/Charsets.BBS",(char *)&cs,sizeof(struct CharSet),1))
      strcpy(Name,cs.name);
   else
      strcpy(Name,cs.name);

   return;
}
//-

/// Change_Auto_Access
void Change_Auto_Access(struct Msg_Area *ma)
{
   BOOL  b;

   b = ma->Flag & AUTO_ACCESS_AREA;

   if(b)
      ma->Flag = ma->Flag & ~AUTO_ACCESS_AREA;
   else
      ma->Flag = ma->Flag | AUTO_ACCESS_AREA;

   if(!b)
   {
      TwoLines();
      Set_Auto_Access(ma);
      b = finput(1, "%a3Add to users' auto-access lists? %a7-> ");
      TwoLines();
      if (b)  AddGlobalArea(ma->ulevel,ma->llevel,ma->Number,AreaType,0,Ext);
      TwoLines();
   }
   else
   {
      ma->llevel = 1;
      ma->ulevel = 1;

      b = finput(1, "%a3Remove from users' auto-access lists? %a7-> ");
      TwoLines();
      if (b)  AddGlobalArea(ma->ulevel,ma->llevel,ma->Number,AreaType,1,Ext);
      TwoLines();
   }
}
//-
/// Change_Echo_Area_Flag
BOOL Change_Echo_Area_Flag(struct Msg_Area *ma)
{
   BOOL  e;
   BOOL  n;
   BOOL  u;
   BOOL  b;

   if (AreaType) return( FALSE );

   e = ma->Flag & ECHO_AREA;
   n = ma->Flag & NETMAIL_AREA;
   u = ma->Flag & NEWSGROUP_AREA;

///   Trap netmail area
   if(n)
   {
      AFPrintf(&UserDat,sout, "%a3\nThis area is already set up as a netmail area!\n\n");
      b = finput(0, "Do you really wish to change this to an echo area? %a7->");

      if(b == 0) return( FALSE );
   }
//-
///   Trap newsgroup
   if(u)
   {
      AFPrintf(&UserDat,sout, "%a3\nThis area is already set up as a newsgroup!\n\n");
      b = finput(0, "Do you really wish to change this to an echo area? %a7->");

      if(b == 0) return( FALSE );
   }
//-

   if(e)
      ma->Flag = ma->Flag & ~ECHO_AREA;
   else
      ma->Flag = ma->Flag | ECHO_AREA;

   strcpy(ma->origin,"");

   ma->Flag = ma->Flag & ~NETMAIL_AREA;
   ma->Flag = ma->Flag & ~NEWSGROUP_AREA;

   OneLine();
   Change_Origin(ma);

   return( TRUE );
}
//-
/// Change_SeenBy_Flag
void Change_SeenBy_Flag(struct Msg_Area *ma)
{
   if(AreaType) return;

   if(ma->Flag & HIDE_SEENBY)
      ma->Flag = ma->Flag & ~HIDE_SEENBY;
   else
      ma->Flag = ma->Flag | HIDE_SEENBY;

   return;
}
//-
/// Change_Origin
BOOL Change_Origin(struct Msg_Area *ma)
{
   BOOL  e;
   BOOL  u;
   BOOL  b;

   char  s[74];

   long  l;

   if(AreaType) return( FALSE );

   e = ma->Flag & ECHO_AREA;
   u = ma->Flag & NEWSGROUP_AREA;

   if(e && !u)
   {
      long d;

      d = strlen(ma->origin);

      if(d)
         strcpy(s,ma->origin);
      else
         strcpy(s,"");

      l = DLGInput(NULL,ma->origin,ma->origin,74,74,0, "Custom Origin line (return for default) -> ");
      OneLine();

      if(l == 0)
      {
         strcpy(ma->origin,"");

         if(d == 0)
            b = FALSE;
         else
            b = TRUE;
      }
      else
      {
         if(!Stricmp(s,ma->origin))
            b = FALSE;
         else
            b = TRUE;
      }

      return( b );
   }

   strcpy(ma->origin,"");

   return( FALSE );
}
//-
/// Change_Netmail_Area_Flag
BOOL Change_Netmail_Area_Flag(struct Msg_Area *ma)
{
   BOOL  e;
   BOOL  n;
   BOOL  u;
   BOOL  b;

   if(AreaType) return( FALSE );

   e = ma->Flag & ECHO_AREA;
   n = ma->Flag & NETMAIL_AREA;
   u = ma->Flag & NEWSGROUP_AREA;

///   Trap echo area
   if(e)
   {
      AFPrintf(&UserDat,sout, "%a3\nThis area is already set up as am echo area!\n\n");
      b = finput(0, "Do you really wish to change this to a netmail area? %a7->");

      if(b == 0) return( FALSE );
   }
//-
///   Trap newsgroup
   if(u)
   {
      AFPrintf(&UserDat,sout, "%a3\nThis area is already set up as a newsgroup!\n\n");
      b = finput(0, "Do you really wish to change this to a netmail area? %a7->");

      if(b == 0) return( FALSE );
   }
//-

   if(n)
      ma->Flag = ma->Flag & ~NETMAIL_AREA;
   else
      ma->Flag = ma->Flag | NETMAIL_AREA;

   strcpy(ma->origin,"");

   ma->Flag = ma->Flag & ~ECHO_AREA;
   ma->Flag = ma->Flag & ~NEWSGROUP_AREA;

   return( TRUE );
}
//-
/// Change_Newsgroup_Flag
BOOL Change_Newsgroup_Flag(struct Msg_Area *ma)
{
   BOOL  e;
   BOOL  n;
   BOOL  u;
   BOOL  b;

   if(AreaType) return( FALSE );

   e = ma->Flag & ECHO_AREA;
   n = ma->Flag & NETMAIL_AREA;
   u = ma->Flag & NEWSGROUP_AREA;

///   Trap echo area
   if(e)
   {
      AFPrintf(&UserDat,sout, "%a3\nThis area is already set up as am echo area!\n\n");
      b = finput(0, "Do you really wish to change this to a newsgroup? ->");

      if(b == 0) return( FALSE );
   }
//-
///   Trap netmail area
   if(n)
   {
      AFPrintf(&UserDat,sout, "%a3\nThis area is already set up as a netmail area!\n\n");
      b = finput(0, "Do you really wish to change this to a newsgroup? %a7->");

      if(b == 0) return( FALSE );
   }
//-

   if(u)
      ma->Flag = ma->Flag & ~NEWSGROUP_AREA;
   else
      ma->Flag = ma->Flag | NEWSGROUP_AREA;

   strcpy(ma->origin,"");

   ma->Flag = ma->Flag & ~ECHO_AREA;
   ma->Flag = ma->Flag & ~NETMAIL_AREA;

   OneLine();
   Change_Origin(ma);

   return( TRUE );
}
//-
/// Change_Alias_Flag
void Change_Alias_Flag(struct Msg_Area *ma)
{
   if(ma->Flag & HANDLES_AREA)
      ma->Flag = ma->Flag & ~HANDLES_AREA;
   else
      ma->Flag = ma->Flag | HANDLES_AREA;

   return;
}
//-
/// Change_Signature_Flag
void Change_Signature_Flag(struct Msg_Area *ma)
{
   if(ma->Flag & SIGNATURE_AREA)
      ma->Flag = ma->Flag & ~SIGNATURE_AREA;
   else
      ma->Flag = ma->Flag | SIGNATURE_AREA;

   return;
}
//-
/// Change_Translator
BOOL Change_Translator(struct Msg_Area *ma)
{
   char  s[12];

   long  l;
   long  d;

   if(AreaType) return( FALSE );

   d = strlen(ma->processor);

   if(d)
      strcpy(s,ma->processor);
   else
      strcpy(s,"");

   l = DLGInput(NULL, ma->processor, ma->processor,12,12,0, "Message translator: DLGConfig:Batch/");
   OneLine();

   if(l == 0)
   {
      strcpy(ma->processor,"");

      if(d == 0)
         return( FALSE );
      else
         return( TRUE );
   }
   else
   {
      if(!Stricmp(ma->processor,s))
         return( FALSE );
      else
         return( TRUE );
   }

   strcpy(ma->processor,"");
   return( FALSE );
}
//-
/// Change_Capacity
BOOL Change_Capacity(struct Msg_Area *ma)
{
   BOOL  b = FALSE;
   BOOL  o = FALSE;

   SHORT d;
   SHORT s  =  ma->Capacity;

   if(AreaType == 0)
   {
      if(ma->Capacity > 10)
         d = ma->Capacity;
      else
         d = 100;

   }
   else
   {
      d = ma->Capacity;

      if((d >= 1) && (d <= 9999))
         d = ma->Capacity;
      else
         d = 0;

   }


   if(AreaType == 0)
   {
      ma->Capacity = iinput(10, 9000 ,d, "How many messages do you wish to store in this area? %a7-> ");
   }
   else
   {
      while(!o)
      {
         ma->Capacity   = iinput(0,9999,0, "Which file area will hold unvalidated files for this area? %a7-> ");
         OneLine();

         if(ma->Capacity != 0)
            o = IsAreaValid(ma->Capacity);
         else
            o = TRUE;
      }
   }

   OneLine();

   if(ma->Capacity == s)
      b = FALSE;
   else
      b = TRUE;

   if(AreaType == 0)
   {
      if(ma->Capacity > ma->UpperLimit)
      {
         ma->UpperLimit = ma->Capacity * 2;

         if(ma->UpperLimit > 9000) ma->UpperLimit = 9999;
         b = TRUE;
      }
   }

   return(b);
}
//-
/// Change_Renumber
BOOL Change_Renumber(struct Msg_Area *ma)
{
   SHORT d;
   SHORT s  =  ma->UpperLimit;

   if(AreaType) return( FALSE );

   if(ma->UpperLimit > ma->Capacity)
      d = ma->UpperLimit;
   else
      d = ma->Capacity + 1;

   ma->UpperLimit   = iinput((ma->Capacity + 1),9999,d, "How many messages do you wish to trigger re-numbering? %a7-> ");
   OneLine();

   if(ma->UpperLimit == s)
      return( FALSE );
   else
      return( TRUE );
}
//-
/// Change_Charset
BOOL Change_Charset(struct Msg_Area *ma)
{
   SHORT s  =  ma->savecharset;

   if(AreaType) return ( FALSE );

   ListSets(255);
   ma->savecharset = iinput(1,255,s, "Character set to store messages in (RETURN for default) %a7-> ");
   OneLine();

   if(ma->savecharset == s)
      return( FALSE );
   else
      return( TRUE );
}
//-
/// Change_Freq_Area_Flag
void Change_Freq_Area_Flag(struct Msg_Area *ma)
{
   if(AreaType == 0) return;

   if(ma->Flag & FREQ_AREA)
      ma->Flag = ma->Flag & ~FREQ_AREA;
   else
      ma->Flag = ma->Flag | FREQ_AREA;

   return;
}
//-
/// Change_Temp_Download_Flag
void Change_Temp_Download_Flag(struct Msg_Area *ma)
{
   if(AreaType == 0) return;

   if(ma->Flag & TEMP_DOWNLOAD)
      ma->Flag = ma->Flag & ~TEMP_DOWNLOAD;
   else
      ma->Flag = ma->Flag | TEMP_DOWNLOAD;

   return;
}
//-
/// Change_Validation_Flag
void Change_Validation_Flag(struct Msg_Area *ma)
{
   BOOL  b;

   if(AreaType == 0) return;

   b = (ma->Flag & VALIDATION_AREA);

   if(b)
      ma->Flag = ma->Flag & ~VALIDATION_AREA;
   else
      ma->Flag = ma->Flag | VALIDATION_AREA;

   ma->Capacity = 0;

   if(!b) Change_Capacity(ma);

   return;
}
//-
/// Change_Path
BOOL Change_Path(struct Msg_Area *ma, BOOL rename)
{
   BPTR  lock  =  NULL;

   char  s[20];
   char  t[20];

   long  l;
   long  d;

   if(AreaType == 0) return( FALSE );

   d = strlen(ma->path);

   if(d)
      strcpy(s,ma->path);
   else
      strcpy(s,"");

   strcpy(t,s);

   l = DLGInput(NULL, ma->path, ma->path,18,18, 0, "%a3Alternate File Path %a7-> ");
   OneLine();

   if(l == 0)
   {
      strcpy(ma->path,"");

      if(d == 0)
         return( FALSE );
      else
         return( TRUE );
   }
   else
   {
      if(!Stricmp(s,ma->path))
         return( FALSE );
   }


   if (ma->path[l-1] != ':'  &&  ma->path[l-1] != '/')
   {
      ma->path[l] = '/';
      l++;
      ma->path[l] =  0;
   }

   strcpy(s, ma->path);

   if (s[l-1] == '/')  s[l-1] = 0;

   if(!rename)
   {
      if (!Exists(s))
      {
         if (!(lock = CreateDir(s)))
         {
            AFPrintf(&UserDat,sout, "%a1\nChange_Path(): ERROR - %a3Could not create directory %a6%s\n\n",s);
            strcpy(ma->path,"");
            Pause();
            return( TRUE );
         }

         UnLock(lock);
      }
   }

   return( TRUE );
}
//-

/// Replace_Area
void Replace_Area(struct Msg_Area *ma)
{
   BPTR           fh;
   struct SIG_Def Sig;
   char           filename[128];


   ASPrintf(NULL,filename,"%s:Area.BBS",(AreaType ? "File" : "Msg"));

   _Replace_Area(filename, ma);

   ASPrintf(NULL,filename,"DLGConfig:Sigs/Sigs.%s",(AreaType ? "file" : "msg"));

   if ((fh = Open(filename,MODE_OLDFILE)) == NULL )
   {
      AFPrintf(&UserDat,sout, "%a6No SIGs found.\n");
      return;
   }

   while(Read(fh, &Sig, sizeof(struct SIG_Def)) == sizeof(struct SIG_Def))
   {
      ASPrintf(NULL,filename,"DLGCONFIG:Sigs/%s.%s",Sig.name, (AreaType ? "file" : "msg"));
      _Replace_Area(filename, ma);
   }

   AFPrintf(&UserDat,sout,"\n");
   if(fh)   Close(fh);  fh = NULL;
   return;
}
//-
/// _Replace_Area
void _Replace_Area(char *filename, struct Msg_Area *ma)
{
   BPTR     fh;
   struct   Msg_Area temparea;

   AFPrintf(&UserDat,sout, "%a6\tUpdating %a5[%a3%s%a5] %a7... ",filename);

   fh = Open(filename,MODE_READWRITE);

   if (fh == NULL)  return;

   while(Read(fh, &temparea, sizeof(struct Msg_Area)) == sizeof(struct Msg_Area))
   {
      if (temparea.Number == ma->Number)
      {
         Seek(fh, 0 - (sizeof(struct Msg_Area)), OFFSET_CURRENT);
         Write(fh, ma, sizeof(struct Msg_Area));
         AFPrintf(&UserDat,sout, "%a3done\n");
         if(fh)   Close(fh); fh = NULL;
         return;
      }
   }

   if(fh)   Close(fh); fh = NULL;

   // "unchanged"
   AFPrintf(&UserDat,sout, "%a4unchanged\n");
   return;
}
//-

/// Edit_TextFile
void Edit_TextFile(struct Msg_Area *ma, char *FileName)
{
   BOOL  FilterFile  =  FALSE;

   char  PathAndFile[256];

   if(!Stricmp(FileName,"Echo.txt") && AreaType) return;
   if(!Stricmp(FileName,"UploadFile.txt") && !AreaType) return;

   if(!Stricmp(FileName,"Screen.Dat"))
   {
      if(AreaType) return;

      FilterFile = TRUE;
   }

   if(!FilterFile)
      ASPrintf(NULL,PathAndFile,"%s:%ld/%s",(AreaType ? "File" : "Msg"),ma->Number,FileName);
   else
      ASPrintf(NULL,PathAndFile,"%s:%ld/Screen.%s",(AreaType ? "File" : "Msg"),ma->Number,(AreaType ? "file" : "msg"));

   CallEditor(NULL,NULL,PathAndFile,TEXT,&UserDat,&RStruct,Ext);

   Spawn(NULL, NULL, "DLG:CRtoLF %s", PathAndFile);

   if(FilterFile)
   {
      char  t[256];

      ASPrintf(NULL, t,"%s:%ld",(AreaType ? "File" : "Msg"),ma->Number);

      if(CD(t))  Spawn(NULL, NULL, "DLG:CompileScreen");
   }

   return;
}
//-
/// Delete_TextFile
void Delete_TextFile(struct Msg_Area *ma, char *FileName)
{
   BOOL  FilterFile  =  FALSE;

   char  PathAndFile[256];

   if(!Stricmp(FileName,"Echo.txt") && AreaType) return;
   if(!Stricmp(FileName,"UploadFile.txt") && !AreaType) return;

   if(!Stricmp(FileName,"Screen.Dat"))
   {
      if(AreaType) return;

      FilterFile = TRUE;
   }


   if (0 == finput(0, "%a6Really delete %a3%s%a6? ",FileName))
   {
      AFPrintf(&UserDat,sout, "%a5\nAborting...\n\n");
      return;
   }

   if(!FilterFile)
   {
      ASPrintf(NULL,PathAndFile,"%s:%ld/%s",(AreaType ? "File" : "Msg"),ma->Number,FileName);
      DeleteFile(PathAndFile);
   }
   else
   {
      ASPrintf(NULL,PathAndFile,"Msg:%ld/Screen.dat",ma->Number);
      DeleteFile(PathAndFile);

      ASPrintf(NULL,PathAndFile,"Msg:%ld/Screen.msg",ma->Number);
      DeleteFile(PathAndFile);
   }

   return;
}
//-
/// Apply_Template
void Apply_Template(struct Msg_Area *ma)
{
   BPTR                       fh       =  FALSE;

   char                      *Array    =  NULL;
   char                       TemplateName[36];
   char                       t[256];

   int                        Entries;

   struct   Msg_Area_Template plate;


   Entries = Create_Array(&Array);
   if(Entries == 0) return;

   List_Templates();

   DLGInput(Array,TemplateName,0,36,Entries,6, "%a6Use which template? %a7-> ");
   TwoLines();

   ASPrintf(NULL,t,"DLGConfig:Template/%s%s",TemplateName,(AreaType ? ".file" : ".msg"));

   if(Array)   free(Array);   Array = NULL;

   if(!Exists(t))
   {
      AFPrintf(&UserDat,sout, "%a1ERROR %a5In Apply_Template(): %a3Template file does not exist!\n\n");
      return;
   }

   fh =  Open(t,MODE_OLDFILE);

   if(!fh)
   {
      AFPrintf(&UserDat,sout, "%a1ERROR %a5In Apply_Template(): %a3Cannot open emplate file %a7%s%a3!\n\n");
      return;
   }

   Read(fh,&plate,sizeof(struct Msg_Area_Template));
   Close(fh); fh = NULL;

   ma->Capacity   =  plate.Capacity;
   ma->Flag       =  plate.Flag;
   ma->UpperLimit =  plate.UpperLimit;
   ma->llevel     =  plate.llevel;
   ma->ulevel     =  plate.ulevel;

   if(strlen(plate.processor))
      strcpy(ma->processor,plate.processor);
   else
      strcpy(ma->processor,"");

   if(!AreaType && (plate.Flag & ECHO_AREA))
   {
      if(strlen(plate.origin))
         strcpy(ma->origin,plate.origin);
      else
         strcpy(ma->origin,"");
   }

   if(AreaType)   strcpy(ma->path,"");

   ma->uwrite     =  plate.uwrite;
   ma->lwrite     =  plate.lwrite;
   ma->ukill      =  plate.ukill;
   ma->lkill      =  plate.lkill;
   ma->uforward   =  plate.uforward;
   ma->lforward   =  plate.lforward;
   ma->ucopy      =  plate.ucopy;
   ma->lcopy      =  plate.lcopy;
   ma->uedit      =  plate.uedit;
   ma->ledit      =  plate.ledit;
   ma->lsysop     =  plate.lsysop;
   ma->usysop     =  plate.usysop;
   ma->savecharset=  plate.savecharset;

   return;
}
//-
