#include <exec/types.h>
#include <dos.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>

#include <dlg/menu.h>
#include <dlg/resman.h>

#include <exec/lists.h>

#include <proto/dlg.h>
#include <proto/dos.h>

#include <pragmas/dlg.h>

extern   BOOL  FindFunc(char *,struct FuncName *,int,USHORT *,UBYTE *);

extern   struct   Library *DLGBase;

struct   Node          *IFindName(struct List *,char *);
struct   BatchEntry   **ReadDLGBatch(struct BatchEntry **,struct BatchEntry *,char *,char *,struct FuncName *,int);

struct   Node          *IFindName(struct List *lst,char *name)
{struct Node *nd;

 nd = lst->lh_Head;

 while(nd->ln_Succ)
      {if (!Stricmp(name, nd->ln_Name))   return(nd);
       nd = nd->ln_Succ;
      }

 return(NULL);
}


struct BatchEntry **ReadDLGBatch(struct BatchEntry **lastbe,
                            struct BatchEntry  *dbe,
                                 char               *filename,
                                 char               *firstact,
                            struct FuncName    *funclist,
                                 int numfuncs)

{BPTR               bfp;
 struct BatchEntry *be;
 char              *s;
 char   line[256];
 UBYTE  type;

 if (!(bfp = Open(filename, MODE_OLDFILE)))
       return(NULL);

 while(FGets(bfp, line, 256))
      {line[strlen(line)-1] = 0;

       for(s = line; *s!=' '; s++);

       if (!Strnicmp(line,"ACTION",6))
          {firstact = s+1;
           continue;
          }

       if (!Strnicmp(line,"LLEV",4))
          {dbe->llev = atoi(s+1);
           continue;
          }

       if (!Strnicmp(line,"ULEV",4))
          {dbe->ulev = atoi(s+1);
           continue;
          }

       if (!Strnicmp(line,"RATE",4))
          {dbe->rate = atoi(s+1);
           continue;
          }

       if (!Strnicmp(line,"MAXTIME",7))
          {dbe->maxtime = atoi(s+1);
           continue;
          }

       if (!Strnicmp(line,"PRIORITY",8))
          {dbe->priority = atoi(s+1);
           continue;
          }

       if (!Strnicmp(line,"CHAIN",5))
          {dbe->flags |= MENU_CHAIN;
           continue;
          }

       if (!Strnicmp(line,"OVERLAY",7))
          {dbe->flags &= ~MENU_CHAIN;
           continue;
          }

       if (!Strnicmp(line,"BCPEND",6))
          {dbe->flags |= MENU_BCPEND;
           continue;
          }

       if (!Strnicmp(line,"BCRESUME",8))
          {dbe->flags &= ~MENU_BCPEND;
           continue;
          }

       if (!Strnicmp(line,"CLI",3))
          {dbe->flags |= MENU_CLI;
           continue;
          }

       if (!Strnicmp(line,"NOCLI",5))
          {dbe->flags &= ~MENU_CLI;
           continue;
          }

       if (!Strnicmp(line,"PAUSE",5))
          {dbe->flags |= MENU_RETURN;
           continue;
          }

       if (!Strnicmp(line,"NOPAUSE",7))
          {dbe->flags &= ~MENU_RETURN;
           continue;
          }

       if (!Strnicmp(line,"EXE",3))
          {type = MENU_EXE;
          }
  else if (!Strnicmp(line,"BATCH",5))
          {type = MENU_BATCH;
          }
  else if (!Strnicmp(line,"SUBMENU",7))
          {type = MENU_SUB;
          }
  else if (!Strnicmp(line,"DLGBATCH",8))
          {lastbe = ReadDLGBatch(lastbe,dbe,filename,firstact,funclist,numfuncs);
          }
  else if (!Strnicmp(line,"STACK",5))
          {type = MENU_STACK;
          }
  else if (!Strnicmp(line,"AREXX",5))
          {type = MENU_AREXX;
          }
  else if (!Strnicmp(line,"BUILTIN",7))
          {type = MENU_BUILTIN;
          }
  else continue;

       if (!(be = (struct BatchEntry *)malloc(sizeof(struct BatchEntry))))
             break;

       movmem(dbe, be, sizeof(struct BatchEntry));
       be->type = type;

       if (type == MENU_BUILTIN)
          {FindFunc(s+1, funclist, numfuncs, &(be->function), &(be->functype));
           be->program = NULL;
          }
        else
          {be->program = (char *)malloc(strlen(s+1)+1);
           strcpy(be->program, s+1);
          }

       (*lastbe) = be;

       if (firstact && *firstact)
          {be->action = (char *)malloc(strlen(firstact)+1);
           strcpy(be->action,firstact);
           firstact   =  NULL;
          }
        else
          {be->action = NULL;
          }

       be->next = NULL;
       lastbe = &(be->next);
      }

 Close(bfp);
 return(lastbe);
}
