#include <exec/types.h>
#include <exec/io.h>
#include <libraries/dosextens.h>

#include <stdlib.h>
#include <stdio.h>
#include <fcntl.h>
#include <ctype.h>
#include <string.h>

#include <devices/tpt.h>

#include <dlg/resman.h>
#include <dlg/cron.h>
#include <dlg/menu.h>
#include <dlg/crypt.h>

#include <proto/exec.h>
#include <proto/dos.h>
#include <proto/dlg.h>

#include <pragmas/dlg.h>

// SUPPOSEDLY required for TpTRM to work, but that part of the code is 
// commented out.  Straaaaaaaaaange......
#define CRCOFFSET   1664
#define NUMSTRINGS  1700
#define NUMINTERNAL 2

/// Old RMMsg, required for TrapDoor
struct OldRMMsg
{
  struct Message mess;
  char type;
  char *port;
  USHORT area;
  UBYTE flags;
  char *passwd;
  char *newpasswd;
  char *reason;
  char priority;
  char *breakcommand;
  void *dataptr;
};
//-


// TpTRM.c
extern void                HandleMsg(struct RMMessage *);
extern void                GetCRC(void);
extern void                CleanUp(char *);

extern unsigned long       CRC;

extern long                rmsigbit;
extern long                signal;

extern struct MsgPort     *rmctl;
extern struct MsgPort     *oldrmctl;
extern struct List         LangList;
extern struct List         ResourceList;
extern struct LangNode    *lbak;

extern struct FuncName    {char name[21];};

extern struct FuncName     internalfuncs[];
extern struct Library     *DLGBase;


// CRC.c
//extern unsigned long       CalculateCRC(unsigned char *,int);

// Lists.c
extern void                InitList(struct List *);
extern BOOL                Empty(struct List *);
extern struct Node        *FirstNode(struct List *);

// Locks.c
extern struct  List       *GetLockReport(struct List *);
extern void                FreeLockReport(struct List *);
extern int                 HandlePending(struct MiscNode *);


// Resources.c
extern struct  List       *RMGetResReport(void);
extern void                RMFreeResReport(struct List *);
extern BOOL                RMLockResource(struct MiscNode *,struct MiscLock *,struct RMMessage *);
extern struct MiscLock    *RMFreeResource(struct MiscNode *,struct RMMessage *);
extern BOOL                CheckResource(struct MiscNode *,struct RMMessage *);


// Menu.c
extern struct MenuNode    *LoadMenu(char *);
extern BOOL                FindFunc(char *,struct FuncName *,int,USHORT *,UBYTE *);
extern int                 ReadMenuFuncs(char *,struct FuncName **);
extern void                RMFreeMenu(struct MenuNode *);
extern void                RemFromPorts(struct MenuNode *);
extern void                LoadCustomMenu(struct PortNode *,UBYTE,char *);
extern void                FreeCustomMenu(struct PortNode *);


// Languages.c
extern struct LangNode    *RMLoadLang(char *);
extern BOOL                FreeLang(struct LangNode *);


// Misc.c
extern struct Node        *IFindName(struct List *, char *);
extern struct BatchEntry **ReadDLGBatch(struct BatchEntry **,struct BatchEntry *,char *,char *,struct FuncName *,int);


// Areas.c
extern struct AreaNode    *FindTheArea(struct RMMessage *,UBYTE);
extern void                RemoveArea(struct RMMessage *);
extern BOOL                LockInQueue(struct List *);
