#include <stdlib.h>
#include <string.h>
#include <exec/types.h>
#include <ctype.h>

#include <dlg/dlg.h>
#include <dlg/resman.h>

#include <link/io.h>
#include <link/lang.h>

#include <proto/exec.h>
#include <proto/dos.h>
#include <proto/dlg.h>

#include <pragmas/dlg.h>

#include <private/Version.h>
#define  ObjRev "1"
const UBYTE version[]="\0$VER: DeactivatePort " BUILDVER "." ObjRev " " COPYRIGHT " by Digerati Dreams "__AMIGADATE__;

void main   (int, char **);
void Usage  (char *);
void CleanUp(char *);

BPTR            sout;
char          **SA;
struct Library *DLGBase = NULL;


void main(int argc, char **argv)

{long retval;
 char port[4] = "";
 char immed   = 0;

 sout    = Output();
 DLGBase = OpenLibrary(DLGNAME,DLGVERSION);
 if (!DLGBase)               CleanUp("Unable to open dlg.library");

 AFPrintf(NULL, sout, "\n");

/// parse args
 while(--argc>0)
      {char *s;

       s = *++argv;
       if (*s++ == '-')
          {while(*s)
                {switch(*s++)
                       {case 'p':
                        case 'P': if (!--argc)  break;
                                  strncpy(port, *++argv, 3);
                                  port[3] = 0;
                                  Upper(port);
                                  break;

                        case 'i':
                        case 'I': immed = 1;
                                  break;
                       }
                }
          }
      }
//-

 if (!(SA = getlang(port)))  CleanUp("Can't read language file");
 if (!port[0])  Usage(SA[2761]);

 if (immed)
     retval = ImmedLockPort(port,"DEACTIVATE","Deactivating Port",127,"");
   else
     retval = LockPort(port,"DEACTIVATE","Deactivating Port",127,"");

 if (retval == RMNOERR)
    {AFPrintf(NULL, sout, SA[2762]);

     retval = DeActivatePort(port,"DEACTIVATE");
     if (retval == RMNOERR)
         AFPrintf(NULL, sout, SA[2763]);
       else
         if (retval == NORM)
             CleanUp(SA[2764]);
           else
             if (retval == BADPORT)
                 CleanUp(SA[2765]);
               else
                 CleanUp(SA[2766]);
    }
  else
    if (retval == NORM)
        CleanUp(SA[2764]);
      else
        if (retval == BADPORT)
            CleanUp(SA[2765]);
          else
            if (retval == NOTLOCKED)
                CleanUp(SA[2767]);
              else
                CleanUp(SA[2766]);

 AFPrintf(NULL, sout, "\n");
 CleanUp(NULL);
}


void Usage(char *string)

{
 AFPrintf(NULL, sout, SA[2768],string);
 AFPrintf(NULL, sout, SA[2769]);
 AFPrintf(NULL, sout, SA[2770]);

 CleanUp(NULL);
}


void CleanUp(char *s)

{if (DLGBase)  CloseLibrary(DLGBase);

 if (s)
    {Write(sout, "\n Error: ", 9);
     Write(sout,  s,    strlen(s));
     Write(sout, "\n\n",       2);
    }

 exit(s?5:0);
}
