/* Note: the language files are not used for ActivatePort because
** until the RM is loaded, we have no idea what the language files
** ARE.  ActivatePort will turn on ResMan if it is not actually
** running.
*/

#include <stdlib.h>
#include <string.h>
#include <exec/types.h>
#include <ctype.h>

#include <dlg/dlg.h>
#include <dlg/resman.h>
#include <dlg/cron.h>

#include <link/io.h>

#include <proto/exec.h>
#include <proto/dos.h>
#include <proto/dlg.h>

#include <pragmas/dlg.h>

#include <private/Version.h>
#define  ObjRev "5"
const UBYTE version[]="\0$VER: ActivatePort " BUILDVER "." ObjRev " " COPYRIGHT " by Digerati Dreams "__AMIGADATE__;

void main   (int, char **);
void Usage  (char *);
void CleanUp(char *);

BPTR            sout;
struct Library *DLGBase = NULL;

void main(int argc, char **argv)

{long  retval;

 char *bgcommand;
 char  port    [4]  = "";
 char  dcommand[14] = "DLG:SetUp ";

 sout    = Output();
 DLGBase = OpenLibrary(DLGNAME, DLGVERSION);
 if (!DLGBase)  CleanUp("Unable to open dlg.library");

 AFPrintf(NULL, sout, "\n");

   Forbid();

   if (!FindPort(RMCONTROL))
   {
      long  count;

      Permit();
      AFPrintf(NULL, sout, " Installing ResMan ...\n\n");
      CronEvent(ADDEVENT, 0, "DLG:ResMan");

      for(count=0; count < 100; count++)
      {
         Delay(50);
         if (FindPort(RMCONTROL))  break;
      }

      if (count == 10)  CleanUp("ResMan is not installed");
   }
   else
   {
      Permit();
   }

 bgcommand = dcommand;

/// parse args
 while(--argc > 0)
      {char *s;

       s = *++argv;
       if (*s++=='-')
          {while(*s)
                {switch(*s++)
                       {case 'p':
                        case 'P':  if (!--argc)  break;
                                   strncpy(port, *++argv, 3);
                                   port[3] = 0;
                                   Upper(port);
                                   strcpy(&dcommand[10], port);
                                   dcommand[13] = 0;
                                   break;

                        case 'b':
                        case 'B':  if (!--argc)  break;
                                   bgcommand = *++argv;
                                   break;
                       }
                }
          }
      }
//-

 if (!port[0])  Usage("You must specify a port");

 retval = ActivatePort(port, bgcommand);

 if (retval == RMNOERR)
     AFPrintf(NULL, sout, " [%s] activated successfully\n", port);
   else
     if (retval == PORTACTIVE)
         CleanUp("Port is already active");
       else
         CleanUp("Failed to activate port");


 AFPrintf(NULL, sout, "\n");
 CleanUp(NULL);
}


void Usage(char *string)

{AFPrintf(NULL, sout, " %s\n\n",string);
 AFPrintf(NULL, sout, " Usage:  ActivatePort -p <port> [-b <background command>]\n\n");

 CleanUp(NULL);
}


void CleanUp(char *s)

{if (DLGBase)  CloseLibrary(DLGBase);

 if (s)
    {Write(sout, "\n Error: ", 9);
     Write(sout,  s,    strlen(s));
     Write(sout, "\n\n",       2);
    }

 exit(s?5:0);
}
