#include <dos.h>
#include <stdlib.h>
#include <string.h>
#include <exec/types.h>

#include <dlg/dlg.h>
#include <dlg/resman.h>
#include <dlg/input.h>
#include <dlg/user.h>
#include <dlg/misc.h>
#include <dlg/nl.h>

#include <link/io.h>

#include <proto/exec.h>
#include <proto/dos.h>
#include <proto/dlg.h>

#include <pragmas/dlg.h>

#include <private/Version.h>
#define  ObjRev "1"
const UBYTE version[]="\0$VER: NodeInfo " BUILDVER "." ObjRev " " COPYRIGHT " by Digerati Dreams "__AMIGADATE__;

#define INSTACK RStruct.Command_Stack[0]
#define STK     RStruct.Command_Stack
#define HOT     UserDat.Hot_Keys


void   main(int, char **);
void   CheckNode(SHORT, SHORT, SHORT);
void   CleanUp(char *);
void  _CXBRK(void);


BPTR             sout;
struct Library  *DLGBase      = NULL;
struct Library  *NodelistBase = NULL;

struct USER_DATA UserDat;
struct Ram_File  RStruct;
struct fido      FidoNet;

struct UserInfo  ui = {&UserDat, &RStruct};
struct Query     q  = {NULL, NULL, NULL, NULL, NULL, 0, 0, 0};

short     crash        = FALSE;
char     *nodepath     = NULL;
NodeList *the_nodelist = NULL;
NodeDesc *node_desc    = NULL;

struct LangStruct *ls;
char             **SA;


void main(int argc, char **argv)

{char *s;
 char  Ext[4];
 char  tempname[80];

 short Zone;
 short Net;
 short Node;
 short Point;

 sout = Output();
 if (!(DLGBase = OpenLibrary(DLGNAME, DLGVERSION))) exit(5);;

 if (GetDevName(Ext)==-1)   CleanUp("Couldn't find port");
 if (!(ls = GetLang(Ext)))  CleanUp("Unable to get language");
 SA=ls->strings;

 if (!ReadUser(&RStruct,&UserDat,Ext))  CleanUp(SA[2671]);
 if (GetFirstStruct("dlgconfig:port/FidoNet.Settings",(char *)&FidoNet, sizeof(FidoNet)))
     CleanUp(SA[2672]);

 if (argc < 2)
     nodepath = FidoNet.nodelistpath;
   else
    {if (argv[1][0] == '?')
        {AFPrintf(&UserDat, sout, SA[2673]);
         AFPrintf(&UserDat, sout, SA[2674]);
         AFPrintf(&UserDat, sout, SA[2675]);
         CleanUp(NULL);
        }

     nodepath = argv[1];
    }
  

 Clr(UserDat.Ansi_Flag);

 while(TRUE)
      {Zone  = 0;
       Net   = 0;
       Node  = 0;
       Point = 0;

       q.prompt     = SA[2676];
       q.string     = tempname;
       q.length     = 32;
       q.typelength = 255;
       DLGQuery(&q, &ui);

       Chk_Abort();
       if (!strchr(tempname, ':') && !strchr(tempname, '/') && !strchr(tempname, '.'))
          {Zone = atoi(tempname);
           tempname[0] = 0;
          }

      if ((s = strchr(tempname, ':')))
         {Zone = atoi(tempname);
          strcpy(tempname, ++s);
          Net = -1;
         }

      if ((s = strchr(tempname, '/')) || Net < 0)
         {Net = atoi(tempname);
          if (s)
              strcpy(tempname, ++s);
            else
              tempname[0] = 0;
         }

      Node = atoi(tempname);
      s    = strchr(tempname, '.');
      if (s)  Point = atoi(++s);

      if (!Zone)
         {q.prompt     = SA[2677];
          q.string     = tempname;
          q.length     = 6;
          q.typelength = 255;
          DLGQuery(&q, &ui);
          Zone = atoi(tempname);
         }

      if (!Net)
         {q.prompt     = SA[2678];
          q.string     = tempname;
          q.length     = 6;
          q.typelength = 255;
          DLGQuery(&q, &ui);
          Net = atoi(tempname);
         }

      if (!Node)
         {q.prompt     = SA[2679];
          q.string     = tempname;
          q.length     = 12;
          q.typelength = 255;
          DLGQuery(&q, &ui);
          Node = atoi(tempname);
          if ((s = strchr(tempname, '.')))  Point = atoi(++s);
         }

       Chk_Abort();
       break;
      }

 AFPrintf(NULL, sout, "\n\n");
 CheckNode(Zone, Net, Node);

 CleanUp(NULL);
}


void CheckNode(SHORT zone, SHORT net, SHORT node)

{Addr   find_me;
 SHORT  cost;

 if (!(NodelistBase = OpenLibrary("traplist.library", 3L)))
    {AFPrintf(&UserDat, sout, SA[2680]);
     return;
    }

 if (!(the_nodelist = NLOpen(nodepath, 0)))
    {CloseLibrary(NodelistBase);
     return;
    }

 find_me.Zone  = zone;
 find_me.Net   = net;
 find_me.Node  = node;
 find_me.Point =  0;

 if (node_desc = NLFind(the_nodelist, &find_me, 0))
    {AFPrintf(&UserDat, sout, SA[2681], node_desc->Node.Zone,
                                       node_desc->Node.Net,
                                       node_desc->Node.Node,
                                       node_desc->Node.Point,
                                       node_desc->System,
                                       node_desc->City);
     AFPrintf(&UserDat, sout, SA[2682], node_desc->Sysop);
     AFPrintf(&UserDat, sout, SA[2683], node_desc->Region, node_desc->Hub);
     AFPrintf(&UserDat, sout, SA[2684], node_desc->BaudRate);
     AFPrintf(&UserDat, sout, SA[2685], node_desc->Phone);

     cost = node_desc->Cost;
     if (cost != -1)
         AFPrintf(&UserDat, sout, SA[2686], cost/100, cost%100);
       else
         AFPrintf(&UserDat, sout, SA[2687]);

     AFPrintf(&UserDat, sout, SA[2688], node_desc->Flags);

     if (strstr(node_desc->Flags, "CM"))
         crash = TRUE;
       else
        {crash = FALSE;
         AFPrintf(&UserDat, sout, SA[2689]);
        }

     AFPrintf(&UserDat, sout, "\n\n");
    }
  else
     AFPrintf(&UserDat, sout, SA[2690]);

 return;
}


void CleanUp(char *s)

{if (node_desc)     NLFreeNode(node_desc);
 if (the_nodelist)  NLClose(the_nodelist);
 if (NodelistBase)  CloseLibrary(NodelistBase);

 CloseLibrary(DLGBase);

 if (s)
    {Write(sout, "\n\n Error: ", 10);
     Write(sout,  s, strlen(s));
     Write(sout, "\n\n", 2);
    }

 exit(s?5:0);
}


void _CXBRK(void)

{AFPrintf(&UserDat, sout, SA[2691]);
 CleanUp(NULL);
}
