#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <dos.h>
#include <fcntl.h>
#include <stat.h>
#include <exec/types.h>
#include <libraries/dosextens.h>
#include <devices/tpt.h>

#include <dlg/dlg.h>
#include <dlg/msg.h>
#include <dlg/file.h>
#include <dlg/resman.h>

#include <link/io.h>
#include <link/lang.h>
#include <link/util.h>

#include <proto/dos.h>
#include <proto/exec.h>
#include <proto/dlg.h>

#include <pragmas/dlg.h>

#include <private/Version.h>
#define  ObjRev "1"
const UBYTE version[]="\0$VER: Freshen " BUILDVER "." ObjRev " " COPYRIGHT " by Digerati Dreams "__AMIGADATE__;

void  main(void);
void  FreshenAreas(long, struct Msg_Area *);
int   SortQF(struct QuickFile *,struct QuickFile *);
void  Aborted(char *);
void _CXBRK(void);

BPTR             sout;
struct Library  *DLGBase =  NULL;
char           **SA;

int               fp     = 0;
int               fp1    = 0;
long              qsize  = 0;
struct QuickFile *QF     = NULL;
struct Msg_Area   Area;


void main()
{sout = Output();

 if (!(DLGBase = OpenLibrary(DLGNAME, DLGVERSION)))  exit(5);
 if (!(SA = getlang(NULL)))                          Aborted(NULL);
 if ((fp = open("FILE:Area.bbs",O_RDONLY))==EOF)     Aborted(SA[668]);

 while(read(fp, &Area, sizeof(Area)) == sizeof(Area))
       FreshenAreas(Area.Number, &Area);

 Aborted(NULL);
}


void FreshenAreas(long area, struct Msg_Area *MA)
{long   hi;
 long   low;
 long   size;
 long   counter;
 long   filecount = 0;

 GetHiLowFPointers(area, "NONE", &low, &hi, "Freshen");
 if (!hi)  return;

 size = (hi - low + 1) * (long)sizeof(struct QuickFile);
 if (qsize < size)
    {if (qsize)
        {free(QF);
         qsize = 0;
        }

     if (!(QF = malloc(size)))
        {AFPrintf(NULL, sout, SA[669],size);
         return;
        }

     qsize = size;
    }

 for(counter=low; counter<=hi; counter++)
    {ULONG  fsize;
     long   date;

     struct File_Header Header;
     char   filename[80];
     char   path    [256];
     char   altpath [256];
     char   body    [60];

     ASPrintf(NULL, filename, "FILE:%d/%ld.fd", area, counter);
     BorrowArea(area, "Freshen", "", 64, FILELOCK|WRITELOCK);

     if ((fp1 = open(filename, O_RDWR))==EOF)
        {FreeArea(area, "Freshen", FILELOCK|WRITELOCK);
         continue;
        }

     if (read(fp1, &Header, sizeof(Header)) != sizeof(Header))
        {FreeArea(area,"Freshen",FILELOCK|WRITELOCK);
         close(fp1);
         fp1 = 0;
         continue;
        }

     GetPath(path, area, MA, Header.Filename);
     ASPrintf(NULL, altpath, "%s%s", path, Header.Filename);

     if (FileSize(altpath, &fsize)!=-1 && fsize!=Header.Size)
        {Header.Size = fsize;
         lseek(fp1, 0, 0);
         write(fp1, &Header, sizeof(Header));
        }

     StringToDate(Header.Date, &date);
    (QF+filecount)->date   = date;
    (QF+filecount)->number = counter;
    (QF+filecount)->size   = Header.Size;
     strcpy((QF+filecount)->filename, Header.Filename);
     body[read(fp1, body, 58)] = 0;
     strcpy((QF+filecount)->desc, body);
     filecount++;

     close(fp1);
     fp1 = 0;
     FreeArea(area, "Freshen", FILELOCK|WRITELOCK);

     AFPrintf(NULL, sout, SA[670], altpath, filename);
     if (!SetComment(altpath, filename))
          AFPrintf(NULL, sout, SA[671],Header.Filename);
    }

 if (filecount)
    {char qfile[24];

     AFPrintf(NULL, sout, SA[672]);
     qsort(QF, filecount, sizeof(struct QuickFile), SortQF);


     ASPrintf(NULL, qfile, "File:%d/File.dat", area);
     BorrowArea(area, "Freshen", "", 64, FILELOCK|WRITELOCK);

     DeleteFile(qfile);
     if ((fp1 = open(qfile, O_RDWR+O_CREAT)) == EOF)
        {FreeArea(area, "Freshen", FILELOCK|WRITELOCK);
         AFPrintf(NULL, sout, SA[673], qfile);
         return;
        }

     size = filecount * sizeof(struct QuickFile);
     write(fp1, QF, size);
     close(fp1);
     fp1 = 0;

     FreeArea(area, "Freshen", FILELOCK|WRITELOCK);
    }

 AFPrintf(NULL, sout, "\n");
 return;
}


int SortQF(struct QuickFile *st1, struct QuickFile *st2)

{return(Stricmp(st1->filename, st2->filename));
}


void Aborted(char *string)

{if (string)  AFPrintf(NULL, sout, SA[674],string);

 if (fp)   close(fp);
 if (fp1)  close(fp1);
 FreeArea(Area.Number, "Freshen", FILELOCK|WRITELOCK);
 if (qsize) free(QF);

 CloseLibrary(DLGBase);
 exit(string?5:0);
}


void _CXBRK()

{Aborted(NULL);
}
