#define   ANSICOL

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <ctype.h>
#include <dos.h>
#include <exec/types.h>
#include <libraries/dosextens.h>

#include <dlg/portconfig.h>
#include <dlg/user.h>
#include <dlg/input.h>
#include <dlg/msg.h>
#include <dlg/resman.h>
#include <dlg/log.h>

#include <dlg_private/dlg.h>

#include <proto/dlg.h>
#include <proto/dos.h>
#include <proto/exec.h>

#include <pragmas/dlg.h>

static char version[]="$VER: NewUser 2.2  1995-1997 by DLG Development "__AMIGADATE__"";


void  main    (int, char **);
void  Add_User(void);
void _CXBRK   (void);


struct Global_Settings Globals;
struct USER_DATA       UserDat   = {"", 24, 80, 0, 1, 0, "", "", 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "", 0, 0, 0, 0, 0, 0, "", 0, 0, 0, "", "", "", 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "", 0, 0, 0, "", 0, "", 0, 0, 0, "", 0, 0, 0};
struct Ram_File        RStruct;
struct USER_DATA       User;
struct UserInfo        fake_ui  = {&UserDat, &RStruct};

struct Msg_Area        Area;
struct Msg_Log         Log;

struct Msg_Area        FArea;
struct Msg_Log         FLog;

char                   UserName[30];
char                   Ext[5];
USHORT                 pos;

BPTR                   sout;
struct Library        *DLGBase;
struct LangStruct     *ls;
struct NameStruct      ns        ={"", "", ""};
char                 **SA;


void main(int argc, char **argv)
{
   sout = Output();

   if (!(DLGBase = OpenLibrary(DLGNAME, DLGVERSION)))  exit(5);

   if (argc < 3)
   {
      AFPrintf(NULL,sout,"Usage: NewUser name ansi_setting\n\n");
      _CXBRK();
   }

   if (GetDevName(Ext) == -1)
   {
      AFPrintf(NULL,sout,"Unable to determine port\n\n");
      _CXBRK();
   }

   if (!(ls=(struct LangStruct *)GetLang(Ext)))  _CXBRK();
   SA = ls->strings;

   if (ReadGlobals(Ext,&Globals) == -1)
   {
      AFPrintf(NULL,sout,SA[1460]);
      return;
   }

   RStruct.Command_Stack[0] = 0;
   strcpy(UserName, argv[1]);
   if (!Stricmp(argv[2], "COLOR"))
   UserDat.Ansi_Flag = Globals.Flags & (ANSI_COLOR + ANSI_CLR + ANSI_POS + ANSI_SCROLL + ANSI_NOFREEZE);

   DispForm("DLGCONFIG:Text/NewUser.txt", &UserDat, &UserDat, &RStruct, Ext);

   if (!(BoolQuery(SA[1459], 1, &fake_ui)))
   {
      AFPrintf(NULL,sout,"\n");
      DispForm("DLGCONFIG:Text/NoRegistration.txt", &UserDat, &UserDat, &RStruct, Ext);
      AFPrintf(NULL,sout,"\n");
   }
   else
   {
      AFPrintf(NULL,sout,"\n\n");
      Add_User();
   }

   _CXBRK();
}


void Add_User(void)
{
   BPTR fp;
   BPTR lock;
   char filename[48];
   char batchname[50];

   if (New_User(UserName,&User,0))
   {
      AFPrintf(NULL,sout,SA[1461]);
      return;
   }

   strcpy(RStruct.Name, UserName);
   UserDat.Ansi_Flag = User.Ansi_Flag;
   AFPrintf(NULL,sout,"%a7\n\n");

   ASPrintf(NULL, filename, "USER:%s", UserName);
   UnderScore(filename);
   Upper(filename);
   if (!(lock = CreateDir(filename)))
   {
      AFPrintf(&UserDat,sout,SA[1462]);
      return;
   }
   UnLock(lock);
   AFPrintf(&UserDat,sout,SA[1463]);

   ASPrintf(NULL,filename,"User:%s/User.data",UserName);
   UnderScore(filename);

   if (NULL == (fp = Open(filename,MODE_NEWFILE)))
   {
      AFPrintf(&UserDat,sout,SA[1464]);
      return;
   }

   Write(fp, &User, sizeof(struct USER_DATA));
   Close(fp);
   AFPrintf(&UserDat,sout,SA[1465]);

   strcpy(Log.Name, UserName);
   Upper(Log.Name);
   Log.High_Mess = 0;
   Log.dflag     = 0;
   Log.special   = 0;
   Log.uflag     =(unsigned char)0xff;

   ASPrintf(NULL,filename,"USER:%s/User.Msg",UserName);
   UnderScore(filename);
   AddStruct(filename,(char *)&Log,sizeof(Log),36);

   ASPrintf(NULL,filename,"USER:%s/User.File",UserName);
   UnderScore(filename);
   AddStruct(filename,(char *)&Log,sizeof(Log),36);

   AFPrintf(&UserDat,sout,SA[1466]);
   AddGlobalAreas(UserName,0,User.User_Level,0|128,"MSG:Area.bbs");
   AddGlobalAreas(UserName,0,User.User_Level,1|128,"FILE:Area.bbs");
   DispForm("DLGCONFIG:Text/FinishedApplication.txt", &UserDat, &UserDat, &RStruct, Ext);
   AFPrintf(NULL,sout,"%a7\n");
   WriteLog(NEW_USER,UserName,Ext,"");

   Upper(UserName);

   strcpy(ns.name,UserName);
   strcpy(ns.alias,User.Alias);
   strcpy(ns.email,User.Email);
   AddStruct(NAMERECORD,(char *)&ns,sizeof(struct NameStruct),NAMELEN);
   AddStruct(NEWUSERS,(char *)&ns,sizeof(struct NameStruct),NAMELEN);

   Capitalize(UserName);
   strcpy(RStruct.Name,UserName);

   ASPrintf(NULL,batchname,"DlgConfig:batch/NewUser.batch %s",Ext);
   if (Exists("DlgConfig:batch/NewUser.batch"))
   Execute(batchname,0L,0L);

   if (Exists("DlgConfig:batch/NewUser.dlgbatch"))
   DialogBatch("DLGCONFIG:Batch/NewUser.dlgbatch",&User,&RStruct,Ext);

   return;
}


void _CXBRK(void)

{
   CloseLibrary(DLGBase);
   exit(0);
}
