#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dlg/msg.h>
#include <proto/dlg.h>

#include <link/io.h>

#include <pragmas/dlg.h>

extern char             threadmode;
extern struct USER_DATA UserDat;
extern struct Library  *DLGBase;
 
char *array  = 0;
SHORT active = 0;
SHORT high   = 0;
SHORT low    = 0;

SHORT next;
SHORT base;


BYTE StartThread(SHORT l, SHORT h, SHORT current)

{SHORT a;

 if (active)
    {if (active < h-l+1)
        {free(array);

         active = 0;
         high   = 0;
         low    = 0;
         array  = 0;
        }
    }

 if (!array)
    {active = h - l + 1;
     active = (active & 0xF000) + 4096;

     if (!(array = (char *)malloc(active)))
          {active = 0;
           return(-1);
          }
    }

 /* Zero the bytes in the array */
 for(a = 0; a < active; a++)
     array[a] = 0;

 base = current;
 high = h;
 low  = l;
 return(0);
}


VOID BaseThread(SHORT newbase)

{base = newbase;
}


/* Checks to see if the user is on a base message */
BYTE IsBaseThread(VOID)

{if (next == base || !threadmode)  return(1);
 return(0);
}


/* This will free the array and set active to off */
VOID EndThread(VOID)

{if (active)  free(array);

 array  = 0;
 active = 0;
 high   = 0;
 low    = 0;
}


SHORT NextMessage(SHORT direction,SHORT back,SHORT forward,SHORT success,SHORT highest)

{char  *temp;
 SHORT  a;

 next = 0;

 if (highest > high)
    {if (highest >= low+active)
        {a = highest - low + 1;
         a = (active & 0xF000) + 4096;

         if (!(temp = (char *)malloc(a)))
               return(-1);

         if (array)
            {movmem(array, temp, active);
             free(array);
             active = 0;
            }

         array  = temp;
         active = a;
         for(a = (high-low+1); a < active; a++)
             array[a] = 0;
        }

     high = highest;
    }

 if (direction ==  1 &&  success != 5)                   next = forward;
 if (direction == -1 &&  success != 5  &&  back >= low)  next = back;

 if (!next)
    {do{base += direction;
        next  = base;
        if (next > high  ||  next < low)  return(next);
       } while(array[next-low] == 1);
    }

 if (next <= high  &&  next >= low)  array[next-low] = 1;

 return(next);
}


SHORT SkipRest(long area, long current, SHORT direction, char *tagfile)

{char              filename[22];
 char              msgid   [12];
 SHORT             counter = 0;
 struct Msg_Header header;

 do {ASPrintf(NULL, filename, "MSG:%d/%d.msg", area, current);
     if (GetFirstStruct(filename, (char *)&header, sizeof(header)) == -1)
         break;

     if (current <= high  && current >= low)
        {counter++;
         array[current-low] = 1;

         if (tagfile)
            {ASPrintf(NULL, msgid, "%04d:%05d", area, current);
             AddStruct(tagfile, msgid, 11, 11);
            }
        }

     if (direction == -1)  current = header.ReplyTo;
     if (direction ==  1)  current = header.NextReply;
    } while(current);

 return(counter);
}
