#include <exec/types.h>
#include <libraries/dos.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <stdio.h>
#include <fcntl.h>
#include <dialog/resman.h>
#include <dialog/msg.h>
#include <dialog/user.h>
#include <dialog/misc.h>
#include <dialog/cron.h>
#include <proto/dlg.h>

/*  0 Success */
/* -1 can't allocate memory */
/* -2 no access to netmail or not enough credit */
/* -3 Can't open area.bbs file */

/* header = header of the message */
/* our fidonet structure - modified version in tse.h */
/* fidonet structure with the zone,net,node,and point filled in */
/* filename of body text */
/* optional user data of user sending mail or NULL */
/* optional cost of message, to be provided if the user data is present */
/* pswd is the password to lock borrow the area with */
/* ext is the port the message is being sent from */

extern struct Library *DLGBase;

BYTE SendNet(struct Msg_Header *header,
             struct fido       *ourfido,
             struct fido       *destfido,
             char              *bodybuf,
             struct USER_DATA  *userdata,
             int                cost,
             char              *pswd,
             char              *ext)

{char  *dbody       = NULL;
 long   success     = 0;
 long   pbufsz;
 char   prebuf[512];
 struct Msg_Area  msgarea;
 struct MsgStruct ms;
 int fp;

 if (userdata)
     if (!userdata->NetMail || userdata->credit<cost)
          return(-2);

 header->Attribute &= ~Received;
 header->Attribute &= ~Sent;
 header->TimesRead  = (header->Attribute&Private)?PRINET_MSG:PUBNET_MSG;
  
 header->DestNet  = destfido->net;
 header->DestNode = destfido->node;
 header->OrigNet  = ourfido->net;
 header->OrigNode = ourfido->node;

 prebuf[0] = 0;
 pbufsz    = 0;
 if (destfido->zone!=ourfido->zone)  /* Insert the kludge lines as first thing */
    {pbufsz = ASPrintf(NULL, prebuf, "%cINTL %d:%d/%d %d:%d/%d%c", 1, destfido->zone, destfido->net,destfido->node,ourfido->zone,ourfido->net,ourfido->node,13);
     header->DestNet  = ourfido->zone;
     header->DestNode = destfido->zone;
    }

 if (destfido->point)
     pbufsz += ASPrintf(NULL, prebuf+pbufsz, "%cTOPT %d%c",1,destfido->point,13);

 if (ourfido->point)
     pbufsz += ASPrintf(NULL, prebuf+pbufsz, "%cFMPT %d%c",1,ourfido->point,13);

 if ((fp=open("MSG:Area.bbs",O_RDONLY))==EOF)  return(-3);

 while(read(fp,&msgarea,sizeof(msgarea))==sizeof(msgarea))
       if (msgarea.Flag & NETMAIL_AREA)
          {success++;
           break;
          }
 close(fp);

 if (!(dbody = malloc(pbufsz + strlen(bodybuf) + 2)))  return(FALSE);

 strcpy(dbody,        prebuf);
 strcpy(dbody+pbufsz, bodybuf);

 ms.header    =  header;
 ms.repheader =  NULL;
 ms.body      = (unsigned char *)dbody;
 ms.replyto   =  0;
 ms.areainfo  = &msgarea;
 ms.flags     =  0;

 if (success)
    {SendPublicMsg(&ms,ourfido,pswd,ext);
     if (userdata)  userdata->credit -= cost;
     if (header->Attribute & Crash)
         CronEvent(ADDEVENT,0,"Execute dlgconfig:batch/CrashMail.batch");
    }

 free(dbody);
 return(0);
}
