#include <fcntl.h>
#include <stdio.h>
#include <proto/dlg.h>
#include <proto/dos.h>
#include <dialog/misc.h>

extern struct Library  *DLGBase;
extern char           **SA;
extern struct USER_DATA StUser;

int ListArchivers(int level, int mask)

{int fp,count=0;
 struct Archiver archiver;

 if ((fp=open("DLGCONFIG:Misc/Archivers.bbs",O_RDONLY))==EOF)
    {
     AFPrintf(&StUser,Output(),SA[3458]);
     return(-1);
    }

 AFPrintf(&StUser,Output(),SA[3459]);
 Draw_Line(75);

 while(read(fp,&archiver,sizeof(archiver))==sizeof(archiver))
      {if (archiver.compress[0]=='\0'&& (mask&COMPRESS))      continue;
       if (archiver.decompress[0]=='\0'&& (mask&DECOMPRESS))  continue;
       if (archiver.integrity[0]=='\0'&& (mask&INTEGRITY))    continue;
       if (archiver.view[0]=='\0'&& (mask&VIEW))              continue;

       if (archiver.level<=level)
           AFPrintf(&StUser,Output(),SA[3460],archiver.number,archiver.name,archiver.compression);

       if (archiver.number>count)   count=archiver.number;
      }

 Draw_Line(75);
 AFPrintf(NULL, Output(), "\n");
 close(fp);
 return(count);
}


int CheckArchiver(int number, int level, int mask)

{struct Archiver archiver;
 int             fp;

 if (!number)                                                   return(FALSE);
 if ((fp=open("DLGCONFIG:Misc/Archivers.bbs",O_RDONLY))==EOF)   return(FALSE);

 while(read(fp,&archiver,sizeof(archiver))==sizeof(archiver))
      {if (archiver.number==number)
          {close(fp);
           if (archiver.level>level)                             return(FALSE);
           if (archiver.compress[0]=='\0'&& mask&COMPRESS)       return(FALSE);
           if (archiver.decompress[0]=='\0'&& mask&DECOMPRESS)   return(FALSE);
           if (archiver.integrity[0]=='\0'&& mask&INTEGRITY)     return(FALSE);
           if (archiver.view[0]=='\0'&& mask&VIEW)               return(FALSE);
           return(TRUE);
          }
      }

 close(fp);
 return(FALSE);
}
