#include <exec/types.h>

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <exec/libraries.h>

#include <proto/exec.h>
#include <proto/dos.h>
#include <proto/DLG.h>

extern struct Library   *DLGBase;

char *CenterText(char *, int);

/****************************************************************
**
** CenterText(char *, int)
**
** Centers text to a set width, padded with spaces
**
** Input char *Text  == the text string to center
** Input int   Width == the width to center across
**
** returns a pointer to the new centered text
**
** returns NULL if an error occurs, if the width is less than
** the size of the string, if width is 0, if the text string is
** NULL, or the strlen of the text is 0.
*/


char *CenterText(char *Text, int Width)
{
   char    *t;
   char    *p;

   int      i;
   int      lead;

   if(!Text) return(NULL);
   if(Width <= 0) return(NULL);
   if(strlen(Text) >= Width) return(NULL);
   if(strlen(Text) == 0) return(NULL);


   lead = (Width - strlen(Text)) / 2;

   t = calloc(lead + 1,sizeof(char));
   if(!t) return(NULL);

   for(i=0;i<Width;i++)
      t[i] = ' ';

   p = calloc(lead + strlen(Text) + 1,sizeof(char));

   if(!p)
   {
      free(t);
      return(NULL);
   }

   strcpy(p,t);
   strcat(p,Text);

   free(t);

   return(p);
}

