#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <intuition/intuition.h>
#include <graphics/gfx.h>
#include <graphics/gfxbase.h>
#include <graphics/gfxmacros.h>
#include <graphics/regions.h>
#include <graphics/display.h>
#include "creq.h"

#include <proto/graphics.h>
#include <proto/intuition.h>
#include <proto/exec.h>
#include <proto/dos.h>
#include <proto/dlg.h>

#include <Link/Config.h>

#define RP ColourWindow->RPort

#include <pragmas/dlg.h>

extern struct Library *DLGBase;
struct Window   *ColourWindow;
struct Screen   *MainScreen;
struct TextFont *tf = NULL;
struct TextAttr  ta;

LONG   activec = 0;
UWORD  oldpalette[8];
UWORD  defpalette[8] = {0x000,0xdb6,0x373,0xf70,0x00d,0xb07,0x0bd,0xccc};


VOID ColorReq(UWORD *palette,int width,int height,UBYTE interlace,UBYTE hires)

{USHORT  flagi;

 movmem(palette, oldpalette, 16);

 CGadget1.Flags = GFLG_GADGHBOX | GFLG_SELECTED;
 CGadget2.Flags = GFLG_GADGHBOX;
 CGadget3.Flags = GFLG_GADGHBOX;
 CGadget4.Flags = GFLG_GADGHBOX;
 CGadget5.Flags = GFLG_GADGHBOX;
 CGadget6.Flags = GFLG_GADGHBOX;
 CGadget7.Flags = GFLG_GADGHBOX;
 CGadget8.Flags = GFLG_GADGHBOX;
 OpenColorWindow(width, height, interlace, hires);

 SetAPen(RP, 0);
 RectFill(RP,  12, 16,  12+28, 16+13);
 SetAPen(RP, 1);
 RectFill(RP,  47, 16,  47+28, 16+13);
 SetAPen(RP, 2);
 RectFill(RP,  82, 16,  82+28, 16+13);
 SetAPen(RP, 3);
 RectFill(RP, 117, 16, 117+28, 16+13);
 SetAPen(RP, 4);
 RectFill(RP, 152, 16, 152+28, 16+13);
 SetAPen(RP, 5);
 RectFill(RP, 187, 16, 187+28, 16+13);
 SetAPen(RP, 6);
 RectFill(RP, 222, 16, 222+28, 16+13);
 SetAPen(RP, 7);
 RectFill(RP, 257, 16, 257+28, 16+13);

 LoadRGB4(&(MainScreen->ViewPort), palette, 8);
 RefreshGList(&CGadget1, ColourWindow, NULL, 8);

 flagi = TRUE;
 while(flagi)
      {struct Gadget       *g;
       struct IntuiMessage *msg;
       ULONG                class;

       Wait(1L << ColourWindow->UserPort->mp_SigBit);
       while(msg = (struct IntuiMessage *)GetMsg(ColourWindow->UserPort))
            {class = msg->Class;
             g     = (struct Gadget *)msg->IAddress;
             ReplyMsg((struct Message *)msg);

             switch(class) 
                   {case IDCMP_GADGETUP:    ColourMenu(g);
                                            break;

                    case IDCMP_CLOSEWINDOW: flagi = FALSE;
                                            break;
                   }
            }
      }

 {int i;

  for(i=0; i!=8; i++)
      palette[i] = GetRGB4(MainScreen->ViewPort.ColorMap, (long)i);
 }

 CloseColorWindow();
}


USHORT ColourMenu(struct Gadget *g)

{USHORT id;
 LONG   red;
 LONG   green;
 LONG   blue;
 ULONG  Colour;

 id = g->GadgetID;
 if (id > 100  &&  id < 109)
    {CGadget1.Flags = GFLG_GADGHBOX;
     CGadget2.Flags = GFLG_GADGHBOX;
     CGadget3.Flags = GFLG_GADGHBOX;
     CGadget4.Flags = GFLG_GADGHBOX;
     CGadget5.Flags = GFLG_GADGHBOX;
     CGadget6.Flags = GFLG_GADGHBOX;
     CGadget7.Flags = GFLG_GADGHBOX;
     CGadget8.Flags = GFLG_GADGHBOX;

     g->Flags |= GFLG_SELECTED;
     activec   = id - 101;
     RefreshGList(&CGadget1, ColourWindow, NULL, 8);
    }
  else
    {Colour =  GetRGB4(MainScreen->ViewPort.ColorMap, activec);
     red    = (long)((Colour>>8) & 0xf);
     green  = (long)((Colour>>4) & 0xf);
     blue   = (long)((Colour>>0) & 0xf);

     switch(id)
           {case 109: if (red!=15L)    red++;
                      break;

            case 110: if (red!=0L)     red--;
                      break;

            case 111: if (green!=15L)  green++;
                      break;

            case 112: if (green!=0L)   green--;
                      break;

            case 113: if (blue!=15L)   blue++;
                      break;

            case 114: if (blue!=0L)    blue--;
                      break;

            case 50:  LoadRGB4(&(MainScreen->ViewPort),defpalette,8L);
                      break;

            case 51:  LoadRGB4(&(MainScreen->ViewPort),oldpalette,8L);
                      break;
           }

     if (id>51) SetRGB4(&MainScreen->ViewPort, activec, red, green, blue);     
    }

 return(TRUE);
}


BOOL OpenColorWindow(int width,int height,UBYTE interlace,UBYTE hires)

{struct NewScreen ns;
 struct NewWindow nw;

 ta.ta_Name      = "topaz.font";
 ta.ta_YSize     =  8;
 ta.ta_Style     =  FS_NORMAL;
 ta.ta_Flags     =  FPF_ROMFONT | FPF_PROPORTIONAL | FPF_DESIGNED;

 ns.LeftEdge     =  0;
 ns.TopEdge      =  0;
 ns.Width        =  width;
 ns.Height       =  height;
 ns.Depth        =  3;
 ns.DetailPen    =  0;
 ns.BlockPen     =  1;
 ns.ViewModes    =  0;
 if (hires)      ns.ViewModes |= HIRES;
 if (interlace)  ns.ViewModes |= INTERLACE;
 ns.Type         =  CUSTOMSCREEN;
 ns.Font         = &ta;
 ns.DefaultTitle =  NULL;
 ns.Gadgets      =  NULL;
 ns.CustomBitMap =  NULL;

 MainScreen = OpenScreen(&ns);
 if (!MainScreen) return(FALSE);
 ShowTitle(MainScreen, FALSE);

 nw.LeftEdge    =  0;
 nw.TopEdge     =  0;
 nw.Width       =  width;
 nw.Height      =  height;
 nw.DetailPen   = (UBYTE)-1;
 nw.BlockPen    = (UBYTE)-1;
 nw.IDCMPFlags  =  IDCMP_GADGETUP     | IDCMP_CLOSEWINDOW;
 nw.Flags       =  WFLG_SIMPLE_REFRESH | WFLG_CLOSEGADGET | WFLG_ACTIVATE;
 nw.FirstGadget = &CGadget1;
 nw.CheckMark   =  NULL;
 nw.Title       =  NULL;
 nw.Screen      =  MainScreen;
 nw.BitMap      =  NULL;
 nw.MinWidth    =  0;
 nw.MinHeight   =  0;
 nw.MaxWidth    =  0;
 nw.MaxHeight   =  0;
 nw.Type        =  CUSTOMSCREEN;

 ColourWindow = (struct Window *)OpenWindow(&nw);
 if (!ColourWindow)
    {CloseScreen(MainScreen);
     return(FALSE);
    }

 tf = (struct TextFont *)OpenFont(&ta);
 if (tf)  SetFont(ColourWindow->RPort, tf);

 return(TRUE);
}


VOID CloseColorWindow(VOID)

{if (tf)  CloseFont(tf);
 tf = NULL;
 CloseWindow(ColourWindow);
 CloseScreen(MainScreen);
}
