#include <exec/types.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <dlg/msg.h>
#include <proto/dlg.h>

#include <pragmas/dlg.h>

extern struct Library *DLGBase;

long MakeSigArray(char *areafile,SHORT **sigarray,char mode)
{
   ULONG    size;
   SHORT    a;
   long     numrecords;
   SHORT   *array;
   FILE    *fp;
   struct   Msg_Area area;


   if (*sigarray)  free(*sigarray);
   *sigarray = NULL;

   if ((!mode) && !Stricmp(areafile,"MSG:Area.bbs"))  return(FALSE);
   if (mode && !Stricmp(areafile,"FILE:Area.bbs"))    return(FALSE);
   if (FileSize(areafile,&size)==-1)                  return(FALSE);

   numrecords = (long)(size/(long)sizeof(struct Msg_Area));

   if (!(*sigarray= (SHORT *) malloc( (numrecords*4) + 4)))  return(FALSE);

   if ((fp=fopen(areafile,"r"))==NULL)
   {
      free(*sigarray);
      return(FALSE);
   }

   array = *sigarray;

   for(a=0;a<numrecords;a++)
   {
      fread(&area,sizeof(struct Msg_Area),1,fp);
      array[a]=area.Number;
   }

   array[a] = 0;
   fclose(fp);
   return(numrecords);
}


BOOL CheckForSig(int number, SHORT *sigarray, int numrecords)
{
   SHORT a;

   for(a=0;a<numrecords;a++)
      if (sigarray[a]==number)
         return(TRUE);

   return(FALSE);
}
