#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <devices/tpt.h>

#include <dlg/dlg.h>
#include <dlg/portconfig.h>

#include <link/io.h>
#include <link/lang.h>

#include <proto/exec.h>
#include <proto/dos.h>
#include <proto/dlg.h>

#include <pragmas/dlg.h>

#include <private/Version.h>
#define  ObjRev "1"
const UBYTE version[]="\0$VER: TWindow " BUILDVER "." ObjRev " " COPYRIGHT " by Digerati Dreams "__AMIGADATE__;

void Usage(char *);
void CleanUp(char *);

BPTR            sout;
char          **SA;
struct Library *DLGBase = NULL;


void main(int argc,char **argv)

{long win;
 long retval;
 char *s;
 char  devname[4] = "";
 char  ocflag;
 char  filename[80];

 struct Global_Settings Globals;
 struct Port            MyPort;
 struct Displays        MyDisplay;

 sout    = Output();
 DLGBase = OpenLibrary(DLGNAME,DLGVERSION);
 if (!DLGBase)               CleanUp("Unable to open dlg.library");
 if (!(SA = getlang(NULL)))  CleanUp("Can't read language file");

 AFPrintf(NULL, sout, "\n");

 ocflag                    =   0;
 MyDisplay.Window.x        =   0;
 MyDisplay.Window.y        =  11;
 MyDisplay.Window.width    = 640;
 MyDisplay.Window.height   = 109;
 strcpy(MyDisplay.Window.fontname, "topaz");
 MyDisplay.Window.fontsize =   8;
 MyDisplay.Window.flags    =   0;

 while(--argc>0)
      {s = *++argv;

       if (*s++ == '-')
          {while(*s)
                {switch(*s++)
                       {case 'o':
                        case 'O':  if (ocflag)  Usage(SA[3238]);
                                   ocflag = 1;
                                   win    = WOPEN;
                                   break;

                        case 'c':
                        case 'C':  if (ocflag)  Usage(SA[3238]);
                                   ocflag = 1;
                                   win    = WCLOSE;
                                   break;

                        case 'p':
                        case 'P':  if (!--argc)  break;
                                   strncpy(devname,*++argv,3);
                                   devname[3] = 0;
                                   Upper(devname);

                                   sprintf(filename,"DlgConfig:Port/%s.port",devname);
                                   if (GetFirstStruct(filename,(char *)&MyPort,sizeof(MyPort))!=-1)
                                      {sprintf(filename,"DlgConfig:Port/%s",MyPort.GlobalFile);
                                       if (GetFirstStruct(filename,(char *)&Globals,sizeof(Globals))!=-1)
                                          {sprintf(filename,"DlgConfig:Port/%s",MyPort.DisplayFile);
                                           GetFirstStruct(filename,(char *)&MyDisplay,sizeof(MyDisplay));
                                          }
                                      }
                                   break;

                        case 'x':
                        case 'X':  if (!--argc)  break;
                                   MyDisplay.Window.x=atoi(*++argv);
                                   break;

                        case 'y':
                        case 'Y':  if (!--argc)  break;
                                   MyDisplay.Window.y=atoi(*++argv);
                                   break;

                        case 'w':
                        case 'W':  if (!--argc)  break;
                                   MyDisplay.Window.width=atoi(*++argv);
                                   break;

                        case 'h':
                        case 'H':  if (!--argc)  break;
                                   MyDisplay.Window.height=atoi(*++argv);
                                   break;

                        case 'b':
                        case 'B':  MyDisplay.Window.flags=DISP_BKGRND;
                                   break;

                        case 'f':
                        case 'F':  if (!--argc)  break;
                                   strcpy(MyDisplay.Window.fontname,*++argv);
                                   if (strcmp(MyDisplay.Window.fontname+(strlen(MyDisplay.Window.fontname)-5),".font"))
                                       strcat(MyDisplay.Window.fontname,".font");
                                   break;

                        case 's':
                        case 'S':  if (!--argc)  break;
                                   MyDisplay.Window.fontsize=atoi(*++argv);
                                   break;
                       }
                }
          }
      }
 if (!devname[0])  Usage(SA[3239]);
 if (!ocflag)      Usage(SA[3238]);

 retval = TWindow(win,&(MyDisplay.Window),devname);
 if (retval==ACTIVERR)
     CleanUp(SA[3240]);
   else
     if (retval==WINOPENERR)
         CleanUp(SA[3241]);
        else
         if (retval==WINCLOSEDERR)
             CleanUp(SA[3242]);
           else
             if (retval==SCROPENERR)
                 CleanUp(SA[3243]);
               else
                 if (retval==GENERALERR)
                     CleanUp(SA[3244]);
                   else
                     if ((win==TPOPWIND) && (retval & T_WINDOW))
                          AFPrintf(NULL, sout, SA[3245]);
                        else
                          if ((win==TCLOSEWIND) && (retval & ~T_WINDOW))
                               AFPrintf(NULL, sout, SA[3246]);

 CleanUp(NULL);
}


void Usage(char *string)

{
 AFPrintf(NULL, sout, SA[3247],string);
 AFPrintf(NULL, sout, SA[3248]);
 AFPrintf(NULL, sout, SA[3249]);
 AFPrintf(NULL, sout, SA[3250]);
 AFPrintf(NULL, sout, SA[3251]);
 AFPrintf(NULL, sout, SA[3252]);
 AFPrintf(NULL, sout, SA[3253]);
 AFPrintf(NULL, sout, SA[3254]);
 AFPrintf(NULL, sout, SA[3255]);
 AFPrintf(NULL, sout, SA[3256]);
 AFPrintf(NULL, sout, SA[3257]);
 AFPrintf(NULL, sout, SA[3258]);
 AFPrintf(NULL, sout, SA[3259]);
 AFPrintf(NULL, sout, SA[3260]);

 CleanUp(NULL);
}


void CleanUp(char *s)

{if (DLGBase)  CloseLibrary(DLGBase);

 if (s)
    {Write(sout, "\n Error: ", 9);
     Write(sout,  s,    strlen(s));
     Write(sout, "\n\n",       2);
    }

 exit(s?5:0);
}
