#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <devices/tpt.h>

#include <dlg/dlg.h>

#include <link/io.h>
#include <link/lang.h>

#include <proto/exec.h>
#include <proto/dos.h>
#include <proto/dlg.h>

#include <pragmas/dlg.h>

#include <private/Version.h>
#define  ObjRev "1"
const UBYTE version[]="\0$VER: TFreeze " BUILDVER "." ObjRev " " COPYRIGHT " by Digerati Dreams "__AMIGADATE__;

void Usage(char *);
void CleanUp(char *);

BPTR            sout;
char          **SA;
struct Library *DLGBase = NULL;


void main(int argc, char **argv)

{
   long  retval;
   char *s;
   char  devname[4] = "";

   sout    = Output();
   DLGBase = OpenLibrary(DLGNAME, DLGVERSION);
   if (!DLGBase)
      CleanUp("Unable to open dlg.library");
   if (!(SA = getlang(NULL)))
      CleanUp("Can't read language file");

// DB("Initialized OK");

   AFPrintf(NULL, sout, "\n");

   while(--argc > 0)
   {
      s = *++argv;

      if (*s++ == '-')
      {
         while(*s)
         {
            switch(*s++)
            {
               case 'P':
               case 'p':  if (!--argc)  break;
               strncpy(devname,*++argv,3);
               devname[3] = 0;
               Upper(devname);
               break;
            }
         }
      }
   }

// DB("Loaded argument info");

   if (!devname[0])  Usage(SA[3126]);

//   retval=SendCtlMsg(TFREEZE,0,devname);

   retval=TFreeze(devname);

// DB("Returned from TFreeze()");

   if (retval==ACTIVERR)
   {
      AFPrintf(NULL, sout, SA[3127]);
   }
   else
   {
      if (retval==GENERALERR)
      {
         AFPrintf(NULL, sout, SA[3128]);
      }
   }

// DB("Cleaning up");

   AFPrintf(NULL, sout, "\n");
   CleanUp(NULL);
}


void Usage(char *string)
{
   AFPrintf(NULL, sout, SA[3129],string);
   AFPrintf(NULL, sout, SA[3130]);
   CleanUp(NULL);
}


void CleanUp(char *s)
{
   if (DLGBase)  CloseLibrary(DLGBase);

   if (s)
   {
      Write(sout, "\n Error: ", 9);
      Write(sout,  s,    strlen(s));
      Write(sout, "\n\n",       2);
   }

   exit(s?5:0);
}
