#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <devices/tpt.h>

#include <dlg/dlg.h>

#include <link/io.h>
#include <link/lang.h>

#include <proto/exec.h>
#include <proto/dos.h>
#include <proto/dlg.h>

#include <pragmas/dlg.h>

#include <private/Version.h>
#define  ObjRev "1"
const UBYTE version[]="\0$VER: TColors " BUILDVER "." ObjRev " " COPYRIGHT " by Digerati Dreams "__AMIGADATE__;

void Usage(char *);
void CleanUp(char *);

BPTR            sout;
char          **SA;
struct Library *DLGBase=NULL;

unsigned short colortable[8];
long           ct[8] = {0x000,0xf00,0x0f0,0xff0,0x00f,0xf0f,0x0ff,0xfff};


void main(int argc,char **argv)

{long  retval;
 char *s;
 char  devname[4] = "";
 int   count;

 sout    = Output();
 DLGBase = OpenLibrary(DLGNAME,DLGVERSION);
 if (!DLGBase)               CleanUp("Unable to open dlg.library");
 if (!(SA = getlang(NULL)))  CleanUp("Can't read language file");


 AFPrintf(NULL, sout, "\n");

 while(--argc>0)
      {s = *++argv;

       if (*s++ == '-')
          {while(*s)
                {switch(*s++)
                       {case 'P':
                        case 'p':  if (!--argc)  break;
                                   strncpy(devname,*++argv,3);
                                   devname[3] = 0;
                              Upper(devname);
                                   break;

                        case 'C':
                        case 'c':  if (!--argc)  break;
                                   sscanf(*++argv,"%x%x%x%x%x%x%x%x",ct,ct+1,ct+2,ct+3,ct+4,ct+5,ct+6,ct+7);
                                   break;
                       }
                }
          }
      }
 if (!devname[0])  Usage(SA[3054]);

 for(count = 0; count < 8; count++)
     colortable[count] = ct[count];

 retval = TColors(colortable,devname);
 if (retval==NOERR)
     AFPrintf(NULL, sout, SA[3055]);
   else
     if (retval==ACTIVERR)
         AFPrintf(NULL, sout, SA[3056]);
       else
         if (retval==GENERALERR)
             AFPrintf(NULL, sout, SA[3057]);
           else
             AFPrintf(NULL, sout, SA[3058]);

 AFPrintf(NULL, sout, "\n");
 CleanUp(NULL);
}


void Usage(char *string)

{
 AFPrintf(NULL, sout, SA[3059],string);
 AFPrintf(NULL, sout, SA[3060]);
 AFPrintf(NULL, sout, SA[3061]);
 AFPrintf(NULL, sout, SA[3062]);
 AFPrintf(NULL, sout, SA[3063]);
 AFPrintf(NULL, sout, SA[3064]);
 AFPrintf(NULL, sout, SA[3065]);
 AFPrintf(NULL, sout, SA[3066]);

 CleanUp(NULL);
}


void CleanUp(char *s)

{if (DLGBase)  CloseLibrary(DLGBase);

 if (s)
    {Write(sout, "\n Error: ", 9);
     Write(sout,  s,    strlen(s));
     Write(sout, "\n\n",       2);
    }

 exit(s?5:0);
}
