#include "DLGTick.h"

#include <link/io.h>

#define BUFSIZE 5000

/* function returns the CRC in an unusual fasion so that function success can be
   returned accurately in the return code */

FileCRC(char *file,ULONG *outCRC)
{
   unsigned char *buffer;
   BPTR fh;
   int i;
   ULONG CRC=0;
   int rc=0;

   buffer = calloc(BUFSIZE,1);

   if(!buffer)
   {
      Log(" ! No memory for CRC buffer");
      return(rc);
   }

   fh=Open(file,MODE_OLDFILE);

   if(fh)
   {
      while(1)
      {
         i=Read(fh,buffer,BUFSIZE);

         if(i)
         {
            CRC=CalcCRC(buffer,i,CRC);
         }

         if(i!=BUFSIZE) break;
      }

      Close(fh);

      *outCRC=CRC;
      rc=1;
   }
   else
   {
      Log(" ! Can't open file to perform CRC check!");
      AFPrintf(NULL,sout,"Can't open file %s to calculate CRC\n",file);
      *outCRC=0;
      rc=0;
   }

   free(buffer);
   return(rc);
}


