#include "DLGTick.h"

#include <link/io.h>

struct TICAREA *TicArea = NULL;


// -------------------- //

///   LoadConfig
int LoadConfig(void)
{
   BOOL ShowArea = FALSE;

   BPTR fh = NULL;

   char t[1000];
   char PreList[500] = "";
   char PostList[500] = "";
   char Uploader[128] = "DLGTick";

   int  i;
   int  a = 0;

   unsigned long cnt = 0;


///   Open DLGMail.TIC
   fh = Open("FIDO:DLGMail.TIC",MODE_OLDFILE);

   if(!fh)
   {
      Log(" ! Error: Could not open Fido:DLGMail.TIC!");
      return(0);
   }
//-

///   Loop through config file and count areas.
   while (FGets(fh, t, 999))
   {
      char *par[20];

      Chk_Abort();

      strcpy(t, stpblk(t));

      if (strlen(t) == 0)  continue;         // Skip empty lines

      if (!Strnicmp(t, ";", 1)) continue;    // Skip comments

      ArgParse(t, par, 19);

      if (!Stricmp(par[0], "AREA") ||  !Stricmp(par[0], "IGNORE"))
      {
         a++;
         continue;
      }
   }
//-

///   Don't bother if no areas
   if(a == 0)
   {
      Close(fh);
      return(0);
   }
//-

///   Allocate memory for tick areas and initialize each area.

//   AFPrintf(NULL,sout,"Found %ld areas.\n",a);

   TicArea = calloc(a,sizeof(struct TICAREA));

   if(TicArea == NULL)
   {
      Log(" ! Insufficient memory to load config!");
      Close(fh);
      return(FALSE);
   }

   for(i = 0; i < a; i++)
   {
      strcpy(TicArea[i].AreaName,"");
      TicArea[i].Class = 0;
      strcpy(TicArea[i].Desc,"");
      TicArea[i].Purge = FALSE;
      TicArea[i].Replace = FALSE;
      TicArea[i].Loc = FALSE;
      TicArea[i].Pass = TRUE;
      TicArea[i].DLGArea = 0;
      TicArea[i].Ignore = FALSE;
      strcpy(TicArea[i].UseAddress,"");
   }
//-

   Seek(fh,0,OFFSET_BEGINNING);
   i = -1;

///   Loop through config file and parse it
   while (FGets(fh, t, 999))
   {
      char *par[20];
      char *dup;
      int   c;

      Chk_Abort();
      cnt++;
      strcpy(t, stpblk(t));
      if (strlen(t) == 0)  continue;         // Skip empty lines
      if (!Strnicmp(t, ";", 1)) continue;    // Skip comments
      dup = strdup(t);
      c = ArgParse(t, par, 19);

///      SHOWAREA (global)
      if(!Stricmp(par[0],"SHOWAREA"))
      {
         if(c < 2)
         {
            AFPrintf(NULL,sout,".TIC config syntax error on line %ld: too few arguments!\n",cnt);
            ASPrintf(NULL,logstring," ! .TIC config syntax error on line %ld: too few arguments!",cnt);
            Log(logstring);
            Close(fh);
            return(0);
         }

         if(atoi(par[1]))
         {
            ShowArea = TRUE;
         }
         else
         {
            ShowArea = FALSE;
         }

         continue;
      }
//-

///      UPLOADER (global)
      if(!Stricmp(par[0], "UPLOADER"))
      {
         BOOL inul = FALSE;
         char *d;
         int k;
         int j = 0;

         if(c < 2)
         {
            AFPrintf(NULL,sout,".TIC config syntax error on line %ld: too few arguments!\n",cnt);
            ASPrintf(NULL,logstring," ! .TIC config syntax error on line %ld: too few arguments!",cnt);
            Log(logstring);
            Close(fh);
            return(0);
         }

         d = strdup(dup);

         for(k=8;k<strlen(dup);k++)
         {
            if(inul)
            {
               if((dup[k] == '\n')  || (dup[k] == ';'))
               {
                  d[j] = '\0';
                  break;
               }

               d[j] = dup[k];
               j++;
            }
            else
            {
               if(isspace(dup[k]))
               {
                  continue;
               }
               else
               {
                  inul = TRUE;
                  d[j] = dup[k];
                  j++;
               }
            }
         }

         strcpy(Uploader,d);
         continue;
      }
//-

///      PRELIST (global)
      if(!Stricmp(par[0], "PRELIST"))
      {
         BOOL inpre = FALSE;
         char *d;
         int k;
         int j = 0;

         if(c < 2)
         {
            AFPrintf(NULL,sout,".TIC config syntax error on line %ld: too few arguments!\n",cnt);
            ASPrintf(NULL,logstring," ! .TIC config syntax error on line %ld: too few arguments!",cnt);
            Log(logstring);
            Close(fh);
            return(0);
         }

         d = strdup(dup);

         for(k=7;k<strlen(dup);k++)
         {
            if(inpre)
            {
               if((dup[k] == '\n')  || (dup[k] == ';'))
               {
                  d[j] = '\0';
                  break;
               }

               d[j] = dup[k];
               j++;
            }
            else
            {
               if( isspace(dup[k]))
               {
                  continue;
               }
               else
               {
                  inpre = TRUE;
                  d[j] = dup[k];
                  j++;
               }
            }
         }

         strcpy(PreList,d);
         continue;
      }
//-

///      POSTLIST (global)
      if(!Stricmp(par[0], "POSTLIST"))
      {
         BOOL inpost = FALSE;
         char *d;
         int k;
         int j = 0;

         if(c < 2)
         {
            AFPrintf(NULL,sout,".TIC config syntax error on line %ld: too few arguments!\n",cnt);
            ASPrintf(NULL,logstring," ! .TIC config syntax error on line %ld: too few arguments!",cnt);
            Log(logstring);
            Close(fh);
            return(0);
         }

         d = strdup(dup);

         for(k=8;k<strlen(dup);k++)
         {
            if(inpost)
            {
               if((dup[k] == '\n')  || (dup[k] == ';'))
               {
                  d[j] = '\0';
                  break;
               }

               d[j] = dup[k];
               j++;
            }
            else
            {
               if( isspace(dup[k]))
               {
                  continue;
               }
               else
               {
                  inpost = TRUE;
                  d[j] = dup[k];
                  j++;
               }
            }
         }

         strcpy(PostList,d);
         continue;
      }
//-

///      AREA
      if (!Stricmp(par[0], "AREA"))
      {

         if(c < 2)
         {
            AFPrintf(NULL,sout,".TIC config syntax error on line %ld: too few arguments!\n",cnt);
            ASPrintf(NULL,logstring," ! .TIC config syntax error on line %ld: too few arguments!",cnt);
            Log(logstring);
            Close(fh);
            return(0);
         }

         i++;

         if(strlen(PreList))
            strcpy(TicArea[i].PreList,PreList);
         else
            strcpy(TicArea[i].PreList,"");

         if(strlen(PostList))
            strcpy(TicArea[i].PostList,PostList);
         else
            strcpy(TicArea[i].PostList,"");

         if(strlen(Uploader))
            strcpy(TicArea[i].Uploader,Uploader);
         else
            strcpy(TicArea[i].Uploader,"");

         TicArea[i].ShowArea = ShowArea;
         strcpy(TicArea[i].AreaName,par[1]);

///      CLASS
         if(c > 2)
         {
            if(c != 4)
            {
               AFPrintf(NULL,sout,".TIC config syntax error on line %ld: too few arguments!\n",cnt);
               ASPrintf(NULL,logstring," ! .TIC config syntax error on line %ld: too few arguments!",cnt);
               Log(logstring);
               Close(fh);
               return(0);
            }

            if(Stricmp(par[2],"CLASS"))
            {
               AFPrintf(NULL,sout,".TIC config syntax error on line %ld: wrong keyword with AREA!\n",cnt);
               ASPrintf(NULL,logstring," ! .TIC config syntax error on line %ld: wrong keyword with AREA!",cnt);
               Log(logstring);
               Close(fh);
               return(0);
            }

            TicArea[i].Class = atoi(par[3]);
         }
//-
         continue;
      }
//-

///      DESC
      if(!Stricmp(par[0], "DESC"))
      {
         BOOL indesc = FALSE;
         char *d;
         int k;
         int j = 0;

         if(c < 2)
         {
            AFPrintf(NULL,sout,".TIC config syntax error on line %ld: too few arguments!\n",cnt);
            ASPrintf(NULL,logstring," ! .TIC config syntax error on line %ld: too few arguments!",cnt);
            Log(logstring);
            Close(fh);
            return(0);
         }

         d = strdup(dup);

         for(k=4;k<strlen(dup);k++)
         {
            if(indesc)
            {
               if((dup[k] == '\n')  || (dup[k] == ';'))
               {
                  d[j] = '\0';
                  break;
               }

               d[j] = dup[k];
               j++;
            }
            else
            {
               if( isspace(dup[k]))
               {
                  continue;
               }
               else
               {
                  indesc = TRUE;
                  d[j] = dup[k];
                  j++;
               }
            }
         }

         strcpy(TicArea[i].Desc,d);
         continue;
      }
//-

///      PURGE
      if(!Stricmp(par[0],"PURGE"))
      {
         TicArea[i].Purge = TRUE;
         continue;
      }
//-

///      REPLACE
      if(!Stricmp(par[0],"REPLACE"))
      {
         TicArea[i].Replace = TRUE;
         continue;
      }
//-

///      LOCALAREA or COPYAREA
      if(!Stricmp(par[0],"LOCALAREA") || !Stricmp(par[0],"COPYAREA"))
      {
         if(c < 2)
         {
            AFPrintf(NULL,sout,".TIC config syntax error on line %ld: too few arguments!\n",cnt);
            ASPrintf(NULL,logstring," ! .TIC config syntax error on line %ld: too few arguments!",cnt);
            Log(logstring);
            Close(fh);
            return(0);
         }

         TicArea[i].DLGArea = atol(par[1]);

         if(TicArea[i].DLGArea == 0)
         {
            AFPrintf(NULL,sout,".TIC config syntax error on line %ld: Non-numeric value for LOCAL/COPYAREA!\n",cnt);
            ASPrintf(NULL,logstring," ! .TIC config syntax error on line %ld: Non-numeric value for LOCAL/COPYAREA!",cnt);
            Log(logstring);
            Close(fh);
            return(0);
         }

         if(c == 3)
         {
            if(!Stricmp(par[2],"F"))
            {
               TicArea[i].Free = TRUE;
            }
         }

         if(!Stricmp(par[0],"LOCALAREA"))
         {
            TicArea[i].Loc = TRUE;
            TicArea[i].Pass = FALSE;
         }
         else  // Must be copyarea
         {
            TicArea[i].Loc = TRUE;
            TicArea[i].Pass = TRUE;
         }

         continue;
      }
//-

///      TO
      if(!Stricmp(par[0],"TO"))
      {
         if(c < 3)
         {
            AFPrintf(NULL,sout,"Incorrect number of arguments on line %ld!\n",cnt);
            ASPrintf(NULL,logstring," ! Incorrect number of arguments on line %ld!",cnt);
            Log(logstring);
            Close(fh);
            return(0);
         }

         if(!DLGPatternMatch("*:*/*",par[1]))
         {
            AFPrintf(NULL,sout,".TIC config syntax error on line %ld, incomplete TO address!\n",cnt);
            ASPrintf(NULL,logstring," ! .TIC config syntax error on line %ld, incomplete TO address!",cnt);
            Log(logstring);
            Close(fh);
            return(0);
         }
      }
//-

///      USEADDR
      if(!Stricmp(par[0],"USEADDR"))
      {
         if(c < 2)
         {
            AFPrintf(NULL,sout,"Incorrect number of arguments on line %ld!\n",cnt);
            ASPrintf(NULL,logstring," ! Incorrect number of arguments on line %ld!",cnt);
            Log(logstring);
            Close(fh);
            return(0);
         }

         if(!DLGPatternMatch("*:*/*",par[1]))
         {
            AFPrintf(NULL,sout,".TIC config syntax error on line %ld, incomplete USEADDR address!\n",cnt);
            ASPrintf(NULL,logstring," ! .TIC config syntax error on line %ld, incomplete USEADDR address!",cnt);
            Log(logstring);
            Close(fh);
            return(0);
         }

         strcpy(TicArea[i].UseAddress,par[1]);
      }
//-

///      ANNOUNCE
      if(!Stricmp(par[0], "ANNOUNCE"))
      {
         if(c < 2)
         {
            AFPrintf(NULL,sout,".TIC config syntax error on line %ld: too few arguments!\n",cnt);
            ASPrintf(NULL,logstring," ! .TIC config syntax error on line %ld: too few arguments!",cnt);
            Log(logstring);
            Close(fh);
            return(0);
         }

         continue;
      }
//-

///      EXECUTE
      if(!Stricmp(par[0], "EXECUTE"))
      {
         BOOL inex = FALSE;
         char *d;
         int k;
         int j = 0;

         if(c < 2)
         {
            AFPrintf(NULL,sout,".TIC config syntax error on line %ld: too few arguments!\n",cnt);
            ASPrintf(NULL,logstring," ! .TIC config syntax error on line %ld: too few arguments!",cnt);
            Log(logstring);
            Close(fh);
            return(0);
         }

         d = strdup(dup);

         for(k=7;k<strlen(dup);k++)
         {
            if(inex)
            {
               if((dup[k] == '\n')  || (dup[k] == ';'))
               {
                  d[j] = '\0';
                  break;
               }

               d[j] = dup[k];
               j++;
            }
            else
            {
               if( isspace(dup[k]))
               {
                  continue;
               }
               else
               {
                  inex = TRUE;
                  d[j] = dup[k];
                  j++;
               }
            }
         }

         strcpy(TicArea[i].Execute,d);
         continue;
      }
//-

///      IGNORE
      if(!Stricmp(par[0],"IGNORE"))
      {
         if(c < 2)
         {
            AFPrintf(NULL,sout,".TIC config syntax error on line %ld: too few arguments!\n",cnt);
            ASPrintf(NULL,logstring," ! .TIC config syntax error on line %ld: too few arguments!",cnt);
            Log(logstring);
            Close(fh);
            return(0);
         }

         i++;
         TicArea[i].Ignore = TRUE;
         strcpy(TicArea[i].AreaName,par[1]);
         continue;
      }
//-

   }
//-

   if(fh) Close(fh);
   return(a);

}
//-

///   PrintConfig
void  PrintConfig(void)
{
   int i;

   for(i = 0; i < Areas; i++)
   {
      Chk_Abort();

      AFPrintf(NULL,sout,"Area [%ld] %s\n",i,TicArea[i].AreaName);

      if(TicArea[i].Ignore == TRUE)
      {
         AFPrintf(NULL,sout,"\tIgnore TICs\n");
      }
      else
      {
         AFPrintf(NULL,sout,"\tClass %ld\n",TicArea[i].Class);

         if(TicArea[i].Desc)
            AFPrintf(NULL,sout,"\tDescription: \"%s\"\n",TicArea[i].Desc);
         else
            AFPrintf(NULL,sout,"\tNo description");

         if(TicArea[i].Purge)
            AFPrintf(NULL,sout,"\tPurgable\n");

         if(TicArea[i].Replace)
            AFPrintf(NULL,sout,"\tReplace dupe files\n");

         if(TicArea[i].Loc)
            AFPrintf(NULL,sout,"\tStore files in local filebase\n");

         if(TicArea[i].Pass)
            AFPrintf(NULL,sout,"\tStore files in passthrough directory\n");

         if(TicArea[i].DLGArea)
            AFPrintf(NULL,sout,"\tStore files in file area %ld\n",TicArea[i].DLGArea);
         else
            AFPrintf(NULL,sout,"\tWill not be stored locally\n");

         if(TicArea[i].Free)
            AFPrintf(NULL,sout,"\tFREE flag set\n");

         if(TicArea[i].PreList)
            AFPrintf(NULL,sout,"\tPrelist: %s\n",TicArea[i].PreList);

         if(TicArea[i].PostList)
            AFPrintf(NULL,sout,"\tPostlist: %s\n",TicArea[i].PostList);

         if(TicArea[i].Uploader)
            AFPrintf(NULL,sout,"\tUploader: %s\n",TicArea[i].Uploader);

         if(TicArea[i].ShowArea)
            AFPrintf(NULL,sout,"\tWill show area in file descriptions\n");
         else
            AFPrintf(NULL,sout,"\tWill NOT show area in file descriptions\n");
      }
   }
   return;
}
//-

///   GetEcho()
int GetEcho(char *Tag)
{
   /* GetEcho()
   **
   ** Input: the tag name of the area we want to find
   **
   ** Return: the index in the TicArea array of the echo, or -1 if
   **         it could not be found.
   **/

   int i;

   for(i = 0; i < Areas; i++)
   {
      if(!Stricmp(TicArea[i].AreaName,Tag))
      {
         return(i);
      }
   }

   return(-1);
}
//-

///   GetAddr
struct TicAddr *GetAddr(char *Address, char *Echo)
{
   BOOL InArea = FALSE;
   BOOL Found = FALSE;

   BPTR fh = NULL;

   char t[1000];

   struct TicAddr *Addr;


///   Open DLGMail.TIC
   fh = Open("FIDO:DLGMail.TIC",MODE_OLDFILE);

   if(!fh)
   {
      Log(" ! Error: Could not open Fido:DLGMail.TIC!");
      return(NULL);
   }
//-

   Addr = calloc(1,sizeof(struct TicAddr));

   if(Addr == NULL)
   {
      Log(" ! GetAddr: Insufficient memory!");
      Close(fh);
      return(NULL);
   }

///   Loop through config file and parse it
   while (FGets(fh, t, 999))
   {
      char *par[20];

      Chk_Abort();
      strcpy(t, stpblk(t));
      if (strlen(t) == 0)  continue;         // Skip empty lines
      if (!Strnicmp(t, ";", 1)) continue;    // Skip comments
      ArgParse(t, par, 19);

///      AREA
      if (!Stricmp(par[0], "AREA"))
      {
         if(InArea)
            break;

         if(!Stricmp(par[1],Echo))
            InArea = TRUE;

         continue;

      }
//-

///      TO
      if(!Stricmp(par[0],"TO"))
      {
         BOOL REV = FALSE;
         BOOL HAT = FALSE;
         char f = '!';
         int j;

         if(!InArea)
            continue;

         if(!CompareFidoAddress(par[1],Address)) continue;

         Upper(par[2]);

///      Go through par[2] and parse it
         for(j = 0; j < strlen(par[2]); j++)
         {
///         Switch on par[2][j]
            switch (par[2][j])
            {
               case 'C':
                  f = 'C';
                  break;

               case 'N':
               case 'F':
                  f = 'F';
                  break;

               case 'D':
                  f = 'D';
                  break;

               case 'H':
                  f = 'H';
                  break;

               case '*':
                  f = '*';
                  break;

               case 'W':
               case 'R':
                  REV = TRUE;
                  break;

               case '+':
                  HAT = TRUE;
                  break;

               default:
                  ASPrintf(NULL,logstring," ! GetAddr(): Unrecognized routing flag: [%c]\n",par[2][j]);
                  Log(logstring);
                  break;
            }
//-
         }
//-

///      Shut down if garbage
         if(f == '!')
         {
            Log(" ! .TIC file syntax error, no routing information!");
            Close(fh);
            free(Addr);
            return(NULL);
         }
//-

         strcpy(Addr->Address,par[1]);
         Addr->Flavor = f;
         Addr->Reverse = REV;
         Addr->Hatch = HAT;

         Found = TRUE;
         break;
      }
//-

///      IGNORE
      if(!Stricmp(par[0],"IGNORE"))
      {
         if(InArea)
            break;
         continue;
      }
//-

   }
//-

   if(fh) Close(fh);

   if(Found)
      return(Addr);
   else
      return(NULL);

}
//-


