#include <exec/types.h>
#include <string.h>
#include <stdio.h>
#include <dos.h>

#include "Protos.h"
#include "Defines.h"
#include "Includes.h"
#include "Version.h"
#include "Vars.h"
#include "gc_parse.h"
#include "/ross/protos.h"

#include <link/io.h>

struct GConfig *GCFG;
char *GCFG_block;
int GCFG_size;


/****global ONLY to this module*******/
BOOL sp_pointnet=FALSE;
int sp_address_total=0;
char sp_address[TOTALAKAS][20];
char sp_pointnetaddress[20];
char sp_tear[80];
char sp_origin[88];
/*************************************/

#define AREAFILENAME "FIDO:DLGMail.ARE"

/// LoadConfig
int LoadConfig(void)
{
   int i;
   //int j;
   int how;

   if(GCFG==NULL)
   {
      how=0;
      GCFG_size=sizeof(struct GConfig)+100;
      GCFG_block=(void *)AllocMem(GCFG_size,MEMF_PUBLIC | MEMF_CLEAR);
   
      if(GCFG_block)
      {
         GCFG=(void *)GCFG_block;
      }
      else
      {
         return(GCERROR_NO_MEMORY);
      }
   }
   else
   {
            how=1;
   }

   GCFG->MARKER1=5551212;
   GCFG->MARKER2=5551212;

   _LEGIT=33;

   i=LoadStruct(how);

   if(!i)
   {
      if(i=CheckArchivers())
         DisplayErrReq(NULL,"You must correct archiver installation(s)/path(s)","Before DLGMail will run");
   }     

   return i;
}
//-

/// __LoadARE
int __LoadARE()
{
   int i;

   if(_ROSSAREAS)
      __UnLoadARE();

   i=LoadUpAreas();
   if(!i)
   {
      DisplayErrReq(NULL,"Repair your FIDO:DLGMail.ARE file","before relaunching DLGMail");
      return 0;
   }
}
//-

/// __UnLoadARE
int __UnLoadARE()
{
   if(_ROSSAREAS)
   {
      new_delete_areas(_ROSSAREAS);
      _ROSSAREAS=0;
      _AREACRC=0;
   }
   return 1;
}
//-

/// ClearStructLoadFlags
int ClearStructLoadFlags(void)
{
   int i;

   for(i=0;*gcp[i].gcp_keyword != NULL;i++)
      gcp[i].gcp_set=-666;

   sp_pointnet=FALSE;
   sp_address_total=0;
   *sp_pointnetaddress=NULL;
   *sp_tear=NULL;
   *sp_origin=NULL;

   _POINTNET=0;
   _STRIPPOINTNET=0;

   return 0;

}
//-

int SHITHEADPROTECTION=1;

/// RedFace1
int RedFace1()
{
   char *r;

   r=sp_tear;
   *r='I'+10; r++;
   *r='m'+10; r++;
   *r=' '+10; r++;
   *r='a'+10; r++;
   *r=' '+10; r++;
   *r='d'+10; r++;
   *r='i'+10; r++;
   *r='c'+10; r++;
   *r='k'+10; r++;
   *r='!'+10; r++;
   *r=0;

   r=sp_tear;
   while(*r)
   {
      *r-=10;
      r++;
   }
   SHITHEADPROTECTION=1;
   return 1;
}
//-

/// LoadStruct
int LoadStruct(int how) /* 0 for fresh, 1 for reload */
{
   int rc=LS_NO_ERROR;
   BPTR fp;
   BPTR ef;
   char *s;
   char *p;
   char *args;
   char buffer[200];
   int numval;
   char stufferror[100];
   char token[100];

   int i;

   DeleteFile(CFGERRFILE);

   ClearStructLoadFlags();

   fp=Open(CONFIGFILENAME,MODE_OLDFILE);

   if(fp)
   {
      while(1)
      {
         /* read/parse this puppy in */

         s=FGets(fp,buffer,sizeof(buffer));
         if(!s) break; /* EOF */

         s=buffer;
         if(*s==';') continue;   /* comment */
         if(*s=='\n') continue;  /* empty line */

         s[strlen(s)-1]=NULL; /* remove the newline */

         p=strchr(s,';');
         if(p) *p=NULL;    /* remove comments from lines */

         s=stpblk(s);      /* remove leading blanks */
         if(! *s) continue;   /* we've removed everything in the line! */



         /* parse the line here */

         s=stptok(s,token,sizeof(token)," \t"); /* break out the keyword */
         if(*s)
            s=stpblk(s);
         if(*s)
         {
            /* we have arguments */
            numval=atoi(s);
            args=s;
         }
         else
         {
            numval=0;
            *args=NULL;
         }

         /* we have the token, string args and integer value */

         i=StuffStruct(token,args,numval,stufferror);
         if(*stufferror)
         {
            ef=Open(CFGERRFILE,MODE_READWRITE);
            if(ef)
            {
               Seek(ef,0,OFFSET_END);
               AFPrintf(NULL,ef,"%s",stufferror);
               Close(ef);
            }
         }
      }
      Close(fp);

      /* check to see that we have entries for everything */

      for(i=0;*gcp[i].gcp_keyword != NULL;i++)
      {
         if(gcp[i].gcp_set==7734) continue; /* we've set all these */

         if(gcp[i].gcp_set==-666 && gcp[i].gcp_handler==HND_DEFAULT && (gcp[i].gcp_flag_mandatory==GCP_DEFAULT || gcp[i].gcp_flag_mandatory==GCP_OVERRIDE))
         {
            if(gcp[i].gcp_flag_string) /* string */
            {
               PutCFGString(i,gcp[i].gcp_offset,gcp[i].gcp_default_string);
            }
            else
            {
               PutCFGNumber(i,gcp[i].gcp_offset,gcp[i].gcp_default_numeric);
            }
            continue;
         }
      }

      for(i=0;*gcp[i].gcp_keyword != NULL;i++)
      {
         if(gcp[i].gcp_handler==HND_DEBUG)
         {
            if(gcp[i].gcp_set==-666)
               PutCFGNumber(i,gcp[i].gcp_offset,_MyDEBUG);
            else
            {
               PutCFGNumber(i,gcp[i].gcp_offset,gcp[i].gcp_set);
            }
         }

         if(gcp[i].gcp_handler==HND_NOLOG)
         {
            if(gcp[i].gcp_set==-666)
               PutCFGNumber(i,gcp[i].gcp_offset,_NLALL);
            else
            {
               PutCFGNumber(i,gcp[i].gcp_offset,gcp[i].gcp_set);
            }
         }

         if(gcp[i].gcp_handler==HND_STEALTH)
         {
            if(_PROCESSWINDOW==0)
               PutCFGNumber(i,gcp[i].gcp_offset,_PROCESSWINDOW);
            else
            {
               if(gcp[i].gcp_set==-666)
                  PutCFGNumber(i,gcp[i].gcp_offset,_PROCESSWINDOW);
               else
               {
                  PutCFGNumber(i,gcp[i].gcp_offset,gcp[i].gcp_set);
               }
            }
         }
      }

      /* ONE SHOTS */

      i=1;
      if(sp_pointnet)
      {
         strcpy(_ADDRESS[1],sp_pointnetaddress);
         i++;
      }

      if(sp_address_total)
      {
         int j;

         for(j=0;j<sp_address_total;j++)
         {
            strcpy(_ADDRESS[i],sp_address[j]);
            i++;
         }
      }
      _totADDRESS=i;


      if(*sp_tear)
      {
         ASPrintf(NULL,_TEAR,"--- %s",sp_tear);
      }
      else
         ASPrintf(NULL,_TEAR,"--- DLGMail v%s",BUILDVER);

      ASPrintf(NULL,_NETMAILDIRPATH,"MSG:%d/",_NETMAILDIR);
      ASPrintf(NULL,_BADMSGSDIRPATH,"MSG:%d/",_BADMSGSDIR);
      _MOVEATTACHES=0;
      ASPrintf(NULL,_VERSION,"%s",BUILDVER);
      strcpy(_VERSIONDATE,COMPILEDATE);

      ASPrintf(NULL,_ORIGIN," * Origin: %.53s (%d:%d/%d.%d)\r",sp_origin,_MyZone,_MyNet,_MyNode,_MyPoint);

      for(i=0;*gcp[i].gcp_keyword != NULL;i++)
      {
         if((gcp[i].gcp_flag_mandatory==GCP_MANDATORY) && (gcp[i].gcp_set != 7734))
         {
            ef=Open(CFGERRFILE,MODE_READWRITE);
            if(ef)
            {
               Seek(ef,0,OFFSET_END);
               AFPrintf(NULL,ef,"Configuration file error: [%s] not specified\n",gcp[i].gcp_keyword);
               Close(ef);
            }
            rc=LS_MISSING_ENTRY;
         }
      }

// new march 1995

      strcpy(_DLGSERIAL,"MISSING");
      fp=Open("dlgconfig:misc/dlgserial",MODE_OLDFILE);
      if(fp)
      {
         FGets(fp,_DLGSERIAL,6);
         Close(fp);
         _DLGSERIAL[6]=0;
      }

// end new
   }
   else
   {
      rc=LS_NO_FILE;
      DisplayErrReq(NULL,"There is no FIDO:DLGMail.CFG config file.","Check paths and filename spellings...");
   }


   CurrentConfig();

   if(!SHITHEADPROTECTION)
      return(LS_DICKHEAD);

   return(rc);
}
//-

/// StuffStruct
int StuffStruct(char *token,char *args,int number,char *stufferror)
{
   int newnumber;
   int i;
   char compare_string[50];
   char *s;
   BOOL found=FALSE;

   *stufferror=NULL; /* no error (yet) */

   if(*args)
   {
      while(1)
      {
         if(strlen(args)<1) break;

         if(args[strlen(args)-1]==' ' || args[strlen(args)-1]=='\t')
         {
            args[strlen(args)-1]=NULL;
         }
         else break;
      }
   }

   for(i=0;*gcp[i].gcp_keyword != NULL;i++)
   {
      if(gcp[i].gcp_flag_mandatory==GCP_OVERRIDE)
         ASPrintf(NULL,compare_string,"PRIVATE!%s",gcp[i].gcp_keyword); // the override prefix are all CTRL characters, ABCDEFG
      else
         strcpy(compare_string,gcp[i].gcp_keyword);

      if(0==Stricmp(token,compare_string))
      {
         found=TRUE;

         /* we have a match */

         if(gcp[i].gcp_flag_string) /* string */
         {
            switch(gcp[i].gcp_handler)
            {
               case HND_DEFAULT:
               PutCFGString(i,gcp[i].gcp_offset,args);
               break;

               case HND_ADDRESS:
               PutCFGString(i,gcp[i].gcp_offset,args);
               s=args;
               _MyZone=atoi(s);
               s=strchr(s,':');
               if(s)
               {
                  _MyNet=atoi(++s);
                  s=strchr(s,'/');
                  if(s)
                  {
                     _MyNode=atoi(++s);
                     s=strchr(s,'.');
                     if(s)
                     {
                        _MyPoint=atoi(++s);
                     }
                  }
               }
               break;

               case HND_POINTNET:

               strcpy(sp_pointnetaddress,args);
               s=args;
               s=strchr(s,':');
               if(s) newnumber=atoi(++s);
               _POINTNET=newnumber; /* cheat */
               _STRIPPOINTNET=1; /* cheat */
               sp_pointnet=TRUE;
               /* store the address into address[1] */
               break;

               case HND_AKA:  if(sp_address_total<(TOTALAKAS-2))
                              {
                                 strcpy(sp_address[sp_address_total],args);
                                 sp_address_total++;
                              }

                              break;

               case HND_OPERATOR: /* I think this is all that is required */
               PutCFGString(i,gcp[i].gcp_offset,args);
               break;

               case HND_CALLTYPES: /* I think this is all that is required */
               strncat(args,"-------------------------",24);
               args[24]=NULL;
               Upper(args);
               PutCFGString(i,gcp[i].gcp_offset,args);
               break;

               case HND_TEAR: /* put into temp string */
               SHITHEADPROTECTION=0;
               strcpy(sp_tear,"I M PIR8");
               RedFace1();
               //strcpy(sp_tear,args);
               break;

               case HND_ORIGIN:
               strcpy(sp_origin,args);
               break;

               default:
               ;
                  /* error */
               break;
            }
         }
         else   /*numeric*/
         {
            switch(gcp[i].gcp_handler)
            {
               case HND_DEFAULT:
               PutCFGNumber(i,gcp[i].gcp_offset,number);
               break;

               case HND_DEBUG:
               gcp[i].gcp_set=number;
               break;

               case HND_NOLOG:
               gcp[i].gcp_set=number;
               break;

               case HND_STEALTH:
               gcp[i].gcp_set=number;
               break;

               default:
               ;
                  /* error */
               break;

            }
         }
      }
   }
   if(!found) ASPrintf(NULL,stufferror,"Keyword [%s] not recognized\n",token);
   return -1;
}
//-

/// PutCFGNumber
int PutCFGNumber(int magic,int offset,int number)
{
   if(offset)
   {
      *((int *)(((char *)GCFG)+offset))=number;
      gcp[magic].gcp_set=7734;

      return 1;
   }
   else
   {
      return 0;
   }
}
//-

/// PutCFGString
int PutCFGString(int magic,int offset,char *string)
{
   if(offset)
   {
      strcpy(    ((char *)(((char *)GCFG)+offset))   ,string);
      gcp[magic].gcp_set=7734;

      return 1;
   }
   else
   {
      return 0;
   }

}
//-

/// CurrentConfig
int CurrentConfig(void)
{
   BPTR fp;
   int i;
   char buffer[120];

#ifdef MOREDEBUG
   BPTR fh;

   fh=Open("ram:MEMDUMP",MODE_NEWFILE);
   if(fh)
   {
      Write(fh,(void *)GCFG,sizeof(struct GConfig));
      Close(fh);
   }

#endif
   fp=Open(REPORTFILENAME,MODE_NEWFILE);
   if(fp)
   {
      AFPrintf(NULL,fp,"TASKPRI           [%d]\n",_TASKPRI);
      AFPrintf(NULL,fp,"STACKSIZE         [%d]\n",_STACKSIZE);
      AFPrintf(NULL,fp,"AUTOCALL          [%d]\n",_AUTOCALL);
      AFPrintf(NULL,fp,"AUTOCALLZONE      [%d]\n",_AUTOCALLZONE);

      AFPrintf(NULL,fp,"LOGLINES          [%d]\n",_LOGLINES);

      AFPrintf(NULL,fp,"PUBSCN_NAME       [%s]\n",_SCREENNAME);
      AFPrintf(NULL,fp,"PUBSCN_LACE       [%d]\n",_PUBSCNLACE);
      AFPrintf(NULL,fp,"PUBSCN_OSCAN      [%d]\n",_PUBSCNOSCAN);
      AFPrintf(NULL,fp,"PUBSCN_BEHIND     [%d]\n",_PUBSCNBEHIND);
      
      AFPrintf(NULL,fp,"SCREEN #          [%d]\n",_SCNPTR);
      AFPrintf(NULL,fp,"STATUS_X          [%d]\n",_WIN_X);
      AFPrintf(NULL,fp,"STATUS_Y          [%d]\n",_WIN_Y);
      AFPrintf(NULL,fp,"STATUS_WIDTH      [%d]\n",_WIN_WIDTH);

      AFPrintf(NULL,fp,"PROCESSWINDOW     [%d]\n",_PROCESSWINDOW);
      AFPrintf(NULL,fp,"PROCESS_X         [%d]\n",_PROCESS_X);
      AFPrintf(NULL,fp,"PROCESS_Y         [%d]\n",_PROCESS_Y);
      AFPrintf(NULL,fp,"PROCESS_WIDTH     [%d]\n",_PROCESS_WIDTH);
      AFPrintf(NULL,fp,"PROCESS_HEIGHT    [%d]\n",_PROCESS_HEIGHT);

      AFPrintf(NULL,fp,"PKTROUTE          [%d]\n",_PKTROUTE);
      AFPrintf(NULL,fp,"NETMAILROUTE      [%d]\n",_NETMAILROUTE);
      AFPrintf(NULL,fp,"LOG               [%d]\n",_LOG);
      AFPrintf(NULL,fp,"QUICKLOG          [%d]\n",_QUICKLOG);
      AFPrintf(NULL,fp,"PKTBUFFERLENGTH   [%d]\n",_PKTBUFFERLENGTH);
      AFPrintf(NULL,fp,"LINKREPLIES       [%d]\n",_LINKREPLIES);
      AFPrintf(NULL,fp,"CHECKDUPES #      [%d]\n",_CHECKDUPES);
      AFPrintf(NULL,fp,"SAVEDAMAGED       [%d]\n",_SAVEDAMAGED);
      AFPrintf(NULL,fp,"SECUREIMP         [%d]\n",_SECUREIMP);
      AFPrintf(NULL,fp,"NOCALLBUNDLE      [%d]\n",_NOCALLBUNDLE);
      AFPrintf(NULL,fp,"NOCALLPROCESS     [%d]\n",_NOCALLPROCESS);
      AFPrintf(NULL,fp,"FORCEINTL         [%d]\n",_FORCEINTL);

      AFPrintf(NULL,fp,"LOGUSERMESSAGE    [%d]\n",_LOGUSERMESSAGE);
      AFPrintf(NULL,fp,"NOTIFYACTIVEONLY  [%d]\n",_NOTIFYACTIVEONLY);
      AFPrintf(NULL,fp,"BORROW #          [%d]\n",_BORROW);
      AFPrintf(NULL,fp,"NET2USERDIR #     [%d]\n",_NET2USERDIR);
      AFPrintf(NULL,fp,"ACTIVITYLOG       [%d]\n",_ACTIVITYLOG);
      AFPrintf(NULL,fp,"AREAFIX           [%d]\n",_ENABLE_AREAFIX);
      AFPrintf(NULL,fp,"TICK              [%d]\n",_ENABLE_TICK);
      AFPrintf(NULL,fp,"HUB               [%d]\n",_ENABLE_HUB);
      AFPrintf(NULL,fp,"TDSPAWN           [%d]\n",_TDSPAWN);
      AFPrintf(NULL,fp,"NETMAILDIR        [%d]\n",_NETMAILDIR);
      AFPrintf(NULL,fp,"BADMSGSDIR        [%d]\n",_BADMSGSDIR);
      AFPrintf(NULL,fp,"POINTENABLE       [%d]\n",_POINTENABLE);
      AFPrintf(NULL,fp,"STRIPPOINTNET     [%d]\n",_STRIPPOINTNET);
      AFPrintf(NULL,fp,"POINTNET #        [%d]\n",_POINTNET);

   /* fprintf(fp,"legit #           [%d]\n",_LEGIT);
      fprintf(fp,"keycrc #          [%d]\n",_KEYCRC);
      fprintf(fp,"xorcrc #          [%d]\n",_XORCRC);
      fprintf(fp,"buyer #           [%d]\n",_BUYER);

      fprintf(fp,"DLG_legit #       [%d]\n",_DLG_LEGIT);
      fprintf(fp,"DLG_keycrc #      [%d]\n",_DLG_KEYCRC);
      fprintf(fp,"DLG_xorcrc #      [%d]\n",_DLG_XORCRC);
   */

      AFPrintf(NULL,fp,"DB_ALL            [%d]\n",_MyDEBUG);
      AFPrintf(NULL,fp,"DB_DLGMAIL        [%d]\n",_DLGMAIL_DB);
      AFPrintf(NULL,fp,"DB_IMP            [%d]\n",_ZIMP_DB);
      AFPrintf(NULL,fp,"DB_EXP            [%d]\n",_ZEXP_DB);
      AFPrintf(NULL,fp,"DB_NET            [%d]\n",_ZNET_DB);
      AFPrintf(NULL,fp,"DB_BUNDLE         [%d]\n",_ZBUNDLE_DB);
      AFPrintf(NULL,fp,"DB_TICK           [%d]\n",_DLGTICK_DB);
      AFPrintf(NULL,fp,"DB_AREAFIX        [%d]\n",_DLGAREAFIX_DB);
      AFPrintf(NULL,fp,"DB_HUB            [%d]\n",_DLGHUB_DB);

      AFPrintf(NULL,fp,"LOG_ALL           [%d]\n",_NLALL);
      AFPrintf(NULL,fp,"LOG_DLGMAIL       [%d]\n",_NLDLG);
      AFPrintf(NULL,fp,"LOG_IMP           [%d]\n",_NLIMP);
      AFPrintf(NULL,fp,"LOG_EXP           [%d]\n",_NLEXP);
      AFPrintf(NULL,fp,"LOG_NET           [%d]\n",_NLNET);
      AFPrintf(NULL,fp,"LOG_BUNDLE        [%d]\n",_NLBUN);
      AFPrintf(NULL,fp,"LOG_TICK          [%d]\n",_NLTIC);
      AFPrintf(NULL,fp,"LOG_AREAFIX       [%d]\n",_NLARE);
      AFPrintf(NULL,fp,"LOG_HUB           [%d]\n",_NLHUB);

      AFPrintf(NULL,fp,"SHOW_DLGMAIL      [%d]\n",_SHOWDLG);
      AFPrintf(NULL,fp,"SHOW_IMP          [%d]\n",_SHOWIMP);
      AFPrintf(NULL,fp,"SHOW_EXP          [%d]\n",_SHOWEXP);
      AFPrintf(NULL,fp,"SHOW_NET          [%d]\n",_SHOWNET);
      AFPrintf(NULL,fp,"SHOW_BUNDLE       [%d]\n",_SHOWBUN);
      AFPrintf(NULL,fp,"SHOW_TICK         [%d]\n",_SHOWTIC);
      AFPrintf(NULL,fp,"SHOW_AREAFIX      [%d]\n",_SHOWARE);
      AFPrintf(NULL,fp,"SHOW_HUB          [%d]\n",_SHOWHUB);

      AFPrintf(NULL,fp,"ADDRESS (Main)    [%s]\n",_ADDRESS[0]);
      
      if(_totADDRESS>1) AFPrintf(NULL,fp,"POINTNET or AKA   [%s]\n",_ADDRESS[1]);

      if(_totADDRESS>2)
      {
         for(i=2;i<_totADDRESS;i++)
         AFPrintf(NULL,fp,"AKA               [%s]\n",_ADDRESS[i]);
      }

      AFPrintf(NULL,fp,"TDPORT            [%s]\n",_TDPORT);
      AFPrintf(NULL,fp,"TDLOCKNAME        [%s]\n",_TDLOCKNAME);
      AFPrintf(NULL,fp,"TDCFGFILE         [%s]\n",_TDCFGFILE);
      AFPrintf(NULL,fp,"BBSPORT           [%s]\n",_BBSPORT);

      ASPrintf(NULL,buffer,_ORIGIN);
      buffer[strlen(buffer)-1]=NULL;
      AFPrintf(NULL,fp,"ORIGIN *          [%s]\n",buffer);
      AFPrintf(NULL,fp,"OPERATOR          [%s]\n",_OPERATOR);
      AFPrintf(NULL,fp,"CALLTYPES         [%s]\n",_CALLTYPES);
      AFPrintf(NULL,fp,"PCFRIENDLY        [%d]\n",_PCFRIENDLY);
      AFPrintf(NULL,fp,"PCADDRESS         [%s]\n",_PCADDRESS);
      AFPrintf(NULL,fp,"NETMAILDIRPATH #  [%s]\n",_NETMAILDIRPATH);
      AFPrintf(NULL,fp,"BADMSGSDIRPATH #  [%s]\n",_BADMSGSDIRPATH);
      AFPrintf(NULL,fp,"VERSION #         [%s]\n",_VERSION);
      AFPrintf(NULL,fp,"VERSIONDATE #     [%s]\n\n",_VERSIONDATE);
      AFPrintf(NULL,fp,"ARCADD            [%s]\n",_ARCADD);
      AFPrintf(NULL,fp,"ARCEXTRACT        [%s]\n",_ARCEXTRACT);
      AFPrintf(NULL,fp,"ZOOADD            [%s]\n",_ZOOADD);
      AFPrintf(NULL,fp,"ZOOEXTRACT        [%s]\n",_ZOOEXTRACT);
      AFPrintf(NULL,fp,"LHAADD            [%s]\n",_LHAADD);
      AFPrintf(NULL,fp,"LHAEXTRACT        [%s]\n",_LHAEXTRACT);
      AFPrintf(NULL,fp,"LZHADD            [%s]\n",_LZHADD);
      AFPrintf(NULL,fp,"LZHEXTRACT        [%s]\n",_LZHEXTRACT);
      AFPrintf(NULL,fp,"ZIPADD            [%s]\n",_ZIPADD);
      AFPrintf(NULL,fp,"ZIPEXTRACT        [%s]\n",_ZIPEXTRACT);
      AFPrintf(NULL,fp,"ARJADD            [%s]\n",_ARJADD);
      AFPrintf(NULL,fp,"ARJEXTRACT        [%s]\n",_ARJEXTRACT);

      Close(fp);
   }
   return(0);
}
//-

/// CheckArchivers
int CheckArchivers(void)
{
   char *p;
   char token[50];
   int i,j,q=0;
   char buf[100];

   for(i=0;i<10;i++)
   {
      for(j=0;j<4;j++)
      {
         p=GCFG->ARCHIVER[i][j];

         if(*p)
         {
            stptok(p,token,sizeof(token)," \t");
            if(!Exists(token))
            {
               ASPrintf(NULL,buf,"Can't locate archiver [%s]",token);
               DisplayErrReq(NULL,buf,"Make sure archiver is installed, provide path");
               q++;
            }
         }
      }
   }
   return q;
}
//-

/// LoadUpAreas
int LoadUpAreas(void)
{
   struct areas *a;
   char er1[60],er2[60];

   _ROSSAREAS=0;
   a=new_read_areas(AREAFILENAME,er1,er2);
   if(!a)
   {
      DisplayErrReq(NULL,er1,er2);
      return 0;   
   }
   else
   {
      _ROSSAREAS=a;
   }

   return 1;
}
//-

