#include "Includes.h"
#include "Defines.h"
#include "Protos.h"
#include "Version.h"
#include "Vars.h"

#include <link/io.h>

/// Report
/* PUBLIC
 * 
 * 
 * 
 * This function generates a standard configuration report.
 * 
 * 
 * COMPLETED
 */

int __REPORT(int argc, char **argv)
{
   CurrentConfig();
   return 0;

}
//-

/// __ZMH
/* PUBLIC
 * 
 * 
 * 
 * This function enables/disables zone mail hour on TrapDoor.
 * 
 * 
 * COMPLETED
 */

int __ZMH(int argc, char **argv)
{
   char returnstring[150];
   char buf[100];

   if(argc<1)
   {
      /* error calling this function */
      CP_CommandLine(4,"TrapDoor ZMH missing argument");
      return 0;
   }

   if(0==Stricmp(argv[0],"off") && IT_IS_ZMH)
   {
      RMWaitPort(_BBSPORT,_TDLOCKNAME);
      Delay(300);
      ASPrintf(NULL,buf,"CONFIG %s",_TDCFGFILE);
      SendRexx2(_TDPORT,buf,returnstring);
      SendRexx2(_TDPORT,"NOFORBIDFREQ",returnstring);

      DoAScript("ZMH_OFF.DMB",NULLFH);

      CP_CommandLine(4,"TrapDoor ZMH disabled");
      IT_IS_ZMH=0;
      return 1;
   }

   if(0==Stricmp(argv[0],"on") && IT_IS_ZMH==0)
   {
      RMWaitPort(_BBSPORT,_TDLOCKNAME);
      Delay(300);
      ASPrintf(NULL,buf,"CONFIG %s",_TDCFGFILE);
      SendRexx2(_TDPORT,buf,returnstring);
      SendRexx2(_TDPORT,"BBSMODE ZMH",returnstring);
      SendRexx2(_TDPORT,"FORBIDFREQ",returnstring);

      DoAScript("ZMH_ON.DMB",NULLFH);

      CP_CommandLine(4,"TrapDoor Mode ZMH enabled");
      IT_IS_ZMH=1;
      return 1;
   }

   CP_CommandLine(4,"Unknown ZMH argument [%s]",argv[0]);
   return 0;
}
//-

/// __MSGADDED
int __MSGADDED(int argc, char **argv)
{
   BPTR fp;

   if(argc)
   {
      fp=Open(USEREXPFILE,MODE_READWRITE);

      if(fp)
      {
         Seek(fp,0,OFFSET_END);
         AFPrintf(NULL,fp,"%s\n",argv[0]);
         Close(fp);
      }
   }
   return(0);
}
//-
