#include "dlghub.h"

#include <link/io.h>
#include <link/util.h>

/* ======================= */

int           HashCodes(char *, char *, char *, ULONG);
int           IncrementalRename(char *);
int           __NOTIFY(char *,char *,char *);
int           DoAScript(char *);

/* ======================= */

/// HubScan
int HubScan()
{
   int i;

   for(i = 0; i < Index; i++)
   {
      char *fname;

      struct SearchCookie  *sc = NULL;

      Chk_Abort();

      if(CFG[i].Skip == TRUE) continue;

///   Search for matches
      sc = SearchStart(CFG[i].Dir,CFG[i].Pat);

      if(!sc) continue;

      while(fname = SearchNext(sc))
      {
         char   fullname[500];
         struct Node *this;
         struct Node *that;
         ULONG  fsize = 0;

         Chk_Abort();

         strcpy(fullname,CFG[i].Dir);
         if(!AddPart(fullname,fname,500)) continue;

         if(CHAT)
         {
            AFPrintf(NULL,sout,"Found %s\n",fullname);
            ASPrintf(NULL,logstring,".  Found %s\n",fullname);
            Log(logstring);
         }

///      Check size
         FileSize(fullname,&fsize);

         if(fsize < CFG[i].Size)
         {
            AFPrintf(NULL,sout,"\tSize = %ld: Too small\n",fsize);
            continue;
         }
//-

         if(IsListEmpty(CFG[i].clist)) continue;

         this = (CFG[i].clist)->lh_Head;

///      Work through command list for each match
         while(that = this->ln_Succ)
         {
            int j;
            int c = 0;
            char *t;
            char *p[20];

            t = strdup(this->ln_Name);

            c = ArgParse(t,p,19);

            for(j = 1; j < c; j++)
            {
               int k;

               HashCodes(p[j],fullname,fname,fsize);

               for(k = 0; k < strlen(p[j]); k++)
                  if(p[j][k] == '"') p[j][k] = ' ';
               StripSpaces(p[j]);

            }

///         EventLog
            if(!Stricmp(p[0],"EventLog"))
            {
               if(c == 3)
               {
                  if(CHAT) AFPrintf(NULL,sout,"\t%s \"%s\" \"%s\"\n",p[0],p[1],p[2]);

                  if(!WriteEvent(p[1],p[2]))
                  {
                     AFPrintf(NULL,sout,"\tError from [LogEvent] for %s!\n",fullname);
                     ASPrintf(NULL,logstring," ! Error writing log event for %s",p[1]);
                     Log(logstring);
                  }
               }
               else
               {
                  AFPrintf(NULL,sout,"\tEVENTLOG: incorrect syntax (%s)",fullname);
                  ASPrintf(NULL,logstring," ! EVENTLOG: incorrect syntax (%s)",fullname);
                  Log(logstring);
               }
            }
//-

///         Comment
            if(!Stricmp(p[0],"Comment"))
            {
               if(c == 2)
               {
                  if(CHAT) AFPrintf(NULL,sout,"\t%s [%s] \"%s\"\n",p[0],fullname,p[1]);

                  if(!SetComment(fullname,p[1]))
                  {
                     AFPrintf(NULL,sout,"\tError from [Comment] for %s!\n",fullname);
                     ASPrintf(NULL,logstring," ! Error writing comment for %s",fullname);
                     Log(logstring);
                  }
               }
               else
               {
                  AFPrintf(NULL,sout,"\tCOMMENT: incorrect syntax (%s)",fullname);
                  ASPrintf(NULL,logstring," ! COMMENT: incorrect syntax (%s)",fullname);
                  Log(logstring);
               }
            }
//-

///         Delete
            if(!Stricmp(p[0],"Delete"))
            {
               if(c == 1)
               {
                  if(CHAT) AFPrintf(NULL,sout,"\t%s [%s]\n",p[0],fullname);

                  if(DeleteFile(fullname) == FALSE)
                  {
                     AFPrintf(NULL,sout,"\tError from [Delete] for %s!\n",fullname);
                     ASPrintf(NULL,logstring," ! Error deleting %s",fullname);
                     Log(logstring);
                  }
               }
               else
               {
                  AFPrintf(NULL,sout,"\tDELETE: incorrect syntax (%s)",fullname);
                  ASPrintf(NULL,logstring," ! DELETE: incorrect syntax (%s)",fullname);
                  Log(logstring);
               }
            }
//-

///         Rename, Move
            if(!Stricmp(p[0],"Rename") ||
               !Stricmp(p[0],"Move"))
            {
               if(c == 2)
               {
                  if(CHAT) AFPrintf(NULL,sout,"\t%s [%s] to [%s]\n",p[0],fullname,p[1]);

                  if(SmartRename(fullname,p[1]))
                  {
                     AFPrintf(NULL,sout,"\tError renaming [%s] to [%s]!\n",fullname,p[1]);
                     ASPrintf(NULL,logstring," ! Error renaming [%s] to [%s]",fullname,p[1]);
                     Log(logstring);
                  }
               }
               else
               {
                  AFPrintf(NULL,sout,"\tRENAME: incorrect syntax (%s)",fullname);
                  ASPrintf(NULL,logstring," ! RENAME: incorrect syntax (%s)",fullname);
                  Log(logstring);
               }
            }
//-

///         Copy
            if(!Stricmp(p[0],"Copy"))
            {
               if(c == 2)
               {
                  if((p[1][strlen(p[1]) - 1] == ':')  ||
                     (p[1][strlen(p[1]) - 1] == '/'))
                  {
                     char s[500];

                     strcpy(s,p[1]);
                     AddPart(s,fname,500);
                     strcpy(p[1],s);
                  }

                  if(!Exists(p[1]))
                  {
                     if(CHAT) AFPrintf(NULL,sout,"\t%s [%s] to [%s]\n",p[0],fullname,p[1]);

                     if(Copy(fullname,p[1]))
                     {
                        AFPrintf(NULL,sout,"\tError copying [%s] to [%s]!\n",fullname,p[1]);
                        ASPrintf(NULL,logstring," ! Error copying [%s] to [%s]",fullname,p[1]);
                        Log(logstring);
                     }
                  }
                  else
                  {
                     AFPrintf(NULL,sout,"\tCannot copy [%s] to [%s] -- already exists\n",fullname,p[1]);
                     ASPrintf(NULL,logstring,".   Cannot copy [%s] to [%s] -- already exists",fullname,p[1]);
                     Log(logstring);
                  }
               }
               else
               {
                  AFPrintf(NULL,sout,"\tRCOPY: incorrect syntax (%s)",fullname);
                  ASPrintf(NULL,logstring," ! RCOPY: incorrect syntax (%s)",fullname);
                  Log(logstring);
               }
            }
//-

///         RCopy
            if(!Stricmp(p[0],"RCopy"))
            {
               if(c == 2)
               {
                  if((p[1][strlen(p[1]) - 1] == ':')  ||
                     (p[1][strlen(p[1]) - 1] == '/'))
                  {
                     char s[500];

                     strcpy(s,p[1]);
                     AddPart(s,fname,500);
                     strcpy(p[1],s);
                  }

                  while(Exists(p[1]))
                     IncrementalRename(p[1]);

                  if(CHAT) AFPrintf(NULL,sout,"\t%s [%s] to [%s]\n",p[0],fullname,p[1]);

                  if(Copy(fullname,p[1]))
                  {
                     AFPrintf(NULL,sout,"\tError copying [%s] to [%s]!\n",fullname,p[1]);
                     ASPrintf(NULL,logstring," ! Error copying [%s] to [%s]",fullname,p[1]);
                     Log(logstring);
                  }
               }
               else
               {
                  AFPrintf(NULL,sout,"\tRCOPY: incorrect syntax (%s)",fullname);
                  ASPrintf(NULL,logstring," ! RCOPY: incorrect syntax (%s)",fullname);
                  Log(logstring);
               }
            }
//-

///         RMove
            if(!Stricmp(p[0],"RMove"))
            {
               if(c == 2)
               {
                  if((p[1][strlen(p[1]) - 1] == ':')  ||
                     (p[1][strlen(p[1]) - 1] == '/'))
                  {
                     char s[500];

                     strcpy(s,p[1]);
                     AddPart(s,fname,500);
                     strcpy(p[1],s);
                  }

                  while(Exists(p[1]))
                     IncrementalRename(p[1]);

                  if(CHAT) AFPrintf(NULL,sout,"\t%s [%s] to [%s]\n",p[0],fullname,p[1]);

                  if(SmartRename(fullname,p[1]))
                  {
                     AFPrintf(NULL,sout,"\tError moving [%s] to [%s]!\n",fullname,p[1]);
                     ASPrintf(NULL,logstring," ! Error moving [%s] to [%s]",fullname,p[1]);
                     Log(logstring);
                  }
               }
               else
               {
                  AFPrintf(NULL,sout,"\tRMove: incorrect syntax (%s)",fullname);
                  ASPrintf(NULL,logstring," ! RMove: incorrect syntax (%s)",fullname);
                  Log(logstring);
               }
            }
//-

///         Notify
            if(!Stricmp(p[0],"Notify"))
            {
               if(c == 3)
               {
                  if(CHAT) AFPrintf(NULL,sout,"\t%s \"%s\" \"%s\"\n",p[0],p[1],p[2]);

                  if(__NOTIFY(fullname,p[1],p[2]))
                  {
                     AFPrintf(NULL,sout,"\tError from [SendMsg] for %s!\n",fullname);
                     ASPrintf(NULL,logstring," ! Error sending message for %s",p[1]);
                     Log(logstring);
                  }
               }
               else
               {
                  AFPrintf(NULL,sout,"\tNOTIFY: incorrect syntax (%s)",fullname);
                  ASPrintf(NULL,logstring," ! NOTIFY: incorrect syntax (%s)",fullname);
                  Log(logstring);
               }
            }
//-

///         Script
            if(!Stricmp(p[0],"Script"))
            {
               if(c == 2)
               {
                  if(CHAT) AFPrintf(NULL,sout,"\tExecuting %s \"%s\"\n",p[0],p[1]);

                  if(!DoAScript(p[1]))
                  {
                     AFPrintf(NULL,sout,"\tError from [Script] for %s!\n",fullname);
                     ASPrintf(NULL,logstring," ! Error executing script for %s",p[1]);
                     Log(logstring);
                  }
               }
               else
               {
                  AFPrintf(NULL,sout,"\tSCRIPT: incorrect syntax (%s)",fullname);
                  ASPrintf(NULL,logstring," ! SCRIPT: incorrect syntax (%s)",fullname);
                  Log(logstring);
               }
            }
//-

///         Hatch
            if(!Stricmp(p[0],"Hatch"))
            {
               if(c == 3)
               {
                  if(CHAT) AFPrintf(NULL,sout,"\t%s \"%s\" \"%s\"\n",p[0],p[1],p[2]);


                  if(Spawn(NULL,sout,"Fido:DLGTick Hatch file %s Area %s Desc \"%s\"",fullname,p[1],p[2]))
                  {
                     AFPrintf(NULL,sout,"\tError from [Hatch] for %s!\n",fullname);
                     ASPrintf(NULL,logstring," ! Error hatching file for %s",p[1]);
                     Log(logstring);
                  }
               }
               else
               {
                  AFPrintf(NULL,sout,"\tHATCH: incorrect syntax (%s)",fullname);
                  ASPrintf(NULL,logstring," ! HATCH: incorrect syntax (%s)",fullname);
                  Log(logstring);
               }
            }
//-

            this = that;
         }
//-

      }

      SearchEnd(sc);
//-

   }

   return(0);
}
//-

/// HashCodes
HashCodes(char *string,char *path,char *fname,ULONG fsize)
{
   char *workbuf;
   char *s;
   char token[200];
   char sw[10];

   s=strchr(string,'%');
   if(s==NULL) return(1); /* nothing to hash */

   workbuf=(void *)calloc(strlen(string)+200,1);

   if(workbuf)
   {
      *workbuf=NULL;

      s=string;

      while(1)
      {
         if(*s==NULL) break;

         s=stptok(s,token,sizeof(token),"%");
         strcat(workbuf,token);

         /* s is sitting on the % */

         if(*s)
         {
            s++;
         }  /*if*/
         else
         {
            break;
         }  /*else*/

         if(*s && strlen(s)>3)
         {
            strncpy(sw,s,5);
            sw[4]=NULL;
            s+=4;

            if(!Stricmp(sw,"NAME")) strcat(workbuf,fname);
            if(!Stricmp(sw,"PATH")) strcat(workbuf,path);

            if(!Stricmp(sw,"SIZE"))
            {
               char t[20];
               ASPrintf(NULL,t,"%ld",fsize);
               strcat(workbuf,t);
            }

            if(!Stricmp(sw,"DATE")) strcat(workbuf,DATESTR);
            if(!Stricmp(sw,"TIME")) strcat(workbuf,TIMESTR);
            if(!Stricmp(sw,"DTTM")) strcat(workbuf,DATETIMESTR);
         }
      }

      strcpy(string,workbuf);
      free(workbuf);
   }

   return(1);
}
//-

/// __NOTIFY
__NOTIFY(char *filename,char *who,char *saywhat)
{
   BPTR fp;

   if(fp=Open("T:HUB_TMP",MODE_READWRITE))
   {
      int rc = 0;

      Seek(fp,0,OFFSET_END);
      AFPrintf(NULL,fp,saywhat);
      Close(fp);

      rc = Spawn(NULL,NULL,"DLG:SendMsg >NIL: <NIL: -n -q -f DLGHub -s \"Robotic Notification\" -b T:HUB_TMP -r \"%s\"",who);

      DeleteFile("T:HUB_TMP");
      return(rc);
   }

   return(0);
}
//-

/// IncrementalRename
int IncrementalRename(char *string)
{
   char token[300];
   char *s;
   int i=0;

   s=string;

   s=stptok(s,token,sizeof(token),",");

   if(s)
   {
      s++;
      i=atoi(s);
   }

   i++;
   ASPrintf(NULL,string,"%s,%d",token,i);

   return(1);
}
//-

/// DoAScript
int DoAScript(char *scriptname)
{
   char buf1[300];

   if(CHAT || DEBUG)
   {
      ASPrintf(NULL,logstring," . DoAScript() passed [%s]",scriptname);
      Log(logstring);
   }

   strcpy(buf1,scriptname);

   StripSpaces(buf1);

   if(Exists(buf1))
   {
      if(CHAT || DEBUG) Log(" . Script found");

      Spawn(NULL,sout, "Execute >NIL: <NIL: %s >NIL: <NIL:",scriptname);

      return(1);
   }

   return(0);
}
//-



