#include "DLGAreaFix.h"

char *memreaduntilterm2(char *, char *, char *);

/// parse5dstring
parse5dstring(char *string, char *domain, short *zone, short *net,
              short *node, short *point)
{
   char  temp[100];

   string = memreaduntilterm2(string, domain, "!");

   if (*string++ != '!')
      return -1;

   string = memreaduntilterm2(string, temp, ":");

   if (*string++ != ':')
      return -1;

   *zone = atoi(temp);

   string = memreaduntilterm2(string, temp, "/");

   if (*string++ != '/')
      return -1;

   *net = atoi(temp);

   string = memreaduntilterm2(string, temp, ".");

   if (*string++ != '.')
      return -1;

   *node = atoi(temp);
   *point = atoi(string);

   return 0;
}
//-

/// memreaduntilterm2
char *memreaduntilterm2(char *loc, char *buffer, char *termchars)
{
   char  c;

   for (;;)
   {
      c = *loc++;

      if (charisinstring(c, termchars) || !c)
      {
         *buffer = 0;
         loc--;
         return loc;
      }
      else
         *buffer++ = c;
   }
}
//-

/// TestPCAddress
TestPCAddress(char *address)
{
   char  b[50];
   char *r;

   strcpy(b, _PCADDRESS);

   if (!Stricmp(address, b))
      return(0);

   r = strchr(b, '.');

   if (r)
      *r = 0;

   if (!Stricmp(address, b))
      return(0);

   return(1);
}
//-

/// Log
void Log(char *logthis)
{
   AppendFile("Logs:DLGAreaFix.Log",logthis);
}
//-

/// mystpsym
char *mystpsym(char *in, char *out, int length)
{
   char *p;
   BOOL  qu = FALSE;
   int   c = 0;

   strcpy(out, "");

   p = in;

   if (*p == ' ' || *p == '\t')
      p = stpblk(p);

   if (*p == 34)
   {
      qu = TRUE;
      p++;
   }

   while (*p && c < length)
   {
      if (qu)
      {
         if (*p == 34)
         {
            p++;
            break;
         }
      }
      else
      {
         if (*p == ' ' || *p == '\t')
            break;
      }

      out[c++] = *p++;
      out[c] = NULL;
   }

   return (p);
}
//-

/// Make5DAddresss
/* pass space for sysopname into this function; pass
 * enough space for a full 5d address into this function as
 * this will change */

Make5DAddress(char *sysopname, char *address)
{
   BPTR  fh;
   char  buffer[1000];
   char  temp[100];
   char  sym[100];
   char  altaddress[100];

   char *dummy;
   char *s;
   char *p;
   int   rc = 0;

   int   sl;

   Log("-> Make5DAddress()");

   sl = sizeof(buffer);

   fh = Open("FIDO:DLGMail.AFX", MODE_OLDFILE);

   if (fh != NULL)
   {
      while (!rc)
      {
         s = FGets(fh, buffer, 9998);

         if (s == NULL)
         {
            break;
         }

         buffer[strlen(buffer) - 1] = NULL;  // dump the newline
         p = buffer;

         if (*p == ';')
            continue;

         if (*p == NULL)
            continue;

     /* look for keyword SYSOP */

         p = mystpsym(p, sym, sl);

         if (Stricmp(sym, "SYSOP"))
         {
            continue;
         }

         p = mystpsym(p, sym, sl);

         strcpy(sysopname, sym);

     /* look for keyword ADDRESS */

         p = mystpsym(p, sym, sl);

         if (Stricmp(sym, "ADDRESS"))
         {
            Log("!  ERROR: Bad .AFX Syntax, expecting ADDRESS keyword");
            rc = AF_BAD_AFX_SYNTAX;
            break;
         }

         p = mystpsym(p, sym, sl);

         strcpy(temp, sym);

         p = mystpsym(p, sym, sl);

         *altaddress = 0;

         if (!Stricmp(sym, "USEADDRESS"))
         {
            p = mystpsym(p, sym, sl);
            strcpy(altaddress, sym);

            p = mystpsym(p, sym, sl);
         }

         if (*altaddress)
         {
            if (strlen(address) != stcpm(altaddress, address, &dummy))
               continue;
            else
            {
               strcpy(address, altaddress);
               rc = 1;
               continue;
            }
         }
         else
         {
            if (strlen(address) != stcpm(temp, address, &dummy))
               continue;
            else
            {
               strcpy(address, temp);
               rc = 1;
               continue;
            }
         }

#ifdef NOSHIT

         if (Stricmp(sym, "PASSWORD"))
         {
            Log("!  ERROR: Bad .AFX Syntax, expecting PASSWORD keyword");
            rc = AF_BAD_AFX_SYNTAX;
            break;
         }

         p = mystpsym(p, sym, sl);

     /* look for keyword CLASSES */

         p = mystpsym(p, sym, sl);

         if (!(!Stricmp(sym, "CLASSES") || !Stricmp(sym, "MSGCLASSES")))
         {
            Log("!  ERROR: Bad .AFX Syntax, expecting CLASSES keyword");
            rc = AF_BAD_AFX_SYNTAX;
            break;
         }

         p = mystpsym(p, sym, sl);
         strcpy(classes, sym);

         if (!RAIDFLAG)
         {
            rc = AF_OK;
            break;
         }
         else
         {
            /* RAID */
            strcpy(classes, "");

           /* look for keyword FILECLASSES */

            p = mystpsym(p, sym, sl);

            if (Stricmp(sym, "FILECLASSES"))
            {
               Log("!  ERROR: Bad .AFX Syntax, expecting FILECLASSES keyword");
               rc = AF_BAD_AFX_SYNTAX;
               break;
            }

            p = mystpsym(p, sym, sl);
            strcpy(classes, sym);

           /* look for keyword TICKFLAGS */

            strcpy(tickflags, "");

            p = mystpsym(p, sym, sl);

            if (Stricmp(sym, "TICKFLAGS"))
            {
               Log("!  ERROR: Bad .AFX Syntax, expecting FILECLASSES keyword");
               rc = AF_BAD_AFX_SYNTAX;
               break;
            }

            p = mystpsym(p, sym, sl);
            strcpy(tickflags, sym);

            rc = AF_OK;
            break;
         }
#endif

      }

      Close(fh);
   }
   else
   {
      Log("!  Couldn't open FIDO:DLGMail.AFX file");
   }

   Log("<- Returning");
   return(rc);
}
//-

/// CheckClass
BOOL CheckClass(int class, char *classes)
{

/* classes is a string like so: "30 40 50 60" etc. */

   char *p;
   char  tok[100];

   if (class == 0)
   {
      return (TRUE); // the ol' just in case default */
   }

   p = classes;

   while (1)
   {
      p = stptok(p, tok, 20, " \t,;");

      if (0 == Stricmp(tok, ";"))
         break;

      if (*tok != NULL)
      {
         if (atoi(tok) == class)
         {
            return (TRUE);
         }
      }

      if (*p == NULL || *p == ';')
         break;

      p = stpblk(++p);
   }

   return (FALSE);
}
//-


