/* EFUNC.H: MicroEMACS function declarations and names

      This file list all the C code functions used by MicroEMACS
   and the names to use to bind keys to them. To add functions,
   declare it here in both the extern function list and the name
   binding table.

*/

/* Name to function binding table

      This table gives the names of all the bindable functions
   end their C function address. These are used for the bind-to-key
   function.
*/

// XENO_ EMACS changed all  "previous" to "prev"
//          "execute" to "exec"
//          "delete" to "del"
//          "window" to "win"
//          "buffer" to "buf"
//          "character" to "char"
//          "paragraph" to "par"
// "bind-to-key" to "bind"
// "macro-to-key" to "mac"
// "store-macro" to "st-m"
// "store-procedure" to "st-p"
// "clear-message-line" to "clr-msg"
// "split-current-window" to "split-win"
// "unbind-key" to "unbind"

NOSHARE NBIND  names[] =
{
   {"abort-command",    ctrlg},
   {"add-global-mode",     setgmode},
   {"add-mode",         setmod},
// {"attach-file",         fileattach},
   {"backward-char",    backchar},
   {"begin-macro",         ctlxlp},
   {"beginning-of-file",      gotobob},
   {"beginning-of-line",      gotobol},
   {"bind",       bindtokey},
   {"case-region-lower",      lowerregion},
   {"case-region-upper",      upperregion},
   {"case-word-capitalize",   capword},
   {"case-word-lower",     lowerword},
   {"case-word-upper",     upperword},
   {"change-file-name",    dummy1},
   {"clear-and-redraw",    refresh},
   {"clr-msg",    clrmes},
   {"copy-region",         copyregion},
   {"ctlx-prefix",         cex},
   {"del-blank-lines",     deblank},
   {"del-buf",    killbuffer},
   {"del-global-mode",     delgmode},
   {"del-mode",         delmode},
   {"del-next-char", forwdel},
   {"del-next-word",    delfword},
   {"del-other-wins",   onlywind},
   {"del-prev-char", backdel},
   {"del-prev-word", delbword},
   {"del-win",    delwind},
   {"end-macro",        ctlxrp},
   {"end-of-file",         gotoeob},
   {"end-of-line",         gotoeol},
   {"end-of-word",         endword},
   {"exchange-point-and-mark",   swapmark},
   {"exec-buf",      execbuf},
   {"exec-command-line",   execcmd},
   {"exec-file",     execfile},
   {"exec-macro",    ctlxe},
   {"exec-program",     execprg},
   {"exit-emacs",       quit},
   {"fill-par",      fillpara},
   {"filter-buf",    dummy1},
   {"find-file",        filefind},
   {"forward-char",     forwchar},
   {"goto-line",        gotoline},
   {"goto-mark",        gotomark},
   {"greet",         greet},
   {"handle-tab",       tab},
   {"i-shell",       dummy1},
   {"indent-region",    indent_region},
   {"insert-file",         insfile},
   {"insert-space",     insspace},
   {"insert-string",    istring},
   {"kill-region",         killregion},
   {"kill-to-end-of-line",    killtext},
   {"mac",           macrotokey},
   {"meta-prefix",         meta},
   {"move-win-down",    mvdnwind},
   {"move-win-up",      mvupwind},
   {"msg-area",         msg_area},
   {"name-buf",         namebuffer},
   {"newline",       newline},
   {"newline-and-indent",     dummy1},
   {"next-buf",         nextbuffer},
   {"next-line",        forwline},
   {"next-page",        forwpage},
   {"next-par",      gotoeop},
   {"next-win",         nextwind},
   {"next-word",        forwword},
   {"nop",           nullproc},
   {"opts",                        opts},
   {"open-line",        openline},
   {"overwrite-string",    ovstring},
   {"pipe-command",     dummy1},
   {"prev-line",     backline},
   {"prev-page",     backpage},
   {"prev-par",      gotobop},
   {"prev-win",      prevwind},
   {"prev-word",     backword},
   {"print",         writemsg},
   {"query-replace-string",   qreplace},
   {"quick-exit",       quickexit},
   {"quote-char",    quote},
   {"quote-msg",     quotemsg},
   {"read-file",        fileread},
   {"redraw-display",      reposition},
   {"remove-mark",         remmark},
   {"replace-string",      sreplace},
   {"resize-win",    resize},
   {"run",           execproc},
   {"save-file",        filesave},
   {"search-forward",      forwsearch},
   {"search-reverse",      backsearch},
   {"select-buf",    usebuffer},
   {"set",           setvar},
   {"set-fill-column",     setfillcol},
   {"set-mark",         setmark},
   {"shell-command",    dummy1},
   {"source",        execfile},
   {"split-win",  splitwind},
   {"st-m",       storemac},
   {"st-p",       storeproc},
   {"transpose-chars",  twiddle},
   {"trim-line",        trim},
   {"trim-region",         trim},
   {"unbind",        unbindkey},
   {"undent-region",    undent_region},
   {"unmark-buf",    unmark},
   {"update-screen",    upscreen},
   {"view-file",        viewfile},
   {"who",                 who},
   {"wrap-word",        wrapword},
   {"write-file",       filewrite},
   {"xspell",                      xenospell},
   {"yank",       yank},

   {"",        NULL}
};

#define  NFUNCS   (sizeof(names)/sizeof(NBIND)) - 1
