#include <string.h>
#include <stdlib.h>

#include <exec/memory.h>
#include <exec/types.h>
#include <exec/io.h>

#include <devices/serial.h>
#include <devices/tpt.h>

#include <dlg/dlgproto.h>

#include <link/io.h>

#include <proto/exec.h>
#include <proto/dlg.h>

#include <pragmas/dlg.h>

LONG __saveds __asm LIBTCont(register __a0 char *);
LONG __saveds __asm LIBTFreeze(register __a0 char *);
LONG __saveds __asm LIBTGetSer(register __a0 struct TPTSerStuff *, register __a1 char *);
LONG __saveds __asm LIBTGetTitle(register __a0 char *, register __a1 char *);
LONG __saveds __asm LIBTTitle(register __a0 char *, register __a1 char *);

extern struct DosLibrary *DOSBase;
extern char   space[];

struct DLGSerInfo * __saveds __asm LIBDLGGetSer(register __a0 char *port,
                                                register __d0 char protocol)
{struct DLGSerInfo *dsi;
 struct TPTSerStuff ss;
 LONG               retval;

 retval = LIBTFreeze(port);
 if (retval != NOERR)  return(NULL);

 retval = LIBTGetSer(&ss, port);
 if (retval != NOERR)
    {LIBTCont(port);
     return(NULL);
    }

 dsi = AllocMem(sizeof(struct DLGSerInfo), MEMF_PUBLIC);
 if (!dsi)  return(NULL);

 strcpy(dsi->port, port);

 dsi->read     = ss.read;
 dsi->write    = ss.write;
 dsi->readbak  = dsi->read->IOSer.io_Message.mn_ReplyPort;
 dsi->writebak = dsi->write->IOSer.io_Message.mn_ReplyPort;

 dsi->read->IOSer.io_Message.mn_ReplyPort  = CreateMsgPort();
 dsi->write->IOSer.io_Message.mn_ReplyPort = CreateMsgPort();

 LIBTGetTitle(dsi->titlebak, dsi->port);

 strcpy(dsi->title, dsi->titlebak);
 retval = strlen(dsi->title);
 if (retval < 32)  movmem(space, dsi->title+retval, 32-retval);
 movmem(space, dsi->title+32, 37);
 dsi->title[70] = 0;

 movmem("FT [ ]", dsi->title+30, 6);
 if (protocol) dsi->title[34] = protocol;
 movmem("Size:",  dsi->title+39, 5);
 movmem("Trans:", dsi->title+53, 6);

 dsi->flags = 0;

 return(dsi);
}


void __saveds __asm LIBDLGReleaseSer(register __a0 struct DLGSerInfo *dsi)

{DeleteMsgPort(dsi->read->IOSer.io_Message.mn_ReplyPort);
 DeleteMsgPort(dsi->write->IOSer.io_Message.mn_ReplyPort);

 dsi->read->IOSer.io_Message.mn_ReplyPort  = dsi->readbak;
 dsi->write->IOSer.io_Message.mn_ReplyPort = dsi->writebak;

 LIBTTitle(dsi->titlebak,dsi->port);
 LIBTCont(dsi->port);

 FreeMem(dsi, sizeof(struct DLGSerInfo));
}


void __saveds __asm LIBDLGProtoStatus(register __a0 struct DLGSerInfo *dsi,
                                      register __d0 ULONG              fsize,
                                      register __d1 ULONG              bytes,
                                      register __a1 char              *msg)

{char buffer[12];

 if (fsize)
    {ASPrintf(NULL, buffer, "%-9.9ld", fsize);
     movmem(buffer,dsi->title+44,9);
    }

 if (bytes)
    {ASPrintf(NULL,buffer,"%-9.9ld",bytes);
     movmem(buffer,dsi->title+59,10);
    }

 if (msg)
    {if (strlen(msg)>48)  msg[48] = 0;
     LIBTTitle(msg,dsi->port);
    }
  else
    LIBTTitle(dsi->title,dsi->port);
}
