#include <stdlib.h>
#include <string.h>
#include <time.h>

#include <exec/types.h>

#include <libraries/dos.h>
#include <libraries/dosextens.h>

#include <dlg/log.h>

#include <link/io.h>

#include <proto/dos.h>
#include <proto/dlg.h>

#include <pragmas/dlg.h>

ULONG __saveds __asm LIBAmigaTime(void);
void  __saveds __asm LIBSMDate(register __d0 ULONG, register __a0 char *);
LONG  __saveds __asm LIBAppendFile(register __a0 char *, register __a1 char *);
void  __saveds __asm LIBCapitalize(register __a0 char *);
void  __saveds __asm LIBUnderScore(register __a0 char *);
LONG  __saveds __asm LIBStricmp(register __a0 char *,  register __a1 char *);
LONG  __saveds __asm LIBStrnicmp(register __a0 char *, register __a1 char *, register __d0 USHORT);
void  __saveds __asm LIBUpper(register __a0 char *);
LONG  __saveds __asm LIBFileSize(register __a0 char  *, register __a1 ULONG *);


///   WriteLog()
BOOL __saveds __asm LIBWriteLog( register __d0 UBYTE code,
                                 register __a0 char *person,
                                 register __a1 char *Ext,
                                 register __a2 char *info)
{
   struct Log_Entry Entry;
   struct Log_Entry OEntry;
   struct Log  *clog;

   char             datestring[40];
   char             filename [128];
   BPTR             fh;

   BOOL match = FALSE;
   ULONG lsize = 0;

   if (!LIBStricmp(Ext, "NOL"))  return(FALSE);

   if(code >= 128)
   {
      if(LIBFileSize("DLGConfig:Port/Customlog.bbs",&lsize) == -1)
         return(FALSE);

      if(lsize < sizeof(struct Log))
         return(FALSE);

      clog = calloc(1,sizeof(struct Log));

      fh = Open("DLGConfig:Port/Customlog.bbs",MODE_OLDFILE);

      if(!fh || !clog)
      {
         if(fh) Close(fh);
         if(clog) free(clog);
         return(FALSE);
      }

      while(Read(fh,clog,sizeof(struct Log)))
      {
         if(clog->number == code)
         {
            match = TRUE;
            break;
         }
      }

      if(!match)
      {
         if(fh) Close(fh);
         if(clog) free(clog);
         return(FALSE);
      }

      if(fh) Close(fh);
      if(clog) free(clog);
   }

   Entry.Code      = code;
   Entry.Long_Time = LIBAmigaTime();

   strncpy(Entry.Name, person, 35);
   Entry.Name[35] = 0;
   LIBCapitalize(Entry.Name);

   if (Ext)
   {
      strncpy(Entry.Ext, Ext, 4);
      LIBUpper(Entry.Ext);
   }
   else
      strcpy(Entry.Ext, "n/a");

   strncpy(Entry.Info, info, 35);
   Entry.Info[35] = 0;

   LIBSMDate(Entry.Long_Time, datestring);
   datestring[3] = 0;
   strcpy(filename,     "DLGConfig:Text/Log.");
   strcpy(&filename[19], datestring);

   if ((fh = Open(filename, MODE_READWRITE)))
   {
      Read(fh, &OEntry, sizeof(OEntry));
      if (OEntry.Long_Time+86400 < Entry.Long_Time)
      {
         Close(fh);
         DeleteFile(filename);
         fh = NULL;
      }
   }

   if (!fh)
   if (!(fh = Open(filename, MODE_NEWFILE)))  return(FALSE);

   Seek (fh, 0, OFFSET_END);
   Write(fh, &Entry, sizeof(Entry));
   Close(fh);
   return(TRUE);
}
//-

BOOL __saveds __asm LIBWriteEvent(register __a0 char *name,
register __a1 char *buf)

{
   char filename[80];

   if (!name)   return(FALSE);
   if (!*name)  return(FALSE);

   ASPrintf(NULL,filename,"USER:%s/Event.log", name);
   LIBUnderScore(filename);

   return((BOOL)(LIBAppendFile(filename, buf)==0));
}
