#include <exec/types.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <time.h>

#include <proto/exec.h>
#include <proto/dos.h>
#include <proto/dlg.h>

#include <dlg/portconfig.h>

#include <pragmas/dlg.h>

// ---------------->

#define PORTDIR "DLGConfig:Port"
//#define PORTDIR "Test"


static char version[]="$VER: ConvertGlobals 1.4  1997-1998 by Digerati Dreams ("__AMIGADATE__")";

/// Old globals
struct OldGlobal
{
  char    BBSName[36];     /* name of bbs                                     */
  char    GlobalScreen;    /* determines whether screen opens for users       */
  char    DefaultScreen;   /* determines between screen or window             */
  char    TimeOut;         /* idle timeout for port in seconds                */
  char    VerbPause;       /* selects between verbose pause or silent pause   */
  SHORT   Session_Limit;   /* not used                                        */
  SHORT   Daily_Limit;     /* not used                                        */
  char    ConnectDelay;    /* delay between connect and session start         */
  SHORT   NumUsers;        /* current number of users                         */
  char    NewUserLevel;    /* not used                                        */
  SHORT   DirLimit;        /* not used                                        */
  char    AutoAccess;      /* selects between auto access and private port    */
  char    NameList[20];    /* is the groupname for a private port             */
  char    DefMenu[18];     /* menu that is selected at login                  */
  char    CmdStack[10];    /* not used                                        */
  SHORT   MinBaud;         /* minimum baud rate for port                      */
  char    Ratio;           /* not used                                        */
  char    Language[22];    /* default language for this port                  */
  char    Origin[53];      /* not used                                        */
  unsigned char CharSet;   /* default characterset translation for this port  */
  unsigned char unused[3]; /* not used                                        */
  SHORT   Flags;           /* Flags                                           */
  char    ForcedStack[10]; /* command stack forced at login                   */
  long    PrivateArea;     /* private message redirect area                   */
};
//-

BPTR  sout;
BPTR  fh =  NULL;

struct   Library    *DLGBase  =  NULL;

struct   OldGlobal         og;
struct   Global_Settings   gs;


void  ShutDown(int, char *);
void  Usage(void);
void _CXBRK(void);

/// Main
int main(int argc, char **argv)
{
   char *iname;

   struct   SearchCookie *sc;

   sout = Output();

   DLGBase = OpenLibrary("dlg.library",2L);

   if(!DLGBase) ShutDown(10,"Could not open dlg.library!");

/// Search for Globals
   sc = SearchStart(PORTDIR,"*.globals");

   if(sc)
   {
      ULONG fsize = 0;

      while(iname = SearchNext(sc))
      {
         char fname[256];
         char oname[256];

         ASPrintf(NULL,fname,"%s/%s",PORTDIR,iname);
         AFPrintf(NULL,sout,"%s  -->  ",fname);

         ASPrintf(NULL,oname,"%sbak",fname);
         AFPrintf(NULL,sout,"%s\n",fname);

         if(!Exists(fname))
         {
            AFPrintf(NULL,sout,"Could not find %s!",fname);
            continue;
         }

         FileSize(fname,&fsize);

         if(fsize != sizeof(struct OldGlobal))
         {
            AFPrintf(NULL,sout,"\tAlready converted or corrupt\n");
            continue;
         }

         Copy(fname,oname);

         if(-1 == GetFirstStruct(fname,(char *)&og,sizeof(struct OldGlobal)))
         {
            AFPrintf(NULL,sout,"\tError: not converted\n");
            continue;
         }

///      Convert global definitions

         memcpy(&gs,&og,sizeof(struct OldGlobal));

         gs.PrivateArea = (SHORT)og.PrivateArea;

         AFPrintf(NULL,sout,"\n");
//-

///      Write out new definition

         AFPrintf(NULL,sout,"\tWriting new global def\n");

         fh = Open(fname,MODE_NEWFILE);

         if(!fh)
         {
            AFPrintf(NULL,sout,"\tCould not create new global def");
            continue;
         }

         Write(fh,&gs,sizeof(struct Global_Settings));
         Close(fh);
         fh = NULL;
//-

         AFPrintf(NULL,sout,"\tDone!\n\n");
      }

      SearchEnd(sc);
   }
//-

   ShutDown(0,NULL);
}
//-

/// ShutDown
void ShutDown(int Error, char *ErrStr)
{
   if(fh)      Close(fh);

   if(DLGBase) CloseLibrary(DLGBase);

   if(Error)
   {
      FPuts(sout,ErrStr);
      FPuts(sout,"\n\n");
   }

   exit(Error);
}
//-

/// _CXBRK
void _CXBRK()
{
   ShutDown(5,"Control-C Detected");
}
//-



