#include <stdlib.h>
#include <string.h>

#include <proto/exec.h>
#include <proto/dos.h>
#include <proto/dlg.h>

#include <dlg/Msg.h>

#include <pragmas/dlg.h>

/// Old Area Def
/*
** Old message area (file area) definition
**
 *********************************************/

struct Old_Area
{
  char   Name[34];
  SHORT  AADef;
  long   Capacity;        // --> SHORT
  long   Number;          // --> SHORT
  char   Flag;
  SHORT  UpperLimit;
  unsigned char llevel;   /* lowest level that can gain access             */
  unsigned char ulevel;   /* highest level that can gain access            */
  char   path[8];         /* used only in file areas (alternate file path) */
  char   processor[12];   /* batchfile used to process the text            */
  char   origin[75];      /* custom origin line for this area              */
  unsigned char uwrite;   /* highest level that can write                  */
  unsigned char lwrite;   /* lowest level that can write                   */
  unsigned char ukill;    /* highest level that can kill                   */
  unsigned char lkill;    /* lowest level that can kill                    */
  unsigned char uforward; /* highest level that can forward                */
  unsigned char lforward; /* lowest level that can forward                 */
  unsigned char ucopy;    /* highest level that can copy                   */
  unsigned char lcopy;    /* lowest level that can copy                    */
  unsigned char uedit;    /* highest level that can edit                   */
  unsigned char ledit;    /* lowest level that can edit                    */
  unsigned char usysop;   /* highest level that can have sysop access      */
  unsigned char lsysop;   /* lowest level that can have sysop access       */
  char          forceset; /* not used                                      */
  unsigned char loadcharset; /* not used                                   */
  unsigned char savecharset; /* alternate character set for this area      */
  char unused[33];           /* not used                                   */
};
//-

static char version[]="$VER: ConvertAreas 2.6  1997-1998 by Digerati Dreams ("__AMIGADATE__")";

BPTR  sout;
BPTR  fh =  NULL;

struct   Library    *DLGBase  =  NULL;

struct   Old_Area   *OA       =  NULL;
struct   Msg_Area   *NA       =  NULL;

void  ShutDown(int, char *);
void  Usage(void);
void _CXBRK(void);

/// Main
int main(int argc, char **argv)
{
   long  NumAreas = 0;

   ULONG fsize = 0;
   ULONG i = 0;

   struct   Old_Area *OldArea;
   struct   Msg_Area *NewArea;

   sout = Output();

   DLGBase = OpenLibrary("dlg.library",4L);

   if(!DLGBase) ShutDown(10,"Could not open dlg.library!");

   AFPrintf(NULL,sout,"Converting file areas\n\n");

   if(-1 == FileSize("File:AREA.BBS",&fsize))
      ShutDown(10,"Could not find File:AREA.BBS!");

   if(fsize == 0) ShutDown(5,"No file areas defined.");

   NumAreas = fsize / sizeof(struct Old_Area);

   if(fsize % sizeof(struct Old_Area))
      ShutDown(5,"File area structure corrupt or already converted");

   OA = calloc(NumAreas,sizeof(struct Old_Area));

   if(!OA) ShutDown(10,"Could not allocate memory for old file areas!");

   NA = calloc(NumAreas,sizeof(struct Msg_Area));

   if(!NA) ShutDown(10,"Could not allocate memory for new file areas!");

   fh = Open("file:area.bbs",MODE_OLDFILE);

   if(!fh) ShutDown(10,"Could not open FILE:AREA.BBS!");

   i = Read(fh,OA,fsize);
   Close(fh);
   fh = NULL;

   if(i != fsize) ShutDown(10,"Old file areas not read in.");

   Copy("File:Area.BBS","File:Area.BBS.BAK");

   AFPrintf(NULL,sout,"%ld file areas to convert.\n",NumAreas);

/// Convert file area definitions
   for(i = 0; i < NumAreas; i++)
   {
      Chk_Abort();
      OldArea = OA + i;
      NewArea = NA + i;
      AFPrintf(NULL,sout,"[%4.4ld] [%4.4ld] %-34.34s\r",i,OldArea->Number,OldArea->Name);

      strcpy(NewArea->Name,OldArea->Name);

      NewArea->UpperLimit = OldArea->UpperLimit;

      memcpy(NewArea->path,OldArea->path,8);
      memcpy(NewArea->processor,OldArea->processor,12);

      strcpy(NewArea->origin,OldArea->origin);

      NewArea->Number = OldArea->Number;

      NewArea->llevel = OldArea->llevel;
      NewArea->ulevel = OldArea->ulevel;
      NewArea->lwrite     = OldArea->lwrite;
      NewArea->uwrite     = OldArea->uwrite;
      NewArea->lcopy     = OldArea->lcopy;
      NewArea->ucopy     = OldArea->ucopy;
      NewArea->lkill    = OldArea->lkill;
      NewArea->ukill    = OldArea->ukill;
      NewArea->lforward   = OldArea->lforward;
      NewArea->uforward   = OldArea->uforward;
      NewArea->ledit   = OldArea->ledit;
      NewArea->uedit   = OldArea->uedit;
      NewArea->lsysop  = OldArea->lsysop;
      NewArea->usysop  = OldArea->usysop;

      NewArea->Capacity = OldArea->Capacity;

      NewArea->Flag = OldArea->Flag;

      NewArea->forceset = OldArea->forceset;
      NewArea->loadcharset = OldArea->loadcharset;
      NewArea->savecharset = OldArea->savecharset;
   }

   free(OA);
   OA = NULL;

   AFPrintf(NULL,sout,"\n");
//-

/// Write out new definition

   AFPrintf(NULL,sout,"Writing new file area index\n");

   fh = Open(FILETARGET,MODE_NEWFILE);

   if(!fh) ShutDown(10,"Could not create new file area index");
   Write(fh,NA,(NumAreas * sizeof(struct Msg_Area)));
   Close(fh);
   fh = NULL;
//-

   free(NA);
   NA = NULL;

   AFPrintf(NULL,sout,"Done!\n\n");


   AFPrintf(NULL,sout,"Converting message areas\n\n");


   fsize = 0;

   if(-1 == FileSize("MSG:AREA.BBS",&fsize))
      ShutDown(10,"Could not find MSG:AREA.BBS!");

   if(fsize == 0) ShutDown(5,"No message areas defined.");

   NumAreas = fsize / sizeof(struct Old_Area);

   OA = calloc(NumAreas,sizeof(struct Old_Area));

   if(!OA) ShutDown(10,"Could not allocate memory for old message areas!");

   NA = calloc(NumAreas,sizeof(struct Msg_Area));

   if(!NA) ShutDown(10,"Could not allocate memory for new message areas!");

   fh = Open("MSG:area.bbs",MODE_OLDFILE);

   if(!fh) ShutDown(10,"Could not open MSG:AREA.BBS!");

   i = Read(fh,OA,fsize);
   Close(fh);
   fh = NULL;

   if(i != fsize) ShutDown(10,"Old message areas not read in.");

   AFPrintf(NULL,sout,"%ld message areas to convert.\n",NumAreas);

/// Convert file area definitions
   for(i = 0; i < NumAreas; i++)
   {
      Chk_Abort();
      OldArea = OA + i;
      NewArea = NA + i;
      AFPrintf(NULL,sout,"[%4.4ld] [%4.4ld] %-34.34s\r",i,OldArea->Number,OldArea->Name);

      strcpy(NewArea->Name,OldArea->Name);

      NewArea->UpperLimit = OldArea->UpperLimit;

      memcpy(NewArea->path,OldArea->path,8);
      memcpy(NewArea->processor,OldArea->processor,12);

      strcpy(NewArea->origin,OldArea->origin);

      NewArea->Number = OldArea->Number;

      NewArea->llevel = OldArea->llevel;
      NewArea->ulevel = OldArea->ulevel;
      NewArea->lwrite     = OldArea->lwrite;
      NewArea->uwrite     = OldArea->uwrite;
      NewArea->lcopy     = OldArea->lcopy;
      NewArea->ucopy     = OldArea->ucopy;
      NewArea->lkill    = OldArea->lkill;
      NewArea->ukill    = OldArea->ukill;
      NewArea->lforward   = OldArea->lforward;
      NewArea->uforward   = OldArea->uforward;
      NewArea->ledit   = OldArea->ledit;
      NewArea->uedit   = OldArea->uedit;
      NewArea->lsysop  = OldArea->lsysop;
      NewArea->usysop  = OldArea->usysop;

      NewArea->Capacity = OldArea->Capacity;

      NewArea->Flag = OldArea->Flag;

      NewArea->forceset = OldArea->forceset;
      NewArea->loadcharset = OldArea->loadcharset;
      NewArea->savecharset = OldArea->savecharset;
   }

   free(OA);
   OA = NULL;

   AFPrintf(NULL,sout,"\n");
//-

/// Write out new definition

   AFPrintf(NULL,sout,"Writing new message area index\n");

   fh = Open(MSGTARGET,MODE_NEWFILE);

   if(!fh) ShutDown(10,"Could not create new message area index");
   Write(fh,NA,(NumAreas * sizeof(struct Msg_Area)));
   Close(fh);
   fh = NULL;
//-

   free(NA);
   NA = NULL;

   AFPrintf(NULL,sout,"Done!\n\n");

   ShutDown(0,NULL);
}
//-

/// ShutDown
void ShutDown(int Error, char *ErrStr)
{
   if(OA)      free(OA);
   if(NA)      free(NA);

   if(fh)      Close(fh);

   if(DLGBase) CloseLibrary(DLGBase);

   if(Error)
   {
      FPuts(sout,ErrStr);
      FPuts(sout,"\n\n");
   }

   exit(Error);
}
//-

/// _CXBRK
void _CXBRK()
{
   ShutDown(5,"Control-C Detected");
}
//-



