#include <stdlib.h>
#include <string.h>
#include <exec/types.h>
#include <ctype.h>

#include <dlg/dlg.h>
#include <dlg/msg.h>
#include <dlg/resman.h>

#include <link/io.h>
#include <link/lang.h>

#include <proto/exec.h>
#include <proto/dos.h>
#include <proto/dlg.h>

#include <pragmas/dlg.h>

#include <private/Version.h>
#define  ObjRev "1"
const UBYTE version[]="\0$VER: LeaveArea " BUILDVER "." ObjRev " " COPYRIGHT " by Digerati Dreams "__AMIGADATE__;


void main   (int, char **);
void Usage  (char *);
void CleanUp(char *);


BPTR            sout;
char          **SA;
struct Library *DLGBase = NULL;


void main(int argc,char **argv)

{
   long    retval;
   long    area    = -2;
   char    flags   = MSGLOCK;

   sout    = Output();
   DLGBase = OpenLibrary(DLGNAME,DLGVERSION);
   if (!DLGBase)               CleanUp("Unable to open dlg.library");
   if (!(SA = getlang(NULL)))  CleanUp("Can't read language file");

   AFPrintf(NULL, sout, "\n");

   while(--argc>0)
   {
      char *s;

      s = *++argv;
      if (*s++ == '-')
      {
         while(*s)
         {
            switch(*s)
            {
               case 'a':
               case 'A':  if (!--argc)  break;
               area = atol(*++argv);
               break;

               case 'm':
               case 'M':  flags = MSGLOCK;
               break;

               case 'f':
               case 'F':  flags = FILELOCK;
               break;
            }

            s++;
         }
      }
   }
   if (area == -2)  Usage(SA[2841]);

   retval = LeaveArea(area,flags);

   if (retval == RMNOERR)
   AFPrintf(NULL, sout, SA[2842]);
   else
   if (retval == NORM)
   CleanUp(SA[2843]);
   else
   if (retval == AREAEMPTY)
   CleanUp(SA[2844]);
   else
   CleanUp(SA[2845]);

   AFPrintf(NULL, sout, "\n");
   CleanUp(NULL);
}


void Usage(char *string)

{
   AFPrintf(NULL, sout, SA[2846],string);
   AFPrintf(NULL, sout, SA[2847]);
   AFPrintf(NULL, sout, SA[2848]);

   CleanUp(NULL);
}


void CleanUp(char *s)

{
   if (DLGBase)  CloseLibrary(DLGBase);

   if (s)
   {
      Write(sout, "\n Error: ", 9);
      Write(sout,  s,    strlen(s));
      Write(sout, "\n\n",       2);
   }

   exit(s?5:0);
}
