#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>

#include <dlg/dlg.h>
#include <dlg/user.h>
#include <dlg/msg.h>
#include <dlg/resman.h>

#include <link/io.h>

#include <proto/dos.h>
#include <proto/exec.h>
#include <proto/dlg.h>

#include <pragmas/dlg.h>

#include <private/Version.h>

#define  ObjRev "1"

const UBYTE version[]="\0$VER: Catchup " BUILDVER "." ObjRev " " COPYRIGHT " by Digerati Dreams "__AMIGADATE__;

void  main(int, char **);
void _CXBRK(void);
void  Usage(char *str);

BPTR               sout;
char               Ext[4];

struct USER_DATA   StUser;
struct Ram_File    RStruct;

struct Library    *DLGBase = NULL;
struct LangStruct *ls;
char             **SA;


void main(int argc, char *argv[])
{
   int    fp;
   struct Msg_Area Area;
   struct Msg_Log  Log;

   char   MsgScan  =   2;
   char   NameFlag = FALSE;
   char   filename[80];
   char   Name    [36];

   if (!(DLGBase = OpenLibrary(DLGNAME, DLGVERSION)))  exit(0);

   sout = Output();

   if (GetDevName(Ext)==-1)
   {
      Usage("Must be run from online");
      _CXBRK();
   }

   ReadUser(&RStruct,&StUser,Ext);

   if (!(ls = GetLang(Ext)))  _CXBRK();
   SA = ls->strings;

/// parse args
   if (argc<2)  Usage(NULL);

   while(--argc>0)
   {
      char  *s;

      s = *++argv;
      if (*s++ == '-')
      {
         while(*s)
         {
            switch(*s++)
            {
               case 'h':
               case 'H':  Usage(NULL);
               break;

               case 'm':
               case 'M':  MsgScan=1;
               break;

               case 'f':
               case 'F':  MsgScan=0;
               break;

               case 'n':
               case 'N':  if (!--argc)  break;
               strncpy(Name, *++argv, 35);
               NameFlag = TRUE;
               break;
            }
         }
      }
      else
      Usage(NULL);
   }
//-

   if (!NameFlag || MsgScan==2)  Usage(NULL);
   DeScore(Name);

   if ((fp=open(MsgScan?"MSG:Area.bbs":"FILE:Area.bbs",O_RDONLY))==EOF)
   {
      CloseLibrary(DLGBase);
      exit(5);
   }

   while(read(fp,&Area,sizeof(Area))==sizeof(Area))
   {
      long   high;
      long   dummy;

      if (EnterArea(Area.Number, MsgScan?MSGLOCK:FILELOCK) != RMNOERR)  continue;

      ASPrintf(&StUser, filename, MsgScan?"MSG:%d/User.msg":"FILE:%d/User.file", Area.Number);
      strcpy(Log.Name, Name);

      if (GetStruct(filename,(char *)&Log,sizeof(Log),36)!=-1)
      {
         AFPrintf(&StUser, sout, SA[28],Area.Number);

         if (MsgScan)
            GetHiLowPointers(Area.Number,"",&dummy,&high,"XXX");
         else
            GetHiLowFPointers(Area.Number,"",&dummy,&high,"XXX");

         Log.High_Mess=high;

         if (AddStruct(filename,(char *)&Log,sizeof(Log),36)!=-1)
            AFPrintf(&StUser, sout, SA[29]);
         else
            AFPrintf(&StUser, sout, SA[30]);

         LeaveArea(Area.Number,MsgScan?MSGLOCK:FILELOCK);
         continue;
      }

      LeaveArea(Area.Number,MsgScan?MSGLOCK:FILELOCK);
   }

   close(fp);
   AFPrintf(&StUser, sout, SA[31]);
   _CXBRK();
}


void _CXBRK()
{
   CloseLibrary(DLGBase);
   exit(0);
}


void Usage(char *str)

{
   if (str)  AFPrintf(&StUser, sout, "\n%s\n",str);

   AFPrintf(&StUser, sout, "\nUsage: Catchup -n <first_last> -m or -f\n\n");
   AFPrintf(&StUser, sout, " where -m selects message catchup\n");
   AFPrintf(&StUser, sout, " where -f selects file catchup\n");
   AFPrintf(&StUser, sout, " where first_last is the underscored username (%UNAME)\n\n");

   CloseLibrary(DLGBase);
   exit(5);
}
